/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import java.math.BigInteger;
import water.H2O;
import water.Key;
import water.MRTask;
import water.RPC;
import water.fvec.Frame;
import water.fvec.Vec;
import water.rapids.RadixCount;
import water.rapids.SingleThreadRadixOrder;
import water.rapids.SplitByMSBLocal;
import water.util.ArrayUtils;
import water.util.Log;
import water.util.MathUtils;

class RadixOrder
extends H2O.H2OCountedCompleter<RadixOrder> {
    private final Frame _DF;
    private final boolean _isLeft;
    private final int[] _whichCols;
    private final int[][] _id_maps;
    final boolean[] _isInt;
    final boolean[] _isCategorical;
    final int[] _shift;
    final int[] _bytesUsed;
    final BigInteger[] _base;
    final int[] _ascending;

    RadixOrder(Frame DF, boolean isLeft, int[] whichCols, int[][] id_maps, int[] ascending) {
        this._DF = DF;
        this._isLeft = isLeft;
        this._whichCols = whichCols;
        this._id_maps = id_maps;
        this._shift = new int[this._whichCols.length];
        this._bytesUsed = new int[this._whichCols.length];
        this._base = new BigInteger[this._whichCols.length];
        this._isInt = new boolean[this._whichCols.length];
        this._isCategorical = new boolean[this._whichCols.length];
        this._ascending = ascending;
    }

    @Override
    public void compute2() {
        long t0 = System.nanoTime();
        this.initBaseShift();
        int keySize = ArrayUtils.sum(this._bytesUsed);
        int batchSize = 0x10000000 / Math.max(keySize, 8) / 2;
        long t1 = System.nanoTime();
        System.out.println("Time to use rollup stats to determine biggestBit: " + (double)(t1 - t0) / 1.0E9);
        t0 = t1;
        if (this._whichCols.length > 0) {
            new RadixCount(this._isLeft, this._base[0], this._shift[0], this._whichCols[0], this._isLeft ? this._id_maps : (int[][])null, this._ascending[0]).doAll(this._DF.vec(this._whichCols[0]));
        }
        t1 = System.nanoTime();
        System.out.println("Time of MSB count MRTask left local on each node (no reduce): " + (double)(t1 - t0) / 1.0E9);
        t0 = t1;
        Key linkTwoMRTask = Key.make();
        if (this._whichCols.length > 0) {
            new SplitByMSBLocal(this._isLeft, this._base, this._shift[0], keySize, batchSize, this._bytesUsed, this._whichCols, linkTwoMRTask, this._id_maps, this._ascending).doAll(this._DF.vecs(this._whichCols));
        }
        t1 = System.nanoTime();
        System.out.println("SplitByMSBLocal MRTask (all local per node, no network) took : " + (double)(t1 - t0) / 1.0E9);
        t0 = t1;
        if (this._whichCols.length > 0) {
            new SendSplitMSB(linkTwoMRTask).doAllNodes();
        }
        t1 = System.nanoTime();
        System.out.println("SendSplitMSB across all nodes took : " + (double)(t1 - t0) / 1.0E9);
        t0 = t1;
        RPC[] radixOrders = new RPC[256];
        System.out.print("Sending SingleThreadRadixOrder async RPC calls ... ");
        for (int i = 0; i < 256; ++i) {
            radixOrders[i] = new RPC<SingleThreadRadixOrder>(SplitByMSBLocal.ownerOfMSB(i), new SingleThreadRadixOrder(this._DF, this._isLeft, batchSize, keySize, i)).call();
        }
        t1 = System.nanoTime();
        System.out.println("took : " + (double)(t1 - t0) / 1.0E9);
        t0 = t1;
        System.out.print("Waiting for RPC SingleThreadRadixOrder to finish ... ");
        for (RPC rpc : radixOrders) {
            rpc.get();
        }
        System.out.println("took " + (double)(System.nanoTime() - t0) / 1.0E9);
        this.tryComplete();
    }

    private void initBaseShift() {
        for (int i = 0; i < this._whichCols.length; ++i) {
            Vec col = this._DF.vec(this._whichCols[i]);
            BigInteger max = BigInteger.ZERO;
            this._isInt[i] = col.isCategorical() || col.isInt();
            this._isCategorical[i] = col.isCategorical();
            if (col.isCategorical()) {
                this._base[i] = BigInteger.ZERO;
                if (this._isLeft) {
                    assert (this._id_maps[i] != null);
                    max = BigInteger.valueOf(ArrayUtils.maxValue(this._id_maps[i]));
                } else {
                    max = BigInteger.valueOf((long)col.max());
                }
            } else {
                double colMin = col.min();
                double colMax = col.max();
                if (col.isInt()) {
                    this._base[i] = BigInteger.valueOf(Math.min((long)colMin, (long)colMax * (long)this._ascending[i]));
                    max = BigInteger.valueOf(Math.max((long)colMax, (long)colMin * (long)this._ascending[i]));
                } else {
                    this._base[i] = MathUtils.convertDouble2BigInteger(Math.min(col.min(), colMax * (double)this._ascending[i]));
                    max = MathUtils.convertDouble2BigInteger(Math.max(col.max(), colMin * (double)this._ascending[i]));
                }
            }
            long chk = this.computeShift(max, i);
            if (chk == 256L) {
                chk = this.computeShift(max, i);
            }
            assert (chk <= 255L);
            assert (chk >= 0L);
            this._bytesUsed[i] = Math.min(8, (this._shift[i] + 15) / 8);
        }
    }

    private long computeShift(BigInteger max, int i) {
        int biggestBit = 0;
        int rangeD = max.subtract(this._base[i]).add(BigInteger.ONE).add(BigInteger.ONE).bitLength();
        int n = this._isInt[i] ? rangeD : (biggestBit = rangeD == 64 ? 64 : rangeD + 1);
        if (biggestBit < 8) {
            Log.warn("biggest bit should be >= 8 otherwise need to dip into next column (TODO)");
        }
        assert (biggestBit >= 1);
        this._shift[i] = Math.max(8, biggestBit) - 8;
        long MSBwidth = 1L << this._shift[i];
        BigInteger msbWidth = BigInteger.valueOf(MSBwidth);
        if (this._base[i].mod(msbWidth).compareTo(BigInteger.ZERO) != 0) {
            BigInteger bigInteger = this._isInt[i] ? msbWidth.multiply(this._base[i].divide(msbWidth).add(this._base[i].signum() < 0 ? BigInteger.valueOf(-1L) : BigInteger.ZERO)) : (this._base[i] = msbWidth.multiply(this._base[i].divide(msbWidth)));
            assert (this._base[i].mod(msbWidth).compareTo(BigInteger.ZERO) == 0);
        }
        return max.subtract(this._base[i]).add(BigInteger.ONE).shiftRight(this._shift[i]).intValue();
    }

    private static class SendSplitMSB
    extends MRTask<SendSplitMSB> {
        final Key _linkTwoMRTask;

        SendSplitMSB(Key linkTwoMRTask) {
            this._linkTwoMRTask = linkTwoMRTask;
        }

        @Override
        public void setupLocal() {
            SplitByMSBLocal.MOVESHASH.get(this._linkTwoMRTask).sendSplitMSB();
            SplitByMSBLocal.MOVESHASH.remove(this._linkTwoMRTask);
        }
    }
}

