/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.prims.mungers;

import java.util.Arrays;
import water.H2O;
import water.Key;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.rapids.Env;
import water.rapids.Val;
import water.rapids.ast.AstPrimitive;
import water.rapids.ast.AstRoot;
import water.rapids.vals.ValFrame;

public class AstFillNA
extends AstPrimitive {
    @Override
    public String[] args() {
        return new String[]{"ary", "method", "axis", "limit"};
    }

    @Override
    public String str() {
        return "h2o.fillna";
    }

    @Override
    public int nargs() {
        return 5;
    }

    @Override
    public Val apply(Env env, Env.StackHelp stk, AstRoot[] asts) {
        Frame fr = stk.track(asts[1].exec(env)).getFrame();
        String method = asts[2].exec(env).getStr();
        if (!Arrays.asList("forward", "backward").contains(method.toLowerCase())) {
            throw new IllegalArgumentException("Method must be forward or backward");
        }
        if (method.toLowerCase() == "backward") {
            throw H2O.unimpl("Backward fillna not implemented yet");
        }
        int axis = (int)asts[3].exec(env).getNum();
        if (!Arrays.asList(0, 1).contains(axis)) {
            throw new IllegalArgumentException("Axis must be 0 for columnar 1 for row");
        }
        int limit = (int)asts[4].exec(env).getNum();
        Frame res = axis == 0 ? ((FillForwardTaskCol)new FillForwardTaskCol(limit).doAll(fr.numCols(), (byte)3, fr)).outputFrame() : ((FillForwardTaskRow)new FillForwardTaskRow(limit).doAll(fr.numCols(), (byte)3, fr)).outputFrame();
        res._key = Key.make();
        return new ValFrame(res);
    }

    private static class FillForwardTaskCol
    extends MRTask<FillForwardTaskCol> {
        private final int _maxLen;

        FillForwardTaskCol(int maxLen) {
            this._maxLen = maxLen;
        }

        @Override
        public void map(Chunk[] cs, NewChunk[] nc) {
            for (int i = 0; i < cs.length; ++i) {
                for (int j = 0; j < cs[i]._len; ++j) {
                    if (cs[i].isNA(j)) {
                        if (j < this._maxLen) {
                            int searchCount = 0;
                            Chunk searchChunk = cs[i];
                            int searchStartIdx = j;
                            int searchIdx = 0;
                            while (searchChunk != null && searchCount < this._maxLen && searchChunk.isNA(searchStartIdx - searchIdx)) {
                                if (searchStartIdx - searchCount == 0) {
                                    if (searchChunk.cidx() > 0) {
                                        searchChunk = searchChunk.vec().chunkForChunkIdx(searchChunk.cidx() - 1);
                                        searchStartIdx = searchChunk.len() - 1;
                                        searchIdx = 0;
                                        ++searchCount;
                                        continue;
                                    }
                                    searchChunk = null;
                                }
                                ++searchIdx;
                                ++searchCount;
                            }
                            if (searchChunk == null) {
                                nc[i].addNA();
                                continue;
                            }
                            double fillVal = searchChunk.atd(searchStartIdx - searchIdx);
                            int fillCount = this._maxLen - searchCount;
                            fillCount = Math.min(fillCount, cs[i]._len);
                            int maxFill = 1;
                            int k = 1;
                            while (cs[i].isNA(j + k)) {
                                ++k;
                                ++maxFill;
                            }
                            if ((fillCount = Math.min(maxFill, fillCount)) < 0) {
                                nc[i].addNA();
                            } else if (fillCount == 0) {
                                nc[i].addNum(fillVal);
                            } else {
                                for (int f = 0; f < fillCount; ++f) {
                                    nc[i].addNum(fillVal);
                                }
                            }
                            fillCount = Math.max(1, fillCount);
                            j += fillCount - 1;
                            continue;
                        }
                        nc[i].addNA();
                        continue;
                    }
                    if (j < cs[i]._len - 1 && !cs[i].isNA(j) && cs[i].isNA(j + 1)) {
                        int fillCount;
                        double fillVal = cs[i].atd(j);
                        nc[i].addNum(fillVal);
                        ++j;
                        for (fillCount = 0; j + fillCount < cs[i]._len && fillCount < this._maxLen && cs[i].isNA(j + fillCount); ++fillCount) {
                            nc[i].addNum(fillVal);
                        }
                        j += fillCount - 1;
                        continue;
                    }
                    nc[i].addNum(cs[i].atd(j));
                }
            }
        }
    }

    private static class FillForwardTaskRow
    extends MRTask<FillForwardTaskRow> {
        private final int _maxLen;

        FillForwardTaskRow(int maxLen) {
            this._maxLen = maxLen;
        }

        @Override
        public void map(Chunk[] cs, NewChunk[] nc) {
            for (int i = 0; i < cs[0]._len; ++i) {
                int fillCount = 0;
                nc[0].addNum(cs[0].atd(i));
                for (int j = 1; j < cs.length; ++j) {
                    if (cs[j].isNA(i)) {
                        if (!nc[j - 1].isNA(i) && fillCount < this._maxLen) {
                            nc[j].addNum(nc[j - 1].atd(i));
                            ++fillCount;
                            continue;
                        }
                        nc[j].addNA();
                        continue;
                    }
                    if (fillCount > 0) {
                        fillCount = 0;
                    }
                    nc[j].addNum(cs[j].atd(i));
                }
            }
        }
    }
}

