/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.prims.operators;

import water.rapids.Env;
import water.rapids.Val;
import water.rapids.ast.AstRoot;
import water.rapids.ast.prims.operators.AstBinOp;

public class AstLOr
extends AstBinOp {
    @Override
    public String str() {
        return "||";
    }

    @Override
    public Val apply(Env env, Env.StackHelp stk, AstRoot[] asts) {
        double d;
        Val left = stk.track(asts[1].exec(env));
        if (left.isNum() && (d = left.getNum()) == 1.0) {
            return left;
        }
        Val rite = stk.track(asts[2].exec(env));
        return this.prim_apply(left, rite);
    }

    @Override
    public double op(double l, double r) {
        return AstLOr.or_op(l, r);
    }

    public static double or_op(double l, double r) {
        return l == 1.0 || r == 1.0 ? 1.0 : (Double.isNaN(l) || Double.isNaN(r) ? Double.NaN : 0.0);
    }
}

