/*
 * Decompiled with CFR 0.152.
 */
package water.util;

import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import water.H2O;
import water.Iced;
import water.MRTask;
import water.util.Log;
import water.util.SB;
import water.util.TwoDimTable;

public class JStackCollectorTask
extends MRTask<JStackCollectorTask> {
    public DStackTrace[] _traces;

    JStackCollectorTask() {
        super((byte)119);
    }

    @Override
    public void reduce(JStackCollectorTask that) {
        for (int i = 0; i < this._traces.length; ++i) {
            if (this._traces[i] != null) continue;
            this._traces[i] = that._traces[i];
        }
    }

    private int isH2OHTTPRequestThread(StackTraceElement[] elms) {
        for (int i = 0; i < elms.length; ++i) {
            if (!elms[i].getClassName().equals("water.JettyHTTPD$H2oDefaultServlet")) continue;
            return i;
        }
        return elms.length;
    }

    @Override
    public void setupLocal() {
        this._traces = new DStackTrace[H2O.CLOUD.size()];
        if (H2O.SELF._heartbeat._client) {
            return;
        }
        Map<Thread, StackTraceElement[]> allStackTraces = Thread.getAllStackTraces();
        ArrayList<String> http_traces = new ArrayList<String>();
        http_traces.add("HttpReq traces");
        ArrayList<String> fj_traces = new ArrayList<String>();
        fj_traces.add("FJ traces");
        ArrayList<String> other_traces = new ArrayList<String>();
        other_traces.add("'other' traces");
        ArrayList<String> tcp_traces = new ArrayList<String>();
        tcp_traces.add("TCP traces");
        ArrayList<String> system_traces = new ArrayList<String>();
        system_traces.add("system traces");
        ArrayList<String> jetty_traces = new ArrayList<String>();
        jetty_traces.add("Jetty traces");
        ArrayList<String> h2o_sys_traces = new ArrayList<String>();
        h2o_sys_traces.add("H2O System traces");
        TreeMap<Integer, ThreadInfo> fjThreadSummary = new TreeMap<Integer, ThreadInfo>();
        ThreadInfo threadSum = new ThreadInfo();
        ThreadInfo httpReqs = new ThreadInfo();
        ThreadInfo tcpThreads = new ThreadInfo();
        ThreadInfo otherThreads = new ThreadInfo();
        ThreadInfo jettythreads = new ThreadInfo();
        ThreadInfo h2oSysThreads = new ThreadInfo();
        ThreadInfo systemThreads = new ThreadInfo();
        for (Map.Entry<Thread, StackTraceElement[]> el : allStackTraces.entrySet()) {
            StackTraceElement[] elms = el.getValue();
            Thread thread = el.getKey();
            int idx = elms.length;
            ArrayList<String> trace = null;
            ThreadInfo tinfo = null;
            if (elms.length == 0) continue;
            if (thread.getName().startsWith("FJ-") && ((StackTraceElement)elms[elms.length - 1]).getClassName().contains("ForkJoinWorkerThread")) {
                trace = fj_traces;
                Integer fjq = Integer.parseInt(thread.getName().substring(3, thread.getName().indexOf(45, 3)));
                if (!fjThreadSummary.containsKey(fjq)) {
                    fjThreadSummary.put(fjq, new ThreadInfo());
                }
                tinfo = (ThreadInfo)fjThreadSummary.get(fjq);
            } else if (((StackTraceElement)elms[elms.length - 1]).getClassName().equals("water.TCPReceiverThread$TCPReaderThread")) {
                if (((StackTraceElement)elms[elms.length - 2]).getClassName().equals("water.AutoBuffer") && ((StackTraceElement)elms[elms.length - 2]).getMethodName().equals("<init>")) {
                    ++tcpThreads._parked;
                    continue;
                }
                trace = tcp_traces;
                tinfo = tcpThreads;
            } else if (((StackTraceElement)elms[elms.length - 1]).getClassName().equals("water.MultiReceiverThread") || ((StackTraceElement)elms[elms.length - 1]).getClassName().equals("water.TCPReceiverThread") || ((StackTraceElement)elms[elms.length - 1]).getClassName().equals("water.UDPReceiverThread") || ((StackTraceElement)elms[elms.length - 1]).getClassName().equals("water.HeartBeatThread")) {
                trace = h2o_sys_traces;
                tinfo = h2oSysThreads;
            } else if (elms.length > 1 && ((StackTraceElement)elms[elms.length - 2]).getClassName().startsWith("java.util.concurrent.ThreadPoolExecutor") || ((StackTraceElement)elms[elms.length - 1]).getClassName().startsWith("java.lang.ref.Finalizer") || ((StackTraceElement)elms[elms.length - 1]).getClassName().startsWith("java.lang.ref.Reference")) {
                trace = system_traces;
                tinfo = systemThreads;
            } else {
                idx = this.isH2OHTTPRequestThread(elms);
                if (idx < elms.length) {
                    trace = http_traces;
                    tinfo = httpReqs;
                } else if (elms.length > 1 && ((StackTraceElement)elms[elms.length - 2]).getClassName().startsWith("org.eclipse.jetty")) {
                    trace = jetty_traces;
                    tinfo = jettythreads;
                } else {
                    trace = other_traces;
                    tinfo = otherThreads;
                }
            }
            if (((StackTraceElement)elms[0]).getClassName().equals("sun.misc.Unsafe") && ((StackTraceElement)elms[0]).getMethodName().equals("park")) {
                ++tinfo._parked;
                continue;
            }
            if (thread.getState().toString().equals("RUNNABLE")) {
                ++tinfo._active;
            } else if (thread.getState().toString().contains("WAITING")) {
                ++tinfo._blocked;
            } else {
                ++tinfo._unknown;
                System.out.println("UNKNOWN STATE: " + (Object)((Object)thread.getState()));
            }
            SB sb = new SB().p('\"').p(thread.getName()).p('\"');
            if (thread.isDaemon()) {
                sb.p(" daemon");
            }
            sb.p(" prio=").p(thread.getPriority());
            sb.p(" tid=").p(thread.getId());
            sb.p(" java.lang.Thread.State: ").p(thread.getState().toString());
            sb.nl();
            for (int j = 0; j < idx; ++j) {
                sb.p("\tat ").p(((StackTraceElement)elms[j]).toString()).nl();
            }
            trace.add(sb.toString());
        }
        ArrayList<String> rowNames = new ArrayList<String>();
        ArrayList<double[]> cellVals = new ArrayList<double[]>();
        if (httpReqs.hasAny()) {
            rowNames.add("HttpReq");
            cellVals.add(httpReqs.toDoubleArray());
        }
        for (Map.Entry entry : fjThreadSummary.entrySet()) {
            rowNames.add("FJ-" + entry.getKey());
            ThreadInfo fjt = (ThreadInfo)entry.getValue();
            threadSum.add(fjt);
            cellVals.add(fjt.toDoubleArray());
        }
        if (otherThreads.hasAny()) {
            rowNames.add("other");
            cellVals.add(otherThreads.toDoubleArray());
        }
        if (tcpThreads.hasAny()) {
            rowNames.add("TCP");
            cellVals.add(tcpThreads.toDoubleArray());
        }
        if (h2oSysThreads.hasAny()) {
            rowNames.add("h2osys");
            cellVals.add(h2oSysThreads.toDoubleArray());
        }
        if (systemThreads.hasAny()) {
            rowNames.add("system");
            cellVals.add(systemThreads.toDoubleArray());
        }
        if (jettythreads.hasAny()) {
            rowNames.add("jetty");
            cellVals.add(jettythreads.toDoubleArray());
        }
        rowNames.add("TOTAL");
        cellVals.add(threadSum.add(httpReqs).add(otherThreads).add(tcpThreads).add(systemThreads).add(jettythreads).toDoubleArray());
        TwoDimTable td = new TwoDimTable("Thread Summary", "Summary of running threads", rowNames.toArray(new String[0]), new String[]{"active", "blocked", "idle", "TOTAL"}, new String[]{"int", "int", "int", "int"}, new String[]{"%d", "%d", "%d", "%d"}, "Thread", new String[cellVals.size()][], (double[][])cellVals.toArray((T[])new double[0][0]));
        String[] stringArray = new String[1 + http_traces.size() + fj_traces.size() + other_traces.size() + tcp_traces.size() + h2o_sys_traces.size() + system_traces.size() + jetty_traces.size()];
        int ii = 1;
        for (String t : http_traces) {
            stringArray[ii++] = t;
            Log.info(t);
        }
        for (String t : fj_traces) {
            stringArray[ii++] = t;
            Log.info(t);
        }
        for (String t : other_traces) {
            stringArray[ii++] = t;
            Log.info(t);
        }
        for (String t : tcp_traces) {
            stringArray[ii++] = t;
            Log.info(t);
        }
        for (String t : h2o_sys_traces) {
            stringArray[ii++] = t;
            Log.info(t);
        }
        for (String t : system_traces) {
            stringArray[ii++] = t;
            Log.info(t);
        }
        for (String t : jetty_traces) {
            stringArray[ii++] = t;
            Log.info(t);
        }
        stringArray[0] = td.toString();
        Log.info(stringArray[0]);
        this._traces[H2O.SELF.index()] = new DStackTrace(stringArray);
    }

    private static class ThreadKey
    implements Comparable<ThreadKey> {
        ThreadType _type;

        private ThreadKey() {
        }

        @Override
        public int compareTo(ThreadKey o) {
            return this._type.ordinal() - o._type.ordinal();
        }

        public String toString() {
            return this._type.toString();
        }
    }

    static enum ThreadType {
        HTTP_REQUEST,
        FJ,
        OTHER,
        TCP,
        JETTY,
        HADOOP;

    }

    private static class ThreadInfo {
        int _parked;
        int _active;
        int _blocked;
        int _unknown;

        private ThreadInfo() {
        }

        public ThreadInfo add(ThreadInfo ti) {
            this._parked += ti._parked;
            this._active += ti._active;
            this._blocked += ti._blocked;
            this._unknown += ti._unknown;
            return this;
        }

        public double[] toDoubleArray() {
            return new double[]{this._active + this._unknown, this._blocked, this._parked, this._active + this._unknown + this._blocked + this._parked};
        }

        public boolean hasAny() {
            return this._parked + this._active + this._blocked + this._unknown > 0;
        }
    }

    public static class DStackTrace
    extends Iced {
        public final String _node = H2O.getIpPortString();
        public final long _time = System.currentTimeMillis();
        public final String[] _thread_traces;

        DStackTrace(String[] traces) {
            this._thread_traces = traces;
        }
    }
}

