/*
 * Decompiled with CFR 0.152.
 */
package hex;

import hex.AUC2;
import hex.ConfusionMatrix;
import hex.Model;
import hex.ModelMetrics;
import hex.ModelMetricsSupervised;
import water.exceptions.H2OIllegalArgumentException;
import water.fvec.Frame;
import water.util.ArrayUtils;
import water.util.MathUtils;

public class ModelMetricsBinomial
extends ModelMetricsSupervised {
    public final AUC2 _auc;
    public final double _logloss;

    public ModelMetricsBinomial(Model model, Frame frame, double mse, String[] domain, double sigma, AUC2 auc, double logloss) {
        super(model, frame, mse, domain, sigma);
        this._auc = auc;
        this._logloss = logloss;
    }

    public static ModelMetricsBinomial getFromDKV(Model model, Frame frame) {
        ModelMetrics mm = ModelMetrics.getFromDKV(model, frame);
        if (!(mm instanceof ModelMetricsBinomial)) {
            throw new H2OIllegalArgumentException("Expected to find a Binomial ModelMetrics for model: " + model._key.toString() + " and frame: " + frame._key.toString(), "Expected to find a ModelMetricsBinomial for model: " + model._key.toString() + " and frame: " + frame._key.toString() + " but found a: " + (mm == null ? null : mm.getClass()));
        }
        return (ModelMetricsBinomial)mm;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        if (this._auc != null) {
            sb.append(" AUC: " + (float)this._auc._auc + "\n");
        }
        sb.append(" logloss: " + (float)this._logloss + "\n");
        if (this.cm() != null) {
            sb.append(" CM: " + this.cm().toASCII());
        }
        return sb.toString();
    }

    public double logloss() {
        return this._logloss;
    }

    @Override
    public AUC2 auc() {
        return this._auc;
    }

    @Override
    public ConfusionMatrix cm() {
        if (this._auc == null) {
            return null;
        }
        double[][] cm = this._auc.defaultCM();
        return cm == null ? null : new ConfusionMatrix(cm, this._domain);
    }

    public static class MetricBuilderBinomial<T extends MetricBuilderBinomial<T>>
    extends ModelMetricsSupervised.MetricBuilderSupervised<T> {
        protected double _logloss;
        protected AUC2.AUCBuilder _auc = new AUC2.AUCBuilder(400);

        public MetricBuilderBinomial(String[] domain) {
            super(2, domain);
        }

        public double auc() {
            return new AUC2((AUC2.AUCBuilder)this._auc)._auc;
        }

        @Override
        public double[] perRow(double[] ds, float[] yact, Model m) {
            return this.perRow(ds, yact, 1.0, 0.0, m);
        }

        @Override
        public double[] perRow(double[] ds, float[] yact, double w, double o, Model m) {
            if (Float.isNaN(yact[0])) {
                return ds;
            }
            if (ArrayUtils.hasNaNs(ds)) {
                return ds;
            }
            if (w == 0.0 || Double.isNaN(w)) {
                return ds;
            }
            int iact = (int)yact[0];
            if (iact != 0 && iact != 1) {
                return ds;
            }
            ++this._count;
            this._wcount += w;
            this._wY += w * (double)iact;
            this._wYY += w * (double)iact * (double)iact;
            double err = iact + 1 < ds.length ? 1.0 - ds[iact + 1] : 1.0;
            this._sumsqe += w * err * err;
            assert (!Double.isNaN(this._sumsqe));
            double eps = 1.0E-15;
            this._logloss -= w * Math.log(Math.max(1.0E-15, 1.0 - err));
            this._auc.perRow(ds[2], iact, w);
            return ds;
        }

        @Override
        public void reduce(T mb) {
            super.reduce(mb);
            this._logloss += ((MetricBuilderBinomial)mb)._logloss;
            this._auc.reduce(((MetricBuilderBinomial)mb)._auc);
        }

        @Override
        public ModelMetrics makeModelMetrics(Model m, Frame f) {
            double mse = Double.NaN;
            double logloss = Double.NaN;
            double sigma = Double.NaN;
            if (this._wcount > 0.0) {
                sigma = this.weightedSigma();
                mse = this._sumsqe / this._wcount;
                logloss = this._logloss / this._wcount;
                AUC2 auc = new AUC2(this._auc);
                return ((Model.Output)m._output).addModelMetrics(new ModelMetricsBinomial(m, f, mse, this._domain, sigma, auc, logloss));
            }
            return ((Model.Output)m._output).addModelMetrics(new ModelMetricsBinomial(m, f, mse, null, sigma, null, logloss));
        }

        public String toString() {
            if (this._wcount == 0.0) {
                return "empty, no rows";
            }
            return "auc = " + MathUtils.roundToNDigits(this.auc(), 3) + ", logloss = " + this._logloss / this._wcount;
        }
    }
}

