/*
 * Decompiled with CFR 0.152.
 */
package hex;

import hex.ModelMetrics;
import hex.ModelMetricsBinomial;
import hex.ModelMetricsMultinomial;
import hex.ModelMetricsRegression;
import hex.ModelMetricsSupervised;
import water.Iced;
import water.util.MathUtils;

public class ScoreKeeper
extends Iced {
    public double _r2 = Double.NaN;
    public double _mean_residual_deviance = Double.NaN;
    public double _mse = Double.NaN;
    public double _logloss = Double.NaN;
    public double _AUC = Double.NaN;
    public double _classError = Double.NaN;
    public float[] _hitratio;

    public ScoreKeeper() {
    }

    public ScoreKeeper(double mse) {
        this._mse = mse;
    }

    public ScoreKeeper(ModelMetrics mm) {
        this.fillFrom(mm);
    }

    public void fillFrom(ModelMetrics m) {
        if (m == null) {
            return;
        }
        this._mse = m._MSE;
        if (m instanceof ModelMetricsSupervised) {
            this._r2 = ((ModelMetricsSupervised)m).r2();
        }
        if (m instanceof ModelMetricsRegression) {
            this._mean_residual_deviance = ((ModelMetricsRegression)m)._mean_residual_deviance;
        }
        if (m instanceof ModelMetricsBinomial) {
            this._logloss = ((ModelMetricsBinomial)m)._logloss;
            if (((ModelMetricsBinomial)m)._auc != null) {
                this._AUC = ((ModelMetricsBinomial)m)._auc._auc;
                this._classError = ((ModelMetricsBinomial)m)._auc.defaultErr();
            }
        } else if (m instanceof ModelMetricsMultinomial) {
            this._logloss = ((ModelMetricsMultinomial)m)._logloss;
            this._classError = ((ModelMetricsMultinomial)m)._cm.err();
            this._hitratio = ((ModelMetricsMultinomial)m)._hit_ratios;
        }
    }

    public boolean equals(Object that) {
        if (!(that instanceof ScoreKeeper)) {
            return false;
        }
        ScoreKeeper o = (ScoreKeeper)that;
        if (this._hitratio == null && ((ScoreKeeper)that)._hitratio != null) {
            return false;
        }
        if (this._hitratio != null && ((ScoreKeeper)that)._hitratio == null) {
            return false;
        }
        if (this._hitratio != null && ((ScoreKeeper)that)._hitratio != null) {
            if (this._hitratio.length != ((ScoreKeeper)that)._hitratio.length) {
                return false;
            }
            for (int i = 0; i < this._hitratio.length; ++i) {
                if (MathUtils.compare(this._hitratio[i], ((ScoreKeeper)that)._hitratio[i], 1.0E-6, 1.0E-6)) continue;
                return false;
            }
        }
        return MathUtils.compare(this._r2, o._r2, 1.0E-6, 1.0E-6) && MathUtils.compare(this._mean_residual_deviance, o._mean_residual_deviance, 1.0E-6, 1.0E-6) && MathUtils.compare(this._mse, o._mse, 1.0E-6, 1.0E-6) && MathUtils.compare(this._logloss, o._logloss, 1.0E-6, 1.0E-6) && MathUtils.compare(this._classError, o._classError, 1.0E-6, 1.0E-6);
    }
}

