/*
 * Decompiled with CFR 0.152.
 */
package hex.grid;

import hex.Model;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import water.Futures;
import water.H2O;
import water.Iced;
import water.Key;
import water.Lockable;
import water.fvec.Frame;
import water.util.ArrayUtils;
import water.util.IcedHashMap;
import water.util.IcedLong;
import water.util.PojoUtils;
import water.util.StringUtils;

public class Grid<MP extends Model.Parameters>
extends Lockable<Grid<MP>> {
    public static final Grid GRID_PROTO = new Grid<Object>(null, null, null, null, null);
    private final IcedHashMap<IcedLong, Key<Model>> _cache = new IcedHashMap();
    private final MP _params;
    private MP[] _failed_params;
    private String[] _failure_details;
    private String[] _failure_stack_traces;
    private String[][] _failed_raw_params;
    private final String _modelName;
    private final String[] _hyper_names;
    private final PojoUtils.FieldNaming _field_naming_strategy;

    protected Grid(Key key, MP params, String[] hyperNames, String modelName, PojoUtils.FieldNaming fieldNaming) {
        super(key);
        this._params = params != null ? (Model.Parameters)((Iced)params).clone() : null;
        this._hyper_names = hyperNames;
        this._modelName = modelName;
        Class<?> paramsClass = params != null ? params.getClass() : null;
        this._failed_params = paramsClass != null ? (Model.Parameters[])Array.newInstance(paramsClass, 0) : null;
        this._failure_details = new String[0];
        this._failed_raw_params = new String[0][];
        this._failure_stack_traces = new String[0];
        this._field_naming_strategy = fieldNaming;
    }

    public String getModelName() {
        return this._modelName;
    }

    public Frame getTrainingFrame() {
        return ((Model.Parameters)this._params).train();
    }

    public Model getModel(MP params) {
        Key<Model> mKey = this.getModelKey(params);
        return mKey != null ? mKey.get() : null;
    }

    public Key<Model> getModelKey(MP params) {
        long checksum = ((Model.Parameters)params).checksum();
        return this.getModelKey(checksum);
    }

    Key<Model> getModelKey(long paramsChecksum) {
        Key mKey = (Key)this._cache.get(IcedLong.valueOf(paramsChecksum));
        return mKey;
    }

    synchronized Key<Model> putModel(long checksum, Key<Model> modelKey) {
        return this._cache.put(IcedLong.valueOf(checksum), modelKey);
    }

    private void appendFailedModelParameters(MP params, String[] rawParams, String failureDetails, String stackTrace) {
        assert (rawParams != null) : "API has to always pass rawParams";
        MP[] a = this._failed_params;
        Model.Parameters[] na = (Model.Parameters[])Arrays.copyOf(a, a.length + 1);
        na[a.length] = params;
        this._failed_params = na;
        String[] m = this._failure_details;
        String[] nm = Arrays.copyOf(m, m.length + 1);
        nm[m.length] = failureDetails;
        this._failure_details = nm;
        String[][] rp = this._failed_raw_params;
        String[][] nrp = (String[][])Arrays.copyOf(rp, rp.length + 1);
        nrp[rp.length] = rawParams;
        this._failed_raw_params = nrp;
        String[] st = this._failure_stack_traces;
        String[] nst = Arrays.copyOf(st, st.length + 1);
        nst[st.length] = stackTrace;
        this._failure_stack_traces = nst;
    }

    void appendFailedModelParameters(MP params, Exception e) {
        assert (params != null) : "Model parameters should be always != null !";
        String[] rawParams = ArrayUtils.toString(this.getHyperValues(params));
        this.appendFailedModelParameters(params, rawParams, e.getMessage(), StringUtils.toString(e));
    }

    void appendFailedModelParameters(Object[] rawParams, Exception e) {
        assert (rawParams != null) : "Raw parameters should be always != null !";
        this.appendFailedModelParameters(null, ArrayUtils.toString(rawParams), e.getMessage(), StringUtils.toString(e));
    }

    public Key<Model>[] getModelKeys() {
        return this._cache.values().toArray(new Key[this._cache.size()]);
    }

    public Model[] getModels() {
        Collection modelKeys = this._cache.values();
        Model[] models = new Model[modelKeys.size()];
        int i = 0;
        for (Key mKey : modelKeys) {
            models[i] = mKey != null ? (Model)mKey.get() : null;
            ++i;
        }
        return models;
    }

    public int getModelCount() {
        return this._cache.size();
    }

    public int getFailureCount() {
        return this._failed_params.length;
    }

    public Model.Parameters[] getFailedParameters() {
        return this._failed_params;
    }

    public String[] getFailureDetails() {
        return this._failure_details;
    }

    public String[] getFailureStackTraces() {
        return this._failure_stack_traces;
    }

    public String[][] getFailedRawParameters() {
        return this._failed_raw_params;
    }

    public Object[] getHyperValues(MP parms) {
        Object[] result = new Object[this._hyper_names.length];
        for (int i = 0; i < this._hyper_names.length; ++i) {
            result[i] = PojoUtils.getFieldValue(parms, this._hyper_names[i], this._field_naming_strategy);
        }
        return result;
    }

    public String[] getHyperNames() {
        return this._hyper_names;
    }

    @Override
    protected Futures remove_impl(Futures fs) {
        for (Key k : this._cache.values()) {
            k.remove(fs);
        }
        this._cache.clear();
        return fs;
    }

    @Override
    protected long checksum_impl() {
        throw H2O.unimpl();
    }
}

