/*
 * Decompiled with CFR 0.152.
 */
package hex.quantile;

import hex.ModelBuilder;
import hex.ModelCategory;
import hex.quantile.QuantileModel;
import hex.schemas.ModelBuilderSchema;
import hex.schemas.QuantileV3;
import java.util.Arrays;
import water.DKV;
import water.H2O;
import water.Job;
import water.Key;
import water.MRTask;
import water.Scope;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;
import water.util.ArrayUtils;
import water.util.Log;

public class Quantile
extends ModelBuilder<QuantileModel, QuantileModel.QuantileParameters, QuantileModel.QuantileOutput> {
    public Quantile(QuantileModel.QuantileParameters parms) {
        super("Quantile", parms);
        this.init(false);
    }

    @Override
    public ModelBuilderSchema schema() {
        return new QuantileV3();
    }

    public Quantile trainModelImpl(long work, boolean restartTimer) {
        return (Quantile)this.start(new QuantileDriver(), work, restartTimer);
    }

    @Override
    public long progressUnits() {
        return this.train().numCols() * ((QuantileModel.QuantileParameters)this._parms)._probs.length;
    }

    @Override
    public ModelCategory[] can_build() {
        return new ModelCategory[]{ModelCategory.Unknown};
    }

    @Override
    public ModelBuilder.BuilderVisibility builderVisibility() {
        return ModelBuilder.BuilderVisibility.Stable;
    }

    @Override
    public void init(boolean expensive) {
        super.init(expensive);
        for (double p : ((QuantileModel.QuantileParameters)this._parms)._probs) {
            if (!(p < 0.0) && !(p > 1.0)) continue;
            this.error("_probs", "Probabilities must be between 0 and 1");
        }
    }

    static double computeQuantile(double lo, double hi, long row, long nrows, double prob, QuantileModel.CombineMethod method) {
        if (lo == hi) {
            return lo;
        }
        if (method == null) {
            method = QuantileModel.CombineMethod.INTERPOLATE;
        }
        switch (method) {
            case INTERPOLATE: {
                return Quantile.linearInterpolate(lo, hi, row, nrows, prob);
            }
            case AVERAGE: {
                return 0.5 * (hi + lo);
            }
            case LOW: {
                return lo;
            }
            case HIGH: {
                return hi;
            }
        }
        Log.info("Unknown even sample size quantile combination type: " + (Object)((Object)method) + ". Doing linear interpolation.");
        return Quantile.linearInterpolate(lo, hi, row, nrows, prob);
    }

    private static double linearInterpolate(double lo, double hi, long row, long nrows, double prob) {
        double plo = (double)(row + 0L) / (double)(nrows - 1L);
        double phi = (double)(row + 1L) / (double)(nrows - 1L);
        assert (plo <= prob && prob < phi);
        return lo + (hi - lo) * (prob - plo) / (phi - plo);
    }

    static /* synthetic */ void access$200(Quantile x0) {
        x0.updateModelOutput();
    }

    private static class Histo
    extends MRTask<Histo> {
        private static final int NBINS = 1024;
        private final int _nbins;
        private final double _lb;
        private final double _step;
        private final long _start_row;
        private final long _nrows;
        private final boolean _isInt;
        long[] _bins;
        double[] _mins;
        double[] _maxs;

        private Histo(double lb, double ub, long start_row, long nrows, boolean isInt) {
            boolean is_int = isInt && ub - lb < 1024.0;
            this._nbins = is_int ? (int)(ub - lb + 1.0) : 1024;
            this._lb = lb;
            double ulp = Math.ulp(Math.max(Math.abs(lb), Math.abs(ub)));
            this._step = is_int ? 1.0 : (ub + ulp - lb) / (double)this._nbins;
            this._start_row = start_row;
            this._nrows = nrows;
            this._isInt = isInt;
        }

        @Override
        public void map(Chunk chk) {
            this._bins = new long[this._nbins];
            long[] bins = this._bins;
            this._mins = new double[this._nbins];
            double[] mins = this._mins;
            this._maxs = new double[this._nbins];
            double[] maxs = this._maxs;
            Arrays.fill(this._mins, Double.MAX_VALUE);
            Arrays.fill(this._maxs, -1.7976931348623157E308);
            for (int row = 0; row < chk._len; ++row) {
                double idx;
                double d = chk.atd(row);
                if (Double.isNaN(d) || !(0.0 <= (idx = (d - this._lb) / this._step)) || !(idx < (double)bins.length)) continue;
                int i = (int)idx;
                if (bins[i] == 0L) {
                    mins[i] = maxs[i] = d;
                } else {
                    if (d < mins[i]) {
                        mins[i] = d;
                    }
                    if (d > maxs[i]) {
                        maxs[i] = d;
                    }
                }
                int n = i;
                bins[n] = bins[n] + 1L;
            }
        }

        @Override
        public void reduce(Histo h) {
            for (int i = 0; i < this._nbins; ++i) {
                if (this._mins[i] > h._mins[i]) {
                    this._mins[i] = h._mins[i];
                }
                if (!(this._maxs[i] < h._maxs[i])) continue;
                this._maxs[i] = h._maxs[i];
            }
            ArrayUtils.add(this._bins, h._bins);
        }

        double findQuantile(double prob, QuantileModel.CombineMethod method) {
            double hi;
            double lo;
            double p2 = prob * (double)(this._nrows - 1L);
            long r2 = (long)p2;
            int loidx = this.findBin(r2);
            double d = lo = loidx == this._nbins ? this.binEdge(this._nbins) : this._maxs[loidx];
            if (loidx < this._nbins && (double)r2 == p2 && this._mins[loidx] == lo) {
                return lo;
            }
            long r3 = r2 + 1L;
            int hiidx = this.findBin(r3);
            double d2 = hi = hiidx == this._nbins ? this.binEdge(this._nbins) : this._mins[hiidx];
            if (loidx == hiidx) {
                return lo == hi ? lo : Double.NaN;
            }
            return Quantile.computeQuantile(lo, hi, r2, this._nrows, prob, method);
        }

        private double binEdge(int idx) {
            return this._lb + this._step * (double)idx;
        }

        private int findBin(long row) {
            long sum = this._start_row;
            for (int i = 0; i < this._nbins; ++i) {
                if (row >= (sum += this._bins[i])) continue;
                return i;
            }
            return this._nbins;
        }

        Histo refinePass(double prob) {
            double prow = prob * (double)(this._nrows - 1L);
            long lorow = (long)prow;
            int loidx = this.findBin(lorow);
            assert (loidx < this._nbins);
            double lo = this._mins[loidx];
            long hirow = (double)lorow == prow ? lorow : lorow + 1L;
            int hiidx = this.findBin(hirow);
            double hi = hiidx == this._nbins ? this.binEdge(this._nbins) : this._maxs[hiidx];
            long sum = this._start_row;
            for (int i = 0; i < loidx; ++i) {
                sum += this._bins[i];
            }
            return new Histo(lo, hi, sum, this._nrows, this._isInt);
        }
    }

    public static class QTask
    extends H2O.H2OCountedCompleter<QTask> {
        final double[] _probs;
        final Frame _train;
        final QuantileModel.CombineMethod _combine_method;
        public double[][] _quantiles;

        public QTask(H2O.H2OCountedCompleter cc, double[] probs, Frame train, QuantileModel.CombineMethod combine_method) {
            super(cc);
            this._train = train;
            this._probs = probs;
            this._combine_method = combine_method;
        }

        @Override
        public void compute2() {
            this._quantiles = new double[this._train.numCols()][this._probs.length];
            Vec[] vecs = this._train.vecs();
            for (int n = 0; n < vecs.length; ++n) {
                Vec vec = vecs[n];
                if (vec.isBad()) {
                    this._quantiles[n] = new double[this._probs.length];
                    Arrays.fill(this._quantiles[n], Double.NaN);
                    continue;
                }
                Histo h1 = (Histo)new Histo(vec.min(), vec.max(), 0L, vec.length(), vec.isInt()).doAll(vec);
                for (int p = 0; p < this._probs.length; ++p) {
                    double prob = this._probs[p];
                    Histo h = h1;
                    while (Double.isNaN(this._quantiles[n][p] = h.findQuantile(prob, this._combine_method))) {
                        h = (Histo)h.refinePass(prob).doAll(vec);
                    }
                }
            }
            this.tryComplete();
        }
    }

    private class QuantileDriver
    extends H2O.H2OCountedCompleter<QuantileDriver> {
        private QuantileDriver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        protected void compute2() {
            model = null;
            try {
                Scope.enter();
                ((QuantileModel.QuantileParameters)Quantile.this._parms).read_lock_frames(Quantile.this);
                Quantile.this.init(true);
                model = new QuantileModel(Quantile.this.dest(), (QuantileModel.QuantileParameters)Quantile.this._parms, new QuantileModel.QuantileOutput(Quantile.this));
                ((QuantileModel.QuantileOutput)model._output)._parameters = (QuantileModel.QuantileParameters)Quantile.this._parms;
                ((QuantileModel.QuantileOutput)model._output)._quantiles = new double[Quantile.this.train().numCols()][((QuantileModel.QuantileParameters)Quantile.this._parms)._probs.length];
                model.delete_and_lock(Quantile.this._key);
                vecs = Quantile.this.train().vecs();
                n = 0;
lbl13:
                // 2 sources

                while (n < vecs.length) {
                    if (Quantile.this.isRunning()) ** GOTO lbl-1000
                    ** GOTO lbl34
                }
                ** GOTO lbl63
            }
            catch (Throwable t) {
                try {
                    thisJob = (Job)DKV.getGet(Quantile.this._key);
                    if (thisJob._state != Job.JobState.CANCELLED) {
                        t.printStackTrace();
                        Quantile.this.failed(t);
                        throw t;
                    }
                    Log.info(new Object[]{"Job cancelled by user."});
                }
                catch (Throwable var10_12) {
                    Quantile.access$200(Quantile.this);
                    if (model != null) {
                        model.unlock(Quantile.this._key);
                    }
                    ((QuantileModel.QuantileParameters)Quantile.this._parms).read_unlock_frames(Quantile.this);
                    Scope.exit(new Key[]{model == null ? null : model._key});
                    throw var10_12;
                }
lbl34:
                // 1 sources

                Quantile.access$200(Quantile.this);
                if (model != null) {
                    model.unlock(Quantile.this._key);
                }
                ((QuantileModel.QuantileParameters)Quantile.this._parms).read_unlock_frames(Quantile.this);
                Scope.exit(new Key[]{model == null ? null : model._key});
                return;
lbl-1000:
                // 1 sources

                {
                    vec = vecs[n];
                    if (vec.isBad()) {
                        ((QuantileModel.QuantileOutput)model._output)._quantiles[n] = new double[((QuantileModel.QuantileParameters)Quantile.this._parms)._probs.length];
                        Arrays.fill(((QuantileModel.QuantileOutput)model._output)._quantiles[n], NaN);
                    } else {
                        h1 = (Histo)new Histo(vec.min(), vec.max(), 0L, vec.length() - vec.naCnt(), vec.isInt()).doAll(new Vec[]{vec});
                        for (p = 0; p < ((QuantileModel.QuantileParameters)Quantile.this._parms)._probs.length; ++((QuantileModel.QuantileOutput)model._output)._iterations, ++p) {
                            prob = ((QuantileModel.QuantileParameters)Quantile.this._parms)._probs[p];
                            h = h1;
                            while (Double.isNaN(((QuantileModel.QuantileOutput)model._output)._quantiles[n][p] = h.findQuantile(prob, ((QuantileModel.QuantileParameters)Quantile.this._parms)._combine_method))) {
                                h = (Histo)h.refinePass(prob).doAll(new Vec[]{vec});
                            }
                            model.update(Quantile.this._key);
                            Quantile.this.update(1L);
                        }
                        sb = new StringBuilder();
                        sb.append("Quantile: iter: ").append(((QuantileModel.QuantileOutput)model._output)._iterations).append(" Qs=").append(Arrays.toString(((QuantileModel.QuantileOutput)model._output)._quantiles[n]));
                        Log.info(new Object[]{sb});
                    }
                    ++n;
                    ** GOTO lbl13
lbl63:
                    // 1 sources

                    Quantile.this.done();
                }
                Quantile.access$200(Quantile.this);
                if (model != null) {
                    model.unlock(Quantile.this._key);
                }
                ((QuantileModel.QuantileParameters)Quantile.this._parms).read_unlock_frames(Quantile.this);
                Scope.exit(new Key[]{model == null ? null : model._key});
                Quantile.access$200(Quantile.this);
                if (model != null) {
                    model.unlock(Quantile.this._key);
                }
                ((QuantileModel.QuantileParameters)Quantile.this._parms).read_unlock_frames(Quantile.this);
                Scope.exit(new Key[]{model == null ? null : model._key});
            }
            this.tryComplete();
        }
    }
}

