/*
 * Decompiled with CFR 0.152.
 */
package jsr166y;

import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import jsr166y.ForkJoinTask;
import sun.misc.Unsafe;

public abstract class CountedCompleter
extends ForkJoinTask<Void> {
    private static final long serialVersionUID = 5232453752276485070L;
    CountedCompleter completer;
    volatile int pending;
    private static final Unsafe U;
    private static final long PENDING;

    protected CountedCompleter(CountedCompleter completer, int initialPendingCount) {
        this.completer = completer;
        this.pending = initialPendingCount;
    }

    protected CountedCompleter(CountedCompleter completer) {
        this.completer = completer;
    }

    protected CountedCompleter() {
        this.completer = null;
    }

    public abstract void compute();

    public void onCompletion(CountedCompleter caller) {
    }

    public boolean onExceptionalCompletion(Throwable ex, CountedCompleter caller) {
        return true;
    }

    public final CountedCompleter getCompleter() {
        return this.completer;
    }

    public final void setCompleter(CountedCompleter x) {
        this.completer = x;
    }

    public final int getPendingCount() {
        return this.pending;
    }

    public final void setPendingCount(int count) {
        this.pending = count;
    }

    public final void addToPendingCount(int delta) {
        int c;
        while (!U.compareAndSwapInt(this, PENDING, c = this.pending, c + delta)) {
        }
    }

    public final boolean compareAndSetPendingCount(int expected, int count) {
        return U.compareAndSwapInt(this, PENDING, expected, count);
    }

    public final void tryComplete() {
        CountedCompleter a;
        CountedCompleter s = a = this;
        while (true) {
            int c;
            if ((c = a.pending) == 0) {
                a.onCompletion(s);
                s = a;
                a = s.completer;
                if (a != null) continue;
                s.quietlyComplete();
                return;
            }
            if (U.compareAndSwapInt(a, PENDING, c, c - 1)) break;
        }
    }

    @Override
    public void complete(Void mustBeNull) {
        this.onCompletion(this);
        this.quietlyComplete();
        CountedCompleter p = this.completer;
        if (p != null) {
            p.tryComplete();
        }
    }

    @Override
    void internalPropagateException(Throwable ex) {
        CountedCompleter a;
        CountedCompleter s = a = this;
        while (a.onExceptionalCompletion(ex, s)) {
            s = a;
            a = s.completer;
            if (a == null || a.status < 0) break;
            a.recordExceptionalCompletion(ex);
        }
    }

    @Override
    protected final boolean exec() {
        this.compute();
        return false;
    }

    @Override
    public final Void getRawResult() {
        return null;
    }

    @Override
    protected final void setRawResult(Void mustBeNull) {
    }

    private static Unsafe getUnsafe() {
        try {
            return Unsafe.getUnsafe();
        }
        catch (SecurityException se) {
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<Unsafe>(){

                    @Override
                    public Unsafe run() throws Exception {
                        Field f = Unsafe.class.getDeclaredField("theUnsafe");
                        f.setAccessible(true);
                        return (Unsafe)f.get(null);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw new RuntimeException("Could not initialize intrinsics", e.getCause());
            }
        }
    }

    static {
        try {
            U = CountedCompleter.getUnsafe();
            PENDING = U.objectFieldOffset(CountedCompleter.class.getDeclaredField("pending"));
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }
}

