/*
 * Decompiled with CFR 0.152.
 */
package water;

import water.H2O;
import water.H2ONode;
import water.Iced;

public class DException
extends Iced {
    final H2ONode _h2o = H2O.SELF;
    final String _exClass;
    final String _throwerClass;
    final DException _cause;
    final String _msg;
    final Stk[] _stk;

    DException(Throwable ex, Class thrower_clz) {
        Throwable cex = ex.getCause();
        while (ex instanceof DistributedException && cex != null) {
            ex = cex;
            cex = ex.getCause();
        }
        this._throwerClass = thrower_clz.toString();
        this._exClass = ex.getClass().toString();
        this._cause = cex == null ? null : new DException(cex, thrower_clz);
        this._msg = ex.getMessage();
        StackTraceElement[] stk = ex.getStackTrace();
        this._stk = new Stk[stk.length];
        for (int i = 0; i < stk.length; ++i) {
            this._stk[i] = new Stk(stk[i]);
        }
    }

    DistributedException toEx() {
        String msg = "from " + this._h2o + "; by " + this._throwerClass + "; " + this._exClass + ": " + this._msg;
        DistributedException e = new DistributedException(msg, this._cause == null ? null : this._cause.toEx());
        StackTraceElement[] stk = new StackTraceElement[this._stk.length];
        for (int i = 0; i < this._stk.length; ++i) {
            stk[i] = this._stk[i].toSTE();
        }
        e.setStackTrace(stk);
        return e;
    }

    public static class DistributedException
    extends RuntimeException {
        DistributedException(String msg, Throwable cause) {
            super(msg, cause);
        }
    }

    private static class Stk
    extends Iced {
        String _cls;
        String _mth;
        String _fname;
        int _line;

        Stk(StackTraceElement stk) {
            this._cls = stk.getClassName();
            this._mth = stk.getMethodName();
            this._fname = stk.getFileName();
            this._line = stk.getLineNumber();
        }

        public StackTraceElement toSTE() {
            return new StackTraceElement(this._cls, this._mth, this._fname, this._line);
        }
    }
}

