/*
 * Decompiled with CFR 0.152.
 */
package water;

import com.brsanthu.googleanalytics.DefaultRequest;
import com.brsanthu.googleanalytics.GoogleAnalytics;
import hex.ModelBuilder;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import jsr166y.CountedCompleter;
import jsr166y.ForkJoinPool;
import jsr166y.ForkJoinTask;
import jsr166y.ForkJoinWorkerThread;
import org.apache.log4j.LogManager;
import org.apache.log4j.PropertyConfigurator;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import water.AbstractH2OExtension;
import water.AutoBuffer;
import water.Cleaner;
import water.DTask;
import water.Freezable;
import water.H2ONode;
import water.HeartBeatThread;
import water.Icer;
import water.JettyHTTPD;
import water.Key;
import water.MultiReceiverThread;
import water.Paxos;
import water.RPC;
import water.Scope;
import water.TCPReceiverThread;
import water.TypeMap;
import water.UDPRebooted;
import water.UDPReceiverThread;
import water.UDPTimeOutThread;
import water.Value;
import water.api.AbstractRegister;
import water.api.RequestServer;
import water.exceptions.H2OFailException;
import water.exceptions.H2OIllegalArgumentException;
import water.init.AbstractBuildVersion;
import water.init.AbstractEmbeddedH2OConfig;
import water.init.JarHash;
import water.init.NetworkInit;
import water.init.NodePersistentStorage;
import water.nbhm.NonBlockingHashMap;
import water.persist.PersistManager;
import water.persist.PersistS3;
import water.util.GAUtils;
import water.util.Log;
import water.util.OSUtils;
import water.util.PrettyPrint;

public final class H2O {
    public static final OptArgs ARGS = new OptArgs();
    public static GoogleAnalytics GA;
    public static int CLIENT_TYPE_GA_CUST_DIM;
    public static int CLIENT_ID_GA_CUST_DIM;
    public static volatile AbstractEmbeddedH2OConfig embeddedH2OConfig;
    private static volatile boolean _shutdownRequested;
    public static final AbstractBuildVersion ABV;
    private static boolean _haveInheritedLog4jConfiguration;
    private static boolean extensionsRegistered;
    private static long registerExtensionsMillis;
    private static ArrayList<AbstractH2OExtension> extensions;
    private static boolean apisRegistered;
    private static ArrayList<AboutEntry> aboutEntries;
    private static AtomicLong nextModelNum;
    public static final AtomicLong START_TIME_MILLIS;
    public static final int NUMCPUS;
    public static long PID;
    public static final byte MAX_PRIORITY = 126;
    public static final byte ACK_ACK_PRIORITY = 126;
    public static final byte FETCH_ACK_PRIORITY = 125;
    public static final byte ACK_PRIORITY = 124;
    public static final byte DESERIAL_PRIORITY = 123;
    public static final byte INVALIDATE_PRIORITY = 123;
    public static final byte GET_KEY_PRIORITY = 122;
    public static final byte PUT_KEY_PRIORITY = 121;
    public static final byte ATOMIC_PRIORITY = 120;
    public static final byte GUI_PRIORITY = 119;
    public static final byte MIN_HI_PRIORITY = 119;
    public static final byte MIN_PRIORITY = 0;
    private static final PrioritizedForkJoinPool[] FJPS;
    public static int H2O_PORT;
    public static int API_PORT;
    public static MulticastSocket CLOUD_MULTICAST_SOCKET;
    public static NetworkInterface CLOUD_MULTICAST_IF;
    public static InetAddress CLOUD_MULTICAST_GROUP;
    public static int CLOUD_MULTICAST_PORT;
    public static H2ONode SELF;
    public static InetAddress SELF_ADDRESS;
    public static URI ICE_ROOT;
    public static HashSet<H2ONode> STATIC_H2OS;
    private static final H2O[] CLOUDS;
    static final String DEBUG_ARG = "h2o.debug";
    static final boolean DEBUG;
    public static final long CLUSTER_ID;
    private static JettyHTTPD jetty;
    private static volatile boolean _doneRequests;
    public static volatile H2O CLOUD;
    public final H2ONode[] _memary;
    final int _hash;
    final char _idx;
    static final NonBlockingHashMap<Key, Value> STORE;
    private static PersistManager _PM;
    private static NodePersistentStorage NPS;

    public static void printHelp() {
        String defaultFlowDirMessage = H2O.DEFAULT_FLOW_DIR() == null ? "          (The default is none; saving flows not available.)\n" : "          (The default is '" + H2O.DEFAULT_FLOW_DIR() + "'.)\n";
        String s = "\nUsage:  java [-Xmx<size>] -jar h2o.jar [options]\n        (Note that every option has a default and is optional.)\n\n    -h | -help\n          Print this help.\n\n    -version\n          Print version info and exit.\n\n    -name <h2oCloudName>\n          Cloud name used for discovery of other nodes.\n          Nodes with the same cloud name will form an H2O cloud\n          (also known as an H2O cluster).\n\n    -flatfile <flatFileName>\n          Configuration file explicitly listing H2O cloud node members.\n\n    -ip <ipAddressOfNode>\n          IP address of this node.\n\n    -port <port>\n          Port number for this node (note: port+1 is also used).\n          (The default port is " + H2O.ARGS.port + ".)\n" + "\n" + "    -network <IPv4network1Specification>[,<IPv4network2Specification> ...]\n" + "          The IP address discovery code will bind to the first interface\n" + "          that matches one of the networks in the comma-separated list.\n" + "          Use instead of -ip when a broad range of addresses is legal.\n" + "          (Example network specification: '10.1.2.0/24' allows 256 legal\n" + "          possibilities.)\n" + "\n" + "    -ice_root <fileSystemPath>\n" + "          The directory where H2O spills temporary data to disk.\n" + "\n" + "    -log_dir <fileSystemPath>\n" + "          The directory where H2O writes logs to disk.\n" + "          (This usually has a good default that you need not change.)\n" + "\n" + "    -flow_dir <server side directory or HDFS directory>\n" + "          The directory where H2O stores saved flows.\n" + defaultFlowDirMessage + "\n" + "    -nthreads <#threads>\n" + "          Maximum number of threads in the low priority batch-work queue.\n" + "          (The default is 99.)\n" + "\n" + "    -client\n" + "          Launch H2O node in client mode.\n" + "\n" + "Cloud formation behavior:\n" + "\n" + "    New H2O nodes join together to form a cloud at startup time.\n" + "    Once a cloud is given work to perform, it locks out new members\n" + "    from joining.\n" + "\n" + "Examples:\n" + "\n" + "    Start an H2O node with 4GB of memory and a default cloud name:\n" + "        $ java -Xmx4g -jar h2o.jar\n" + "\n" + "    Start an H2O node with 6GB of memory and a specify the cloud name:\n" + "        $ java -Xmx6g -jar h2o.jar -name MyCloud\n" + "\n" + "    Start an H2O cloud with three 2GB nodes and a default cloud name:\n" + "        $ java -Xmx2g -jar h2o.jar &\n" + "        $ java -Xmx2g -jar h2o.jar &\n" + "        $ java -Xmx2g -jar h2o.jar &\n" + "\n";
        System.out.print(s);
        for (AbstractH2OExtension e : H2O.getExtensions()) {
            e.printHelp();
        }
    }

    public static void parseFailed(String message) {
        System.out.println("");
        System.out.println("ERROR: " + message);
        System.out.println("");
        H2O.printHelp();
        H2O.exit(1);
    }

    private static void parseArguments(String[] args) {
        for (AbstractH2OExtension e : H2O.getExtensions()) {
            args = e.parseArguments(args);
        }
        for (int i = 0; i < args.length; ++i) {
            OptString s = new OptString(args[i]);
            if (s.matches("h") || s.matches("help")) {
                H2O.ARGS.help = true;
                continue;
            }
            if (s.matches("version")) {
                H2O.ARGS.version = true;
                continue;
            }
            if (s.matches("name")) {
                i = s.incrementAndCheck(i, args);
                H2O.ARGS.name = args[i];
                continue;
            }
            if (s.matches("flatfile")) {
                i = s.incrementAndCheck(i, args);
                H2O.ARGS.flatfile = args[i];
                continue;
            }
            if (s.matches("port")) {
                i = s.incrementAndCheck(i, args);
                H2O.ARGS.port = s.parseInt(args[i]);
                continue;
            }
            if (s.matches("baseport")) {
                i = s.incrementAndCheck(i, args);
                H2O.ARGS.baseport = s.parseInt(args[i]);
                continue;
            }
            if (s.matches("ip")) {
                i = s.incrementAndCheck(i, args);
                H2O.ARGS.ip = args[i];
                continue;
            }
            if (s.matches("network")) {
                i = s.incrementAndCheck(i, args);
                H2O.ARGS.network = args[i];
                continue;
            }
            if (s.matches("client")) {
                H2O.ARGS.client = true;
                continue;
            }
            if (s.matches("user_name")) {
                i = s.incrementAndCheck(i, args);
                H2O.ARGS.user_name = args[i];
                continue;
            }
            if (s.matches("ice_root")) {
                i = s.incrementAndCheck(i, args);
                H2O.ARGS.ice_root = args[i];
                continue;
            }
            if (s.matches("log_dir")) {
                i = s.incrementAndCheck(i, args);
                H2O.ARGS.log_dir = args[i];
                continue;
            }
            if (s.matches("flow_dir")) {
                i = s.incrementAndCheck(i, args);
                H2O.ARGS.flow_dir = args[i];
                continue;
            }
            if (s.matches("disable_web")) {
                H2O.ARGS.disable_web = true;
                continue;
            }
            if (s.matches("nthreads")) {
                i = s.incrementAndCheck(i, args);
                H2O.ARGS.nthreads = s.parseInt(args[i]);
                continue;
            }
            if (s.matches("hdfs_config")) {
                i = s.incrementAndCheck(i, args);
                H2O.ARGS.hdfs_config = args[i];
                continue;
            }
            if (s.matches("hdfs_skip")) {
                H2O.ARGS.hdfs_skip = true;
                continue;
            }
            if (s.matches("aws_credentials")) {
                i = s.incrementAndCheck(i, args);
                H2O.ARGS.aws_credentials = args[i];
                continue;
            }
            if (s.matches("ga_hadoop_ver")) {
                i = s.incrementAndCheck(i, args);
                H2O.ARGS.ga_hadoop_ver = args[i];
                continue;
            }
            if (s.matches("ga_opt_out")) {
                if (i + 1 < args.length && args[i + 1].equals("yes")) {
                    ++i;
                }
                H2O.ARGS.ga_opt_out = true;
                continue;
            }
            if (s.matches("log_level")) {
                i = s.incrementAndCheck(i, args);
                H2O.ARGS.log_level = args[i];
                continue;
            }
            if (s.matches("random_udp_drop")) {
                H2O.ARGS.random_udp_drop = true;
                continue;
            }
            if (s.matches("md5skip")) {
                H2O.ARGS.md5skip = true;
                continue;
            }
            if (s.matches("quiet")) {
                H2O.ARGS.quiet = true;
                continue;
            }
            if (s.matches("beta")) {
                H2O.ARGS.model_builders_visibility = ModelBuilder.BuilderVisibility.Beta;
                continue;
            }
            if (s.matches("experimental")) {
                H2O.ARGS.model_builders_visibility = ModelBuilder.BuilderVisibility.Experimental;
                continue;
            }
            if (s.matches("useUDP")) {
                H2O.ARGS.useUDP = true;
                continue;
            }
            H2O.parseFailed("Unknown argument (" + s + ")");
        }
    }

    public static void setEmbeddedH2OConfig(AbstractEmbeddedH2OConfig c) {
        embeddedH2OConfig = c;
    }

    public static AbstractEmbeddedH2OConfig getEmbeddedH2OConfig() {
        return embeddedH2OConfig;
    }

    public static void notifyAboutCloudSize(InetAddress ip, int port, int size) {
        if (embeddedH2OConfig == null) {
            return;
        }
        embeddedH2OConfig.notifyAboutCloudSize(ip, port, size);
    }

    public static void closeAll() {
        PersistManager PM;
        try {
            NetworkInit._udpSocket.close();
        }
        catch (IOException ignore) {
            // empty catch block
        }
        try {
            H2O.getJetty().stop();
        }
        catch (Exception ignore) {
            // empty catch block
        }
        try {
            NetworkInit._tcpSocketBig.close();
        }
        catch (IOException ignore) {
            // empty catch block
        }
        if (!H2O.ARGS.useUDP) {
            try {
                NetworkInit._tcpSocketSmall.close();
            }
            catch (IOException ignore) {
                // empty catch block
            }
        }
        if ((PM = H2O.getPM()) != null) {
            PM.getIce().cleanUp();
        }
    }

    public static void exit(int status) {
        if (embeddedH2OConfig != null) {
            embeddedH2OConfig.exit(status);
        }
        System.exit(status);
    }

    public static void shutdown(int status) {
        UDPRebooted.T.shutdown.send(SELF);
        H2O.exit(status);
    }

    public static void requestShutdown() {
        _shutdownRequested = true;
    }

    public static boolean getShutdownRequested() {
        return _shutdownRequested;
    }

    public static boolean haveInheritedLog4jConfiguration() {
        return _haveInheritedLog4jConfiguration;
    }

    public static void configureLogging() {
        if (LogManager.getCurrentLoggers().hasMoreElements()) {
            _haveInheritedLog4jConfiguration = true;
            return;
        }
        Properties p = new Properties();
        p.setProperty("log4j.logger.org.reflections.Reflections", "WARN");
        p.setProperty("log4j.logger.org.eclipse.jetty", "WARN");
        PropertyConfigurator.configure((Properties)p);
        System.setProperty("org.eclipse.jetty.LEVEL", "WARN");
        System.setProperty("org.eclipse.jetty.util.log.class", "org.eclipse.jetty.util.log.StrErrLog");
    }

    public static void registerExtensions() {
        String[] packages;
        if (extensionsRegistered) {
            throw H2O.fail("Extensions already registered");
        }
        long before = System.currentTimeMillis();
        for (String pkg : packages = new String[]{"water", "hex"}) {
            Reflections reflections = new Reflections(pkg, new Scanner[0]);
            for (Class registerClass : reflections.getSubTypesOf(AbstractH2OExtension.class)) {
                if (Modifier.isAbstract(registerClass.getModifiers())) continue;
                try {
                    Object instance = registerClass.newInstance();
                    AbstractH2OExtension e = (AbstractH2OExtension)instance;
                    H2O.addExtension(e);
                }
                catch (Exception e) {
                    throw H2O.fail(e.toString());
                }
            }
        }
        for (AbstractH2OExtension e : H2O.getExtensions()) {
            e.init();
        }
        extensionsRegistered = true;
        registerExtensionsMillis = System.currentTimeMillis() - before;
    }

    public static void addExtension(AbstractH2OExtension e) {
        extensions.add(e);
    }

    public static ArrayList<AbstractH2OExtension> getExtensions() {
        return extensions;
    }

    public static void registerRestApis(String relativeResourcePath) {
        String[] packages;
        if (apisRegistered) {
            throw H2O.fail("APIs already registered");
        }
        for (AbstractH2OExtension e : H2O.getExtensions()) {
            e.printInitialized();
        }
        Log.info("Registered " + H2O.getExtensions().size() + " extensions in: " + registerExtensionsMillis + "mS");
        long before = System.currentTimeMillis();
        for (String pkg : packages = new String[]{"water", "hex"}) {
            Reflections reflections = new Reflections(pkg, new Scanner[0]);
            Log.debug("Registering REST APIs for package: " + pkg);
            for (Class registerClass : reflections.getSubTypesOf(AbstractRegister.class)) {
                if (Modifier.isAbstract(registerClass.getModifiers())) continue;
                try {
                    Log.debug("Found REST API registration for class: " + registerClass.getName());
                    Object instance = registerClass.newInstance();
                    AbstractRegister r = (AbstractRegister)instance;
                    r.register(relativeResourcePath);
                }
                catch (Exception e) {
                    throw H2O.fail(e.toString());
                }
            }
        }
        apisRegistered = true;
        long registerApisMillis = System.currentTimeMillis() - before;
        Log.info("Registered: " + RequestServer.numRoutes() + " REST APIs in: " + registerApisMillis + "mS");
    }

    public static void addAboutEntry(String name, String value) {
        AboutEntry e = new AboutEntry(name, value);
        aboutEntries.add(e);
    }

    public static ArrayList<AboutEntry> getAboutEntries() {
        return aboutEntries;
    }

    public static synchronized String calcNextUniqueModelId(String desc) {
        StringBuilder sb = new StringBuilder();
        sb.append(desc).append("_model_");
        String source = JettyHTTPD.getUserAgent();
        if (source != null) {
            StringBuilder ua = new StringBuilder();
            if (source.contains("Safari")) {
                ua.append("safari");
            } else if (source.contains("Python")) {
                ua.append("python");
            } else {
                for (int i = 0; i < source.length(); ++i) {
                    char c = source.charAt(i);
                    if (c >= 'a' && c <= 'z') {
                        ua.append(c);
                        continue;
                    }
                    if (c < 'A' || c > 'Z') break;
                    ua.append(c);
                }
            }
            if (ua.toString().length() > 0) {
                sb.append(ua.toString()).append("_");
            }
        }
        long n = nextModelNum.addAndGet(1L);
        sb.append(Long.toString(CLUSTER_ID)).append("_").append(Long.toString(n));
        return sb.toString();
    }

    public static H2OIllegalArgumentException unimpl() {
        return new H2OIllegalArgumentException("unimplemented");
    }

    public static H2OIllegalArgumentException unimpl(String msg) {
        return new H2OIllegalArgumentException("unimplemented: " + msg);
    }

    public static H2OFailException fail(String msg, Throwable cause) {
        Log.fatal(msg);
        if (null != cause) {
            Log.fatal(cause);
        }
        Log.fatal("Stacktrace: ");
        Log.fatal(Arrays.toString(Thread.currentThread().getStackTrace()));
        H2O.shutdown(-1);
        return new H2OFailException(msg);
    }

    public static H2OFailException fail() {
        return H2O.fail("Unknown code failure");
    }

    public static H2OFailException fail(String msg) {
        return H2O.fail(msg, null);
    }

    public static String technote(int number, String message) {
        StringBuffer sb = new StringBuffer().append(message).append("\n").append("\n").append("For more information visit:\n").append("  http://jira.h2o.ai/browse/TN-").append(Integer.toString(number));
        return sb.toString();
    }

    public static String technote(int[] numbers, String message) {
        StringBuffer sb = new StringBuffer().append(message).append("\n").append("\n").append("For more information visit:\n");
        for (int number : numbers) {
            sb.append("  http://jira.h2o.ai/browse/TN-").append(Integer.toString(number)).append("\n");
        }
        return sb.toString();
    }

    static int getWrkQueueSize(int i) {
        return FJPS[i] == null ? -1 : FJPS[i].getQueuedSubmissionCount();
    }

    static int getWrkThrPoolSize(int i) {
        return FJPS[i] == null ? -1 : FJPS[i].getPoolSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static H2OCountedCompleter submitTask(H2OCountedCompleter task) {
        byte priority = task.priority();
        if (!$assertionsDisabled) {
            if (0 > priority) throw new AssertionError((Object)("priority " + priority + " is out of range, expected range is < " + 0 + "," + 126 + ">"));
            if (priority > 126) {
                throw new AssertionError((Object)("priority " + priority + " is out of range, expected range is < " + 0 + "," + 126 + ">"));
            }
        }
        if (FJPS[priority] == null) {
            Class<H2O> clazz = H2O.class;
            // MONITORENTER : water.H2O.class
            if (FJPS[priority] == null) {
                H2O.FJPS[priority] = new PrioritizedForkJoinPool(priority, -1);
            }
            // MONITOREXIT : clazz
        }
        FJPS[priority].submit(task);
        return task;
    }

    public static String getIpPortString() {
        return SELF_ADDRESS.getHostAddress() + ":" + API_PORT;
    }

    public static String DEFAULT_ICE_ROOT() {
        String u2;
        String username = System.getProperty("user.name");
        if (username == null) {
            username = "";
        }
        if ((u2 = username.replaceAll(" ", "_")).length() == 0) {
            u2 = "unknown";
        }
        return "/tmp/h2o-" + u2;
    }

    public static String DEFAULT_FLOW_DIR() {
        String flow_dir = null;
        try {
            if (H2O.ARGS.ga_hadoop_ver != null) {
                String s;
                PersistManager pm = H2O.getPM();
                if (pm != null && pm.exists(s = pm.getHdfsHomeDirectory())) {
                    flow_dir = s;
                }
                if (flow_dir != null) {
                    flow_dir = flow_dir + "/h2oflows";
                }
            } else {
                flow_dir = System.getProperty("user.home") + File.separator + "h2oflows";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return flow_dir;
    }

    public static void setJetty(JettyHTTPD value) {
        jetty = value;
    }

    public static JettyHTTPD getJetty() {
        return jetty;
    }

    static void printAndLogVersion() {
        Log.init(H2O.ARGS.log_level, H2O.ARGS.quiet);
        Log.info("----- H2O started " + (H2O.ARGS.client ? "(client)" : "") + " -----");
        Log.info("Build git branch: " + ABV.branchName());
        Log.info("Build git hash: " + ABV.lastCommitHash());
        Log.info("Build git describe: " + ABV.describe());
        Log.info("Build project version: " + ABV.projectVersion());
        Log.info("Built by: '" + ABV.compiledBy() + "'");
        Log.info("Built on: '" + ABV.compiledOn() + "'");
        for (AbstractH2OExtension e : H2O.getExtensions()) {
            String n = e.getExtensionName() + " ";
            AbstractBuildVersion abv = e.getBuildVersion();
            Log.info(n + "Build git branch: ", abv.branchName());
            Log.info(n + "Build git hash: ", abv.lastCommitHash());
            Log.info(n + "Build git describe: ", abv.describe());
            Log.info(n + "Build project version: ", abv.projectVersion());
            Log.info(n + "Built by: ", abv.compiledBy());
            Log.info(n + "Built on: ", abv.compiledOn());
        }
        Runtime runtime = Runtime.getRuntime();
        Log.info("Java availableProcessors: " + runtime.availableProcessors());
        Log.info("Java heap totalMemory: " + PrettyPrint.bytes(runtime.totalMemory()));
        Log.info("Java heap maxMemory: " + PrettyPrint.bytes(runtime.maxMemory()));
        Log.info("Java version: Java " + System.getProperty("java.version") + " (from " + System.getProperty("java.vendor") + ")");
        List<String> launchStrings = ManagementFactory.getRuntimeMXBean().getInputArguments();
        Log.info("JVM launch parameters: " + launchStrings);
        Log.info("OS version: " + System.getProperty("os.name") + " " + System.getProperty("os.version") + " (" + System.getProperty("os.arch") + ")");
        long totalMemory = OSUtils.getTotalPhysicalMemory();
        Log.info("Machine physical memory: " + (totalMemory == -1L ? "NA" : PrettyPrint.bytes(totalMemory)));
    }

    private static void startGAStartupReport() {
        new GAStartupReportThread().start();
    }

    private static void startLocalNode() {
        PID = -1L;
        try {
            String n = ManagementFactory.getRuntimeMXBean().getName();
            int i = n.indexOf(64);
            if (i != -1) {
                PID = Long.parseLong(n.substring(0, i));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        NetworkInit.initializeNetworkSockets();
        if (!H2O.ARGS.client && STATIC_H2OS != null && !STATIC_H2OS.contains(SELF)) {
            Log.warn("Flatfile configuration does not include self: " + SELF + " but contains " + STATIC_H2OS);
            STATIC_H2OS.add(SELF);
        }
        Log.info("H2O cloud name: '" + H2O.ARGS.name + "' on " + SELF + (H2O.ARGS.flatfile == null ? ", discovery address " + CLOUD_MULTICAST_GROUP + ":" + CLOUD_MULTICAST_PORT : ", static configuration based on -flatfile " + H2O.ARGS.flatfile));
        Log.info("If you have trouble connecting, try SSH tunneling from your local machine (e.g., via port 55555):\n  1. Open a terminal and run 'ssh -L 55555:localhost:" + API_PORT + " " + System.getProperty("user.name") + "@" + SELF_ADDRESS.getHostAddress() + "'\n" + "  2. Point your browser to " + jetty.getScheme() + "://localhost:55555");
        H2O.SELF._heartbeat._jar_md5 = JarHash.JARHASH;
        H2O.SELF._heartbeat._client = H2O.ARGS.client;
    }

    private static void startNetworkServices() {
        UDPRebooted.T.reboot.broadcast();
        if (H2O.ARGS.useUDP) {
            new UDPReceiverThread().start();
        }
        new MultiReceiverThread().start();
        Cleaner.THE_CLEANER.start();
        new UDPTimeOutThread().start();
        new H2ONode.AckAckTimeOutThread().start();
        new TCPReceiverThread(NetworkInit._tcpSocketBig).start();
        Class<RequestServer> x = RequestServer.class;
    }

    public static void registerGET(String url_pattern, Class hclass, String hmeth, String summary) {
        H2O.registerGET(url_pattern, hclass, hmeth, null, summary);
    }

    public static void registerGET(String url_pattern, Class hclass, String hmeth, String doc_method, String summary) {
        if (_doneRequests) {
            throw new IllegalArgumentException("Cannot add more Requests once the list is finalized");
        }
        RequestServer.register(url_pattern, "GET", hclass, hmeth, doc_method, summary);
    }

    public static void registerPOST(String url_pattern, Class hclass, String hmeth, String summary) {
        if (_doneRequests) {
            throw new IllegalArgumentException("Cannot add more Requests once the list is finalized");
        }
        RequestServer.register(url_pattern, "POST", hclass, hmeth, null, summary);
    }

    public static void registerResourceRoot(File f) {
        JarHash.registerResourceRoot(f);
    }

    public static void finalizeRegistration() {
        if (_doneRequests) {
            return;
        }
        _doneRequests = true;
        RequestServer.finalizeRegistration();
    }

    H2O(H2ONode[] h2os, int hash, int idx) {
        this._memary = h2os;
        Arrays.sort(this._memary);
        this._hash = hash;
        this._idx = (char)(idx & 0xFF);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void set_next_Cloud(H2ONode[] h2os, int hash) {
        H2O h2O = this;
        synchronized (h2O) {
            int idx = this._idx + '\u0001';
            if (idx == 256) {
                idx = 1;
            }
            H2O.CLOUDS[idx] = CLOUD = new H2O(h2os, hash, idx);
        }
        H2O.SELF._heartbeat._cloud_size = (char)CLOUD.size();
    }

    static boolean larger(int nnn, int old) {
        assert (0 <= nnn && nnn <= 255);
        assert (0 <= old && old <= 255);
        return (nnn - old & 0xFF) < 64;
    }

    public final int size() {
        return this._memary.length;
    }

    final H2ONode leader() {
        return this._memary[0];
    }

    int nidx(H2ONode h2o) {
        return Arrays.binarySearch(this._memary, h2o);
    }

    boolean contains(H2ONode h2o) {
        return this.nidx(h2o) >= 0;
    }

    public String toString() {
        return Arrays.toString(this._memary);
    }

    public H2ONode[] members() {
        return this._memary;
    }

    public long memsz() {
        long memsz = 0L;
        for (H2ONode h2o : H2O.CLOUD._memary) {
            memsz += h2o.get_max_mem();
        }
        return memsz;
    }

    public static void waitForCloudSize(int x, long ms) {
        long start = System.currentTimeMillis();
        while (!(System.currentTimeMillis() - start >= ms || CLOUD.size() >= x && Paxos._commonKnowledge)) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ignore) {}
        }
        if (CLOUD.size() < x) {
            throw new RuntimeException("Cloud size under " + x);
        }
    }

    public static int getCloudSize() {
        if (!Paxos._commonKnowledge) {
            return -1;
        }
        return CLOUD.size();
    }

    public static void joinOthers() {
        long start = System.currentTimeMillis();
        while (!(System.currentTimeMillis() - start >= 2000L || CLOUD.size() > 1 && Paxos._commonKnowledge)) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    static void initializePersistence() {
        _PM = new PersistManager(ICE_ROOT);
        if (H2O.ARGS.aws_credentials != null) {
            try {
                PersistS3.getClient();
            }
            catch (IllegalArgumentException e) {
                Log.err(e);
            }
        }
    }

    public static Value putIfMatch(Key key, Value val, Value old) {
        Value res;
        if (old != null) {
            key = old._key;
        }
        if (val != null) {
            assert (val._key.equals(key));
            if (val._key != key) {
                val._key = key;
            }
        }
        if ((res = STORE.putIfMatchUnlocked(key, val, old)) != old) {
            return res;
        }
        if (old != null && val == null) {
            old.removePersist();
        }
        if (val != null) {
            Cleaner.dirty_store();
            if (old == null) {
                Scope.track(key);
            }
        }
        return old;
    }

    public static Value get(Key key) {
        return STORE.get(key);
    }

    public static boolean containsKey(Key key) {
        return STORE.get(key) != null;
    }

    public static Value raw_get(Key key) {
        return STORE.get(key);
    }

    public static void raw_remove(Key key) {
        STORE.remove(key);
    }

    public static void raw_clear() {
        STORE.clear();
    }

    static Key getk(Key key) {
        return STORE.getk(key);
    }

    public static Set<Key> localKeySet() {
        return STORE.keySet();
    }

    static Collection<Value> values() {
        return STORE.values();
    }

    public static int store_size() {
        return STORE.size();
    }

    public static String STOREtoString() {
        int[] cnts = new int[1];
        Object[] kvs = STORE.raw_array();
        for (int i = 2; i < kvs.length; i += 2) {
            Object ov = kvs[i + 1];
            if (!(ov instanceof Value)) continue;
            Value val = (Value)ov;
            int t = val.type();
            while (t >= cnts.length) {
                cnts = Arrays.copyOf(cnts, cnts.length << 1);
            }
            int n = t;
            cnts[n] = cnts[n] + 1;
        }
        StringBuilder sb = new StringBuilder();
        for (int t = 0; t < cnts.length; ++t) {
            if (cnts[t] == 0) continue;
            sb.append(String.format("-%30s %5d\n", TypeMap.CLAZZES[t], cnts[t]));
        }
        return sb.toString();
    }

    public static PersistManager getPM() {
        return _PM;
    }

    public static NodePersistentStorage getNPS() {
        return NPS;
    }

    public static void gc() {
        for (H2ONode node : H2O.CLOUD._memary) {
            class GCTask
            extends DTask<GCTask> {
                @Override
                public void compute2() {
                    Log.info("Calling System.gc() now...");
                    System.gc();
                    Log.info("System.gc() finished");
                    this.tryComplete();
                }

                @Override
                public byte priority() {
                    return 119;
                }
            }
            GCTask t = new GCTask();
            new RPC<GCTask>(node, t).call().get();
        }
    }

    public static void main(String[] args) {
        if (!START_TIME_MILLIS.compareAndSet(0L, System.currentTimeMillis())) {
            return;
        }
        ArrayList<String> args2 = new ArrayList<String>(Arrays.asList(args));
        for (Object p : System.getProperties().keySet()) {
            String s = (String)p;
            if (!s.startsWith("ai.h2o.")) continue;
            args2.add("-" + s.substring(7));
            if (s.substring(7).equals("ga_opt_out")) continue;
            args2.add(System.getProperty(s));
        }
        H2O.parseArguments(args2.toArray(args));
        String ice = H2O.DEFAULT_ICE_ROOT();
        if (H2O.ARGS.ice_root != null) {
            ice = H2O.ARGS.ice_root.replace("\\", "/");
        }
        try {
            ICE_ROOT = new URI(ice);
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException("Invalid ice_root: " + ice + ", " + ex.getMessage());
        }
        H2O.printAndLogVersion();
        if (H2O.ARGS.version) {
            Log.flushStdout();
            H2O.exit(0);
        }
        if (H2O.ARGS.help) {
            H2O.printHelp();
            H2O.exit(0);
        }
        for (AbstractH2OExtension e : H2O.getExtensions()) {
            e.validateArguments();
        }
        Log.info("X-h2o-cluster-id: " + CLUSTER_ID);
        Log.info("User name: '" + H2O.ARGS.user_name + "'");
        List<String> gaidList = JarHash.getResourcesList("gaid");
        if (new File(".h2o_no_collect").exists() || new File(System.getProperty("user.home") + File.separator + ".h2o_no_collect").exists() || H2O.ARGS.ga_opt_out || gaidList.contains("CRAN")) {
            GA = null;
            Log.info("Opted out of sending usage metrics.");
        } else {
            try {
                GA = new GoogleAnalytics("UA-56665317-1", "H2O", ABV.projectVersion());
                DefaultRequest defReq = GA.getDefaultRequest();
                String gaid = null;
                if (gaidList.size() > 0) {
                    if (gaidList.size() > 1) {
                        Log.debug("More than once resource seen in gaid dir.");
                    }
                    for (String str : gaidList) {
                        if (!str.matches("........-....-....-....-............") || str.equals("XXXXXXXX-XXXX-XXXX-XXXX-XXXXXXXXXXXX")) continue;
                        gaid = str;
                        break;
                    }
                }
                if (gaid == null) {
                    gaid = defReq.clientId();
                    gaid = gaid.replaceFirst("........-", "ANONYMOU-");
                }
                defReq.customDimension(CLIENT_ID_GA_CUST_DIM, gaid);
                GA.setDefaultRequest(defReq);
            }
            catch (Throwable t) {
                Log.POST(11, t.toString());
                StackTraceElement[] stes = t.getStackTrace();
                for (int i = 0; i < stes.length; ++i) {
                    Log.POST(11, stes[i].toString());
                }
            }
        }
        NetworkInit.findInetAddressForSelf();
        H2O.startLocalNode();
        try {
            String logDir = Log.getLogDir();
            Log.info("Log dir: '" + logDir + "'");
        }
        catch (Exception e) {
            Log.info("Log dir: (Log4j configuration inherited)");
        }
        Log.info("Cur dir: '" + System.getProperty("user.dir") + "'");
        RuntimeMXBean rtBean = ManagementFactory.getRuntimeMXBean();
        Log.debug("H2O launch parameters: " + ARGS.toString());
        Log.debug("Boot class path: " + rtBean.getBootClassPath());
        Log.debug("Java class path: " + rtBean.getClassPath());
        Log.debug("Java library path: " + rtBean.getLibraryPath());
        H2O.initializePersistence();
        String flow_dir = H2O.ARGS.flow_dir != null ? H2O.ARGS.flow_dir : H2O.DEFAULT_FLOW_DIR();
        if (flow_dir != null) {
            flow_dir = flow_dir.replace("\\", "/");
            Log.info("Flow dir: '" + flow_dir + "'");
        } else {
            Log.info("Flow dir is undefined; saving flows not available");
        }
        NPS = new NodePersistentStorage(flow_dir);
        H2O.startNetworkServices();
        Log.trace("Network services started");
        Paxos.doHeartbeat(SELF);
        assert (H2O.SELF._heartbeat._cloud_hash != 0 || H2O.ARGS.client);
        new HeartBeatThread().start();
        if (GA != null) {
            H2O.startGAStartupReport();
        }
    }

    public static void die(String s) {
        Log.fatal(s);
        H2O.shutdown(-1);
    }

    static {
        CLIENT_TYPE_GA_CUST_DIM = 1;
        CLIENT_ID_GA_CUST_DIM = 2;
        _shutdownRequested = false;
        AbstractBuildVersion abv = AbstractBuildVersion.UNKNOWN_VERSION;
        try {
            Class<?> klass = Class.forName("water.init.BuildVersion");
            Constructor<?> constructor = klass.getConstructor(new Class[0]);
            abv = (AbstractBuildVersion)constructor.newInstance(new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ABV = abv;
        _haveInheritedLog4jConfiguration = false;
        extensionsRegistered = false;
        registerExtensionsMillis = 0L;
        extensions = new ArrayList();
        apisRegistered = false;
        aboutEntries = new ArrayList();
        nextModelNum = new AtomicLong(0L);
        START_TIME_MILLIS = new AtomicLong();
        NUMCPUS = Runtime.getRuntime().availableProcessors();
        PID = -1L;
        FJPS = new PrioritizedForkJoinPool[127];
        H2O.FJPS[126] = new PrioritizedForkJoinPool(126, 1);
        for (int i = 120; i < 126; ++i) {
            H2O.FJPS[i] = new PrioritizedForkJoinPool(i, 4);
        }
        H2O.FJPS[119] = new PrioritizedForkJoinPool(119, 2);
        SELF = null;
        STATIC_H2OS = null;
        CLOUDS = new H2O[256];
        DEBUG = System.getProperty(DEBUG_ARG) != null;
        CLUSTER_ID = System.currentTimeMillis();
        CLOUD = new H2O(new H2ONode[0], 0, 0);
        STORE = new NonBlockingHashMap();
    }

    public static class GAStartupReportThread
    extends Thread {
        private final int sleepMillis = 150000;

        public GAStartupReportThread() {
            super("GAStartupReport");
            this.setDaemon(true);
            this.setPriority(8);
        }

        @Override
        public void run() {
            try {
                Thread.sleep(150000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            GAUtils.logStartup();
        }
    }

    public static abstract class H2OCallback<T extends H2OCountedCompleter>
    extends H2OCountedCompleter {
        public H2OCallback() {
        }

        public H2OCallback(H2OCountedCompleter cc) {
            super(cc);
        }

        @Override
        protected void compute2() {
            throw H2O.fail();
        }

        @Override
        public void onCompletion(CountedCompleter caller) {
            this.callback((H2OCountedCompleter)caller);
        }

        public abstract void callback(T var1);
    }

    public static abstract class H2OCountedCompleter<T extends H2OCountedCompleter>
    extends CountedCompleter
    implements Cloneable,
    Freezable {
        private transient short _ice_id;

        public H2OCountedCompleter() {
        }

        protected H2OCountedCompleter(H2OCountedCompleter completer) {
            super(completer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void compute() {
            FJWThr t = (FJWThr)Thread.currentThread();
            int pp = ((PrioritizedForkJoinPool)t.getPool())._priority;
            ForkJoinTask h2o = null;
            boolean set_t_prior = false;
            try {
                assert (this.priority() == pp) : " wrong priority for task " + this.getClass().getSimpleName() + ", expected " + this.priority() + ", but got " + pp;
                assert (t._priority <= pp);
                int p2 = Math.max(pp, 119);
                for (int p = 126; p > p2; --p) {
                    if (FJPS[p] == null || (h2o = FJPS[p].poll2()) == null) continue;
                    t._priority = p++;
                    t.setPriority(9);
                    set_t_prior = true;
                    ((H2OCountedCompleter)h2o).compute2();
                }
            }
            catch (Throwable ex) {
                if (h2o != null) {
                    h2o.completeExceptionally(ex);
                } else {
                    ex.printStackTrace();
                }
            }
            finally {
                t._priority = pp;
                if (pp == 0 && set_t_prior) {
                    t.setPriority(4);
                }
            }
            this.compute2();
        }

        protected abstract void compute2();

        @Override
        public boolean onExceptionalCompletion(Throwable ex, CountedCompleter caller) {
            if (this.getCompleter() == null) {
                System.err.println("onExCompletion for " + this);
                ex.printStackTrace();
            }
            return true;
        }

        protected byte priority() {
            return 0;
        }

        public final T clone() {
            try {
                return (T)((H2OCountedCompleter)super.clone());
            }
            catch (CloneNotSupportedException e) {
                throw Log.throwErr(e);
            }
        }

        protected final byte nextThrPriority() {
            Thread cThr = Thread.currentThread();
            return (byte)(cThr instanceof FJWThr ? ((FJWThr)cThr)._priority + 1 : this.priority());
        }

        protected Icer<T> icer() {
            short id = this._ice_id;
            return TypeMap.getIcer((int)(id != 0 ? id : (this._ice_id = (short)TypeMap.onIce(this))), this);
        }

        @Override
        public final AutoBuffer write(AutoBuffer ab) {
            return this.icer().write(ab, this);
        }

        @Override
        public final AutoBuffer writeJSON(AutoBuffer ab) {
            return this.icer().writeJSON(ab, this);
        }

        @Override
        public final T read(AutoBuffer ab) {
            return (T)this.icer().read(ab, this);
        }

        @Override
        public final T readJSON(AutoBuffer ab) {
            return (T)this.icer().readJSON(ab, this);
        }

        @Override
        public final int frozenType() {
            return this.icer().frozenType();
        }

        @Override
        public AutoBuffer write_impl(AutoBuffer ab) {
            return ab;
        }

        @Override
        public T read_impl(AutoBuffer ab) {
            return (T)this;
        }

        @Override
        public AutoBuffer writeJSON_impl(AutoBuffer ab) {
            return ab;
        }

        @Override
        public T readJSON_impl(AutoBuffer ab) {
            return (T)this;
        }
    }

    public static abstract class H2OFuture<T>
    implements Future<T> {
        public final T getResult() {
            try {
                return (T)this.get();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class PrioritizedForkJoinPool
    extends ForkJoinPool {
        final int _priority;

        private PrioritizedForkJoinPool(int p, int cap) {
            super(H2O.ARGS.nthreads <= 0 ? NUMCPUS : H2O.ARGS.nthreads, new FJWThrFact(cap), null, p < 119);
            this._priority = p;
        }

        private H2OCountedCompleter poll2() {
            return (H2OCountedCompleter)this.pollSubmission();
        }
    }

    static class FJWThrFact
    implements ForkJoinPool.ForkJoinWorkerThreadFactory {
        private final int _cap;

        FJWThrFact(int cap) {
            this._cap = cap;
        }

        @Override
        public ForkJoinWorkerThread newThread(ForkJoinPool pool) {
            int cap = this._cap == -1 ? 4 * NUMCPUS : this._cap;
            return pool.getPoolSize() <= cap ? new FJWThr(pool) : null;
        }
    }

    public static class FJWThr
    extends ForkJoinWorkerThread {
        public int _priority;

        FJWThr(ForkJoinPool pool) {
            super(pool);
            this._priority = ((PrioritizedForkJoinPool)pool)._priority;
            this.setPriority(this._priority == 1 ? 4 : 9);
            this.setName("FJ-" + this._priority + "-" + this.getPoolIndex());
        }
    }

    public static class AboutEntry {
        private String name;
        private String value;

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        AboutEntry(String n, String v) {
            this.name = n;
            this.value = v;
        }
    }

    public static class OptString {
        String _s;
        String _lastMatchedFor;

        public OptString(String s) {
            this._s = s;
        }

        public boolean matches(String s) {
            boolean result = false;
            this._lastMatchedFor = s;
            String candidate = "-" + s;
            if (this._s.equals(candidate)) {
                result = true;
            }
            if (this._s.equals(candidate = "--" + s)) {
                result = true;
            }
            return result;
        }

        public int incrementAndCheck(int i, String[] args) {
            if (++i >= args.length) {
                H2O.parseFailed(this._lastMatchedFor + " not specified");
            }
            return i;
        }

        public int parseInt(String a) {
            int result = 0;
            try {
                result = Integer.parseInt(a);
            }
            catch (Exception e) {
                H2O.parseFailed("Argument " + this._lastMatchedFor + " must be an integer (was given '" + a + "')");
            }
            return result;
        }

        public String toString() {
            return this._s;
        }
    }

    public static class OptArgs {
        public boolean help = false;
        public boolean version = false;
        public String name = System.getProperty("user.name");
        public String flatfile;
        public int port;
        public int baseport = 54321;
        public String ip;
        public String network;
        public boolean client;
        public String user_name = System.getProperty("user.name");
        public String ice_root;
        public int nthreads = Runtime.getRuntime().availableProcessors();
        public String log_dir;
        public String flow_dir;
        public boolean disable_web = false;
        public String hdfs_config = null;
        public boolean hdfs_skip = false;
        public String aws_credentials = null;
        public String ga_hadoop_ver = null;
        public boolean ga_opt_out = false;
        public String log_level;
        public boolean random_udp_drop;
        public boolean md5skip = false;
        public boolean quiet = false;
        public ModelBuilder.BuilderVisibility model_builders_visibility = ModelBuilder.BuilderVisibility.Stable;
        public boolean useUDP = false;

        public String toString() {
            StringBuilder result = new StringBuilder();
            Field[] fields = this.getClass().getDeclaredFields();
            result.append("[ ");
            for (Field field : fields) {
                try {
                    result.append(field.getName());
                    result.append(": ");
                    result.append(field.get(this));
                    result.append(", ");
                }
                catch (IllegalAccessException ex) {
                    Log.err(ex);
                }
            }
            result.deleteCharAt(result.length() - 2);
            result.deleteCharAt(result.length() - 1);
            result.append(" ]");
            return result.toString();
        }
    }
}

