/*
 * Decompiled with CFR 0.152.
 */
package water;

import water.AutoBuffer;
import water.DKV;
import water.Iced;
import water.Key;
import water.Keyed;
import water.TypeMap;

public class IcedUtils {
    public static <T extends Iced> T clone(T iced) {
        AutoBuffer ab = new AutoBuffer();
        iced.write(ab);
        ab.flipForReading();
        return (T)TypeMap.newInstance(iced.frozenType()).read(ab);
    }

    public static <T extends Keyed> T clone(T keyed, Key<T> newKey) {
        return IcedUtils.clone(keyed, newKey, false);
    }

    public static <T extends Keyed> T clone(T keyed, Key<T> newKey, boolean publish) {
        T clonedCopy = IcedUtils.clone(keyed);
        clonedCopy._key = newKey;
        if (publish) {
            DKV.put(newKey, clonedCopy);
        }
        return clonedCopy;
    }
}

