/*
 * Decompiled with CFR 0.152.
 */
package water;

import java.util.Arrays;
import jsr166y.CountedCompleter;
import water.DKV;
import water.Futures;
import water.H2O;
import water.H2ONode;
import water.Iced;
import water.Key;
import water.Keyed;
import water.TAtomic;
import water.Value;
import water.exceptions.H2OKeyNotFoundArgumentException;
import water.util.Log;
import water.util.StringUtils;

public class Job<T extends Keyed>
extends Keyed {
    public static final Key<Job> LIST = Key.make(" JobList", (byte)0, (byte)2, false, new H2ONode[0]);
    public ValidationMessage[] _messages = new ValidationMessage[0];
    private int _error_count = -1;
    transient H2O.H2OCountedCompleter _fjtask;
    transient H2O.H2OCountedCompleter _barrier;
    public Key<T> _dest;
    public String _description;
    public long _start_time;
    public long _end_time;
    public String _exception;
    public JobState _state;
    protected Key<Progress> _progressKey;
    private float _finalProgress = Float.NaN;

    public void updateValidationMessages() {
        new TAtomic<Job>(){

            @Override
            public Job atomic(Job old) {
                if (old == null) {
                    throw new H2OKeyNotFoundArgumentException((Key)null);
                }
                old._messages = Job.this._messages;
                return old;
            }
        }.invoke(this._key);
    }

    public int error_count() {
        return this._error_count > 0 ? this._error_count : 0;
    }

    public int error_count_or_uninitialized() {
        return this._error_count;
    }

    public void hide(String field_name, String message) {
        this.message(ValidationMessage.MessageType.HIDE, field_name, message);
    }

    public void info(String field_name, String message) {
        this.message(ValidationMessage.MessageType.INFO, field_name, message);
    }

    public void warn(String field_name, String message) {
        this.message(ValidationMessage.MessageType.WARN, field_name, message);
    }

    public void error(String field_name, String message) {
        this.message(ValidationMessage.MessageType.ERROR, field_name, message);
        ++this._error_count;
    }

    public void clearValidationErrors() {
        this._messages = new ValidationMessage[0];
        this._error_count = 0;
    }

    public void message(ValidationMessage.MessageType message_type, String field_name, String message) {
        this._messages = Arrays.copyOf(this._messages, this._messages.length + 1);
        this._messages[this._messages.length - 1] = new ValidationMessage(message_type, field_name, message);
    }

    public String validationErrors() {
        StringBuilder sb = new StringBuilder();
        for (ValidationMessage vm : this._messages) {
            if (vm.message_type != ValidationMessage.MessageType.ERROR) continue;
            sb.append(vm.toString()).append("\n");
        }
        return sb.toString();
    }

    public static Job[] jobs() {
        Value val = DKV.get(LIST);
        if (val == null) {
            return new Job[0];
        }
        JobList jl = (JobList)val.get();
        Job[] jobs = new Job[jl._jobs.length];
        int j = 0;
        for (int i = 0; i < jl._jobs.length; ++i) {
            Value job = DKV.get(jl._jobs[i]);
            if (job == null) continue;
            jobs[j++] = (Job)job.get();
        }
        if (j == jobs.length) {
            return jobs;
        }
        jobs = Arrays.copyOf(jobs, j);
        Key[] keys = new Key[j];
        for (int i = 0; i < j; ++i) {
            keys[i] = jobs[i]._key;
        }
        DKV.DputIfMatch(LIST, new Value(LIST, new JobList(keys)), val, new Futures());
        return jobs;
    }

    public final Key<T> dest() {
        return this._dest;
    }

    public final Key<Job> jobKey() {
        return this._key;
    }

    public boolean isCancelledOrCrashed() {
        return this._state == JobState.CANCELLED || this._state == JobState.FAILED;
    }

    public boolean isRunning() {
        return this._state == JobState.RUNNING;
    }

    public boolean isDone() {
        return this._state == JobState.DONE;
    }

    public boolean isStopped() {
        return this._state == JobState.DONE || this.isCancelledOrCrashed();
    }

    public static boolean isRunning(Key<Job> job_key) {
        return job_key.get().isRunning();
    }

    public final long msec() {
        switch (this._state) {
            case CREATED: {
                return 0L;
            }
            case RUNNING: {
                return System.currentTimeMillis() - this._start_time;
            }
        }
        return this._end_time - this._start_time;
    }

    private Job(Key<T> jobKey, Key<T> dest, String desc) {
        super(jobKey);
        this._description = desc;
        this._dest = dest;
        this._state = JobState.CREATED;
    }

    public Job(Key<T> dest, String desc) {
        this(Job.defaultJobKey(), dest, desc);
    }

    private static Key defaultJobKey() {
        return Key.make((byte)0, (byte)3, false, H2O.SELF);
    }

    protected Job<T> start(final H2O.H2OCountedCompleter fjtask, long work, boolean restartTimer) {
        if (work >= 0L) {
            this._progressKey = this.createProgressKey();
            DKV.put(this._progressKey, new Progress(work));
        }
        assert (this._state == JobState.CREATED) : "Trying to run job which was already run?";
        assert (fjtask != null) : "Starting a job with null working task is not permitted!";
        assert (fjtask.getCompleter() == null) : "Cannot have a completer; this must be a top-level task";
        this._fjtask = fjtask;
        this._barrier = new H2O.H2OCountedCompleter(){

            @Override
            public void compute2() {
            }

            @Override
            public boolean onExceptionalCompletion(Throwable ex, CountedCompleter caller) {
                if (this.getCompleter() == null) {
                    System.err.println("barrier onExCompletion for " + fjtask);
                    ex.printStackTrace();
                    Job.this.failed(ex);
                }
                return true;
            }
        };
        fjtask.setCompleter(this._barrier);
        if (restartTimer) {
            this._start_time = System.currentTimeMillis();
        }
        this._state = JobState.RUNNING;
        DKV.put(this._key, this);
        final Key jobkey = this._key;
        new TAtomic<JobList>(){

            @Override
            public JobList atomic(JobList old) {
                if (old == null) {
                    old = new JobList();
                }
                Key<Job>[] jobs = old._jobs;
                old._jobs = Arrays.copyOf(jobs, jobs.length + 1);
                old._jobs[jobs.length] = jobkey;
                return old;
            }
        }.invoke(LIST);
        H2O.submitTask(fjtask);
        return this;
    }

    protected Key createProgressKey() {
        return Key.make();
    }

    protected boolean deleteProgressKey() {
        return true;
    }

    public T get() {
        this.block();
        assert (!this.isRunning()) : "Job state should not be running, but it is " + (Object)((Object)this._state);
        return this._dest.get();
    }

    public void block() {
        assert (this._fjtask != null) : "Cannot block on missing F/J task";
        this._barrier.join();
    }

    public void done() {
        this.done(false);
    }

    protected void done(boolean force) {
        if (force || this.canBeDone()) {
            this.changeJobState(null, JobState.DONE);
        }
    }

    protected boolean canBeDone() {
        return true;
    }

    public void cancel() {
        this.changeJobState(null, JobState.CANCELLED);
    }

    public void failed(Throwable ex) {
        String stackTrace = StringUtils.toString(ex);
        this.changeJobState("Got exception '" + ex.getClass() + "', with msg '" + ex.getMessage() + "'\n" + stackTrace, JobState.FAILED);
    }

    public void cancel(String msg) {
        this.changeJobState(msg, msg == null ? JobState.CANCELLED : JobState.FAILED);
    }

    private void changeJobState(final String msg, final JobState resultingState) {
        assert (resultingState != JobState.RUNNING);
        if (this._state == JobState.CANCELLED) {
            Log.info("Canceled job " + this._key + "(" + this._description + ") was cancelled again.");
        }
        if (this._state == resultingState) {
            return;
        }
        final float finalProgress = resultingState == JobState.DONE ? 1.0f : this.progress_impl();
        final long done = System.currentTimeMillis();
        new TAtomic<Job>(){

            @Override
            public Job atomic(Job old) {
                if (old == null) {
                    return null;
                }
                if (resultingState.ordinal() <= old._state.ordinal()) {
                    return null;
                }
                old._exception = msg;
                old._state = resultingState;
                old._end_time = done;
                old._finalProgress = finalProgress;
                return old;
            }
        }.invoke(this._key);
        if (this != DKV.getGet(this._key)) {
            this._exception = msg;
            this._state = resultingState;
            this._end_time = done;
            this._finalProgress = finalProgress;
        }
        if (this.deleteProgressKey()) {
            DKV.remove(this._progressKey);
        }
    }

    public float progress() {
        return this.isStopped() ? this._finalProgress : this.progress_impl();
    }

    private Progress getProgress() {
        Value val;
        Key<Progress> k = this._progressKey;
        return k != null && (val = DKV.get(k)) != null ? (Progress)val.get() : null;
    }

    private float progress_impl() {
        Progress p = this.getProgress();
        return p == null ? 0.0f : p.progress();
    }

    public String progress_msg() {
        return this.isStopped() ? this._state.toString() : this.progress_msg_impl();
    }

    private String progress_msg_impl() {
        Progress p = this.getProgress();
        return p == null ? "" : p.progress_msg();
    }

    public final void update(long newworked) {
        this.update(newworked, null);
    }

    public final void update(long newworked, String msg) {
        new ProgressUpdate(newworked, msg).fork(this._progressKey);
    }

    public static void update(long newworked, Key<Job> jobkey) {
        Job.update(newworked, null, jobkey);
    }

    public static void update(long newworked, String msg, Key<Job> jobkey) {
        jobkey.get().update(newworked, msg);
    }

    @Override
    protected Futures remove_impl(Futures fs) {
        if (null != this._progressKey && this.deleteProgressKey()) {
            DKV.remove(this._progressKey, fs);
        }
        return fs;
    }

    @Override
    protected long checksum_impl() {
        throw H2O.fail("Job checksum does not exist by definition");
    }

    public static final class ValidationMessage
    extends Iced {
        final MessageType message_type;
        final String field_name;
        final String message;

        public ValidationMessage(MessageType message_type, String field_name, String message) {
            this.message_type = message_type;
            this.field_name = field_name;
            this.message = message;
            switch (message_type) {
                case INFO: {
                    Log.info(field_name + ": " + message);
                    break;
                }
                case WARN: {
                    Log.warn(field_name + ": " + message);
                    break;
                }
                case ERROR: {
                    Log.err(field_name + ": " + message);
                }
            }
        }

        public MessageType getMessageType() {
            return this.message_type;
        }

        public String toString() {
            return (Object)((Object)this.message_type) + " on field: " + this.field_name + ": " + this.message;
        }

        public static enum MessageType {
            HIDE,
            INFO,
            WARN,
            ERROR;

        }
    }

    public static class JobCancelledException
    extends RuntimeException {
    }

    public static class ProgressUpdate
    extends TAtomic<Progress> {
        final long _newwork;
        final String _progress_msg;

        public ProgressUpdate(long newwork, String progress_msg) {
            this._newwork = newwork;
            this._progress_msg = progress_msg;
        }

        public ProgressUpdate(String progress_msg) {
            this(0L, progress_msg);
        }

        @Override
        public Progress atomic(Progress old) {
            if (old == null) {
                return old;
            }
            old._worked += this._newwork;
            if (this._progress_msg != null) {
                old._progress_msg = this._progress_msg;
            }
            return old;
        }
    }

    public static class Progress
    extends Keyed<Progress> {
        private final long _work;
        private long _worked;
        private float _fraction_done;
        private String _progress_msg;

        @Override
        protected long checksum_impl() {
            return 2134340823432L * this._work + 9023742947234L * this._worked + (long)(1.2343242E13f * this._fraction_done) + (long)this._progress_msg.hashCode();
        }

        public Progress() {
            this._work = -1L;
            this._fraction_done = 0.0f;
            this._progress_msg = "Running...";
        }

        public Progress(long total) {
            this._work = total;
            this._fraction_done = -1.0f;
            this._progress_msg = "Running...";
        }

        public float progress() {
            if (this._work >= 0L) {
                return this._work == 0L ? 0.0f : Math.max(0.0f, Math.min(1.0f, (float)this._worked / (float)this._work));
            }
            return this._fraction_done;
        }

        public String progress_msg() {
            return this._progress_msg;
        }
    }

    public static enum JobState {
        CREATED,
        RUNNING,
        DONE,
        CANCELLED,
        FAILED;

    }

    private static class JobList
    extends Keyed {
        Key<Job>[] _jobs;

        JobList() {
            super(LIST);
            this._jobs = new Key[0];
        }

        private JobList(Key<Job>[] jobs) {
            super(LIST);
            this._jobs = jobs;
        }

        @Override
        protected long checksum_impl() {
            throw H2O.fail("Joblist checksum does not exist by definition");
        }
    }
}

