/*
 * Decompiled with CFR 0.152.
 */
package water;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import water.H2O;
import water.Key;
import water.api.RequestServer;
import water.fvec.UploadFileVec;
import water.util.Log;

public class NanoHTTPD {
    public static final String HTTP_OK = "200 OK";
    public static final String HTTP_PARTIALCONTENT = "206 Partial Content";
    public static final String HTTP_RANGE_NOT_SATISFIABLE = "416 Requested Range Not Satisfiable";
    public static final String HTTP_REDIRECT = "301 Moved Permanently";
    public static final String HTTP_NOTMODIFIED = "304 Not Modified";
    public static final String HTTP_FORBIDDEN = "403 Forbidden";
    public static final String HTTP_UNAUTHORIZED = "401 Unauthorized";
    public static final String HTTP_NOTFOUND = "404 Not Found";
    public static final String HTTP_BADREQUEST = "400 Bad Request";
    public static final String HTTP_TOOLONGREQUEST = "414 Request-URI Too Long";
    public static final String HTTP_INTERNALERROR = "500 Internal Server Error";
    public static final String HTTP_NOTIMPLEMENTED = "501 Not Implemented";
    public static final String MIME_PLAINTEXT = "text/plain";
    public static final String MIME_HTML = "text/html";
    public static final String MIME_JSON = "application/json";
    public static final String MIME_DEFAULT_BINARY = "application/octet-stream";
    public static final String MIME_XML = "text/xml";
    private final ServerSocket myServerSocket;
    private Thread myThread;
    private File myRootDir;
    private static Hashtable theMimeTypes = new Hashtable();
    private static int theBufferSize;
    protected static final PrintStream myOut;
    private static SimpleDateFormat gmtFrmt;
    private static final String LICENCE = "Copyright (C) 2001,2005-2011 by Jarno Elonen <elonen@iki.fi>\nand Copyright (C) 2010 by Konstantinos Togias <info@ktogias.gr>\n\nRedistribution and use in source and binary forms, with or without\nmodification, are permitted provided that the following conditions\nare met:\n\nRedistributions of source code must retain the above copyright notice,\nthis list of conditions and the following disclaimer. Redistributions in\nbinary form must reproduce the above copyright notice, this list of\nconditions and the following disclaimer in the documentation and/or other\nmaterials provided with the distribution. The name of the author may not\nbe used to endorse or promote products derived from this software without\nspecific prior written permission. \n \nTHIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR\nIMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES\nOF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.\nIN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,\nINCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT\nNOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,\nDATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY\nTHEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT\n(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE\nOF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.";

    public Response serve(String uri, String method, Properties header, Properties parms) {
        String value;
        myOut.println(method + " '" + uri + "' ");
        Enumeration<?> e = header.propertyNames();
        while (e.hasMoreElements()) {
            value = (String)e.nextElement();
            myOut.println("  HDR: '" + value + "' = '" + header.getProperty(value) + "'");
        }
        e = parms.propertyNames();
        while (e.hasMoreElements()) {
            value = (String)e.nextElement();
            myOut.println("  PRM: '" + value + "' = '" + parms.getProperty(value) + "'");
        }
        return this.serveFile(uri, header, this.myRootDir, true);
    }

    public NanoHTTPD() {
        this.myServerSocket = null;
    }

    public NanoHTTPD(ServerSocket socket, File wwwroot) throws IOException {
        this.myRootDir = wwwroot;
        this.myServerSocket = socket;
        this.myServerSocket.setReuseAddress(true);
        this.myThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    while (true) {
                        new HTTPSession(NanoHTTPD.this.myServerSocket.accept());
                    }
                }
                catch (IOException iOException) {
                    return;
                }
            }
        }, "NanoHTTPD Thread");
        this.myThread.setDaemon(true);
        this.myThread.start();
    }

    public void stop() {
        try {
            this.myServerSocket.close();
            this.myThread.join();
        }
        catch (IOException | InterruptedException exception) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        myOut.println("NanoHTTPD 1.25 (C) 2001,2005-2011 Jarno Elonen and (C) 2010 Konstantinos Togias\n(Command line options: [-p port] [-d root-dir] [--licence])\n");
        int port = 80;
        File wwwroot = new File(".").getAbsoluteFile();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-p")) {
                port = Integer.parseInt(args[i + 1]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-d")) {
                wwwroot = new File(args[i + 1]).getAbsoluteFile();
                continue;
            }
            if (!args[i].toLowerCase().endsWith("licence")) continue;
            myOut.println("Copyright (C) 2001,2005-2011 by Jarno Elonen <elonen@iki.fi>\nand Copyright (C) 2010 by Konstantinos Togias <info@ktogias.gr>\n\nRedistribution and use in source and binary forms, with or without\nmodification, are permitted provided that the following conditions\nare met:\n\nRedistributions of source code must retain the above copyright notice,\nthis list of conditions and the following disclaimer. Redistributions in\nbinary form must reproduce the above copyright notice, this list of\nconditions and the following disclaimer in the documentation and/or other\nmaterials provided with the distribution. The name of the author may not\nbe used to endorse or promote products derived from this software without\nspecific prior written permission. \n \nTHIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR\nIMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES\nOF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.\nIN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,\nINCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT\nNOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,\nDATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY\nTHEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT\n(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE\nOF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\n");
            break;
        }
        try {
            new NanoHTTPD(new ServerSocket(port), wwwroot);
        }
        catch (IOException ioe) {
            Log.err("Couldn't start server:\n", ioe);
            H2O.shutdown(-1);
        }
        myOut.println("Now serving files in port " + port + " from \"" + wwwroot + "\"");
        myOut.println("Hit Enter to stop.\n");
        try {
            System.in.read();
        }
        catch (Throwable t) {
            Log.err(t);
        }
    }

    private String encodeUri(String uri) {
        String newUri = "";
        StringTokenizer st = new StringTokenizer(uri, "/ ", true);
        block10: while (st.hasMoreTokens()) {
            String tok;
            String string = tok = st.nextToken();
            int n = -1;
            switch (string.hashCode()) {
                case 47: {
                    if (!string.equals("/")) break;
                    n = 0;
                    break;
                }
                case 32: {
                    if (!string.equals(" ")) break;
                    n = 1;
                }
            }
            switch (n) {
                case 0: {
                    newUri = newUri + "/";
                    continue block10;
                }
                case 1: {
                    newUri = newUri + "%20";
                    continue block10;
                }
            }
            try {
                newUri = newUri + URLEncoder.encode(tok, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw Log.throwErr(e);
            }
        }
        return newUri;
    }

    public Response serveFile(String uri, Properties header, File homeDir, boolean allowDirectoryListing) {
        Response res;
        block45: {
            res = null;
            if (!homeDir.isDirectory()) {
                res = new Response(HTTP_INTERNALERROR, MIME_PLAINTEXT, "INTERNAL ERRROR: serveFile(): given homeDir is not a directory.");
            }
            if (res == null) {
                if ((uri = uri.trim().replace(File.separatorChar, '/')).indexOf(63) >= 0) {
                    uri = uri.substring(0, uri.indexOf(63));
                }
                if (uri.startsWith("..") || uri.endsWith("..") || uri.contains("../")) {
                    res = new Response(HTTP_FORBIDDEN, MIME_PLAINTEXT, "FORBIDDEN: Won't serve ../ for security reasons.");
                }
            }
            File f = new File(homeDir, uri);
            if (res == null && !f.exists()) {
                res = new Response(HTTP_NOTFOUND, MIME_PLAINTEXT, "Error 404, file not found.");
            }
            if (res == null && f.isDirectory()) {
                if (!uri.endsWith("/")) {
                    uri = uri + "/";
                    res = new Response(HTTP_REDIRECT, MIME_HTML, "<html><body>Redirected: <a href=\"" + uri + "\">" + uri + "</a></body></html>");
                    res.addHeader("Location", uri);
                }
                if (res == null) {
                    if (new File(f, "index.html").exists()) {
                        f = new File(homeDir, uri + "/index.html");
                    } else if (new File(f, "index.htm").exists()) {
                        f = new File(homeDir, uri + "/index.htm");
                    } else if (allowDirectoryListing && f.canRead()) {
                        String u;
                        int slash;
                        String[] files = f.list();
                        String msg = "<html><body><h1>Directory " + uri + "</h1><br/>";
                        if (uri.length() > 1 && (slash = (u = uri.substring(0, uri.length() - 1)).lastIndexOf(47)) >= 0 && slash < u.length()) {
                            msg = msg + "<b><a href=\"" + uri.substring(0, slash + 1) + "\">..</a></b><br/>";
                        }
                        if (files != null) {
                            for (int i = 0; i < files.length; ++i) {
                                File curFile = new File(f, files[i]);
                                boolean dir = curFile.isDirectory();
                                if (dir) {
                                    msg = msg + "<b>";
                                    int n = i;
                                    files[n] = files[n] + "/";
                                }
                                msg = msg + "<a href=\"" + this.encodeUri(uri + files[i]) + "\">" + files[i] + "</a>";
                                if (curFile.isFile()) {
                                    long len = curFile.length();
                                    msg = msg + " &nbsp;<font size=2>(";
                                    msg = len < 1024L ? msg + len + " bytes" : (len < 0x100000L ? msg + len / 1024L + "." + len % 1024L / 10L % 100L + " KB" : msg + len / 0x100000L + "." + len % 0x100000L / 10L % 100L + " MB");
                                    msg = msg + ")</font>";
                                }
                                msg = msg + "<br/>";
                                if (!dir) continue;
                                msg = msg + "</b>";
                            }
                        }
                        msg = msg + "</body></html>";
                        res = new Response(HTTP_OK, MIME_HTML, msg);
                    } else {
                        res = new Response(HTTP_FORBIDDEN, MIME_PLAINTEXT, "FORBIDDEN: No directory listing.");
                    }
                }
            }
            try {
                if (res != null) break block45;
                String mime = null;
                int dot = f.getCanonicalPath().lastIndexOf(46);
                if (dot >= 0) {
                    mime = (String)theMimeTypes.get(f.getCanonicalPath().substring(dot + 1).toLowerCase());
                }
                if (mime == null) {
                    mime = MIME_DEFAULT_BINARY;
                }
                String etag = Integer.toHexString((f.getAbsolutePath() + f.lastModified() + "" + f.length()).hashCode());
                long startFrom = 0L;
                long endAt = -1L;
                String range = header.getProperty("range");
                if (range != null && range.startsWith("bytes=")) {
                    range = range.substring("bytes=".length());
                    int minus = range.indexOf(45);
                    try {
                        if (minus > 0) {
                            startFrom = Long.parseLong(range.substring(0, minus));
                            endAt = Long.parseLong(range.substring(minus + 1));
                        }
                    }
                    catch (NumberFormatException e) {
                        Log.err(e);
                    }
                }
                long fileLen = f.length();
                if (range != null && startFrom >= 0L) {
                    long newLen;
                    if (startFrom >= fileLen) {
                        res = new Response(HTTP_RANGE_NOT_SATISFIABLE, MIME_PLAINTEXT, "");
                        res.addHeader("Content-Range", "bytes 0-0/" + fileLen);
                        res.addHeader("ETag", etag);
                        break block45;
                    }
                    if (endAt < 0L) {
                        endAt = fileLen - 1L;
                    }
                    if ((newLen = endAt - startFrom + 1L) < 0L) {
                        newLen = 0L;
                    }
                    final long dataLen = newLen;
                    FileInputStream fis = new FileInputStream(f){

                        @Override
                        public int available() throws IOException {
                            return (int)dataLen;
                        }
                    };
                    Throwable throwable = null;
                    try {
                        fis.skip(startFrom);
                        res = new Response(HTTP_PARTIALCONTENT, mime, fis);
                        res.addHeader("Content-Length", "" + dataLen);
                        res.addHeader("Content-Range", "bytes " + startFrom + "-" + endAt + "/" + fileLen);
                        res.addHeader("ETag", etag);
                        break block45;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (fis != null) {
                            if (throwable != null) {
                                try {
                                    fis.close();
                                }
                                catch (Throwable x2) {
                                    throwable.addSuppressed(x2);
                                }
                            } else {
                                fis.close();
                            }
                        }
                    }
                }
                if (etag.equals(header.getProperty("if-none-match"))) {
                    res = new Response(HTTP_NOTMODIFIED, mime, "");
                } else {
                    res = new Response(HTTP_OK, mime, new FileInputStream(f));
                    res.addHeader("Content-Length", "" + fileLen);
                    res.addHeader("ETag", etag);
                }
            }
            catch (IOException e) {
                Log.err(e);
                res = new Response(HTTP_FORBIDDEN, MIME_PLAINTEXT, "FORBIDDEN: Reading file failed.");
            }
        }
        res.addHeader("Accept-Ranges", "bytes");
        return res;
    }

    static {
        StringTokenizer st = new StringTokenizer("css\t\ttext/css htm\t\ttext/html html\t\ttext/html xml\t\ttext/xml txt\t\ttext/plain asc\t\ttext/plain gif\t\timage/gif jpg\t\timage/jpeg jpeg\t\timage/jpeg png\t\timage/png mp3\t\taudio/mpeg m3u\t\taudio/mpeg-url mp4\t\tvideo/mp4 ogv\t\tvideo/ogg flv\t\tvideo/x-flv mov\t\tvideo/quicktime swf\t\tapplication/x-shockwave-flash js\t\t\tapplication/javascript pdf\t\tapplication/pdf doc\t\tapplication/msword ogg\t\tapplication/x-ogg zip\t\tapplication/octet-stream exe\t\tapplication/octet-stream class\t\tapplication/octet-stream ");
        while (st.hasMoreTokens()) {
            theMimeTypes.put(st.nextToken(), st.nextToken());
        }
        theBufferSize = 16384;
        myOut = System.out;
        gmtFrmt = new SimpleDateFormat("E, d MMM yyyy HH:mm:ss 'GMT'", Locale.US);
        gmtFrmt.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    private static final class InputStreamWrapper
    extends InputStream {
        static final byte[] BOUNDARY_PREFIX = new byte[]{13, 10, 45, 45};
        final InputStream _wrapped;
        final byte[] _boundary;
        final byte[] _lookAheadBuf;
        int _lookAheadLen;

        public InputStreamWrapper(InputStream is, byte[] boundary) {
            this._wrapped = is;
            this._boundary = Arrays.copyOf(BOUNDARY_PREFIX, BOUNDARY_PREFIX.length + boundary.length);
            System.arraycopy(boundary, 0, this._boundary, BOUNDARY_PREFIX.length, boundary.length);
            this._lookAheadBuf = new byte[this._boundary.length];
            this._lookAheadLen = 0;
        }

        @Override
        public void close() throws IOException {
            this._wrapped.close();
        }

        @Override
        public int available() throws IOException {
            return this._wrapped.available();
        }

        @Override
        public long skip(long n) throws IOException {
            return this._wrapped.skip(n);
        }

        @Override
        public void mark(int readlimit) {
            this._wrapped.mark(readlimit);
        }

        @Override
        public void reset() throws IOException {
            this._wrapped.reset();
        }

        @Override
        public boolean markSupported() {
            return this._wrapped.markSupported();
        }

        @Override
        public int read() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int pos;
            if (this._lookAheadLen == -1) {
                return -1;
            }
            int readLen = this.readInternal(b, off, len);
            if (readLen != -1 && (pos = this.findBoundary(b, off, readLen)) != -1) {
                this._lookAheadLen = -1;
                return pos - off;
            }
            return readLen;
        }

        private int readInternal(byte[] b, int off, int len) throws IOException {
            if (len < this._lookAheadLen) {
                System.arraycopy(this._lookAheadBuf, 0, b, off, len);
                this._lookAheadLen -= len;
                System.arraycopy(this._lookAheadBuf, len, this._lookAheadBuf, 0, this._lookAheadLen);
                return len;
            }
            if (this._lookAheadLen > 0) {
                System.arraycopy(this._lookAheadBuf, 0, b, off, this._lookAheadLen);
                int r = Math.max(this._wrapped.read(b, off += this._lookAheadLen, len -= this._lookAheadLen), 0) + this._lookAheadLen;
                this._lookAheadLen = 0;
                return r;
            }
            return this._wrapped.read(b, off, len);
        }

        private int findBoundary(byte[] b, int off, int len) throws IOException {
            int bidx = -1;
            int idx = 0;
            for (int i = off; i < off + len; ++i) {
                if (this._boundary[idx] != b[i]) {
                    idx = 0;
                    bidx = -1;
                }
                if (this._boundary[idx] != b[i]) continue;
                if (idx == 0) {
                    bidx = i;
                }
                if (++idx != this._boundary.length) continue;
                return bidx;
            }
            if (bidx != -1) {
                assert (this._lookAheadLen == 0);
                this._lookAheadLen = this._boundary.length - idx;
                int readLen = this._wrapped.read(this._lookAheadBuf, 0, this._lookAheadLen);
                if (readLen < this._boundary.length - idx) {
                    this._lookAheadLen = readLen;
                    return -1;
                }
                for (int i = 0; i < this._boundary.length - idx; ++i) {
                    if (this._boundary[i + idx] == this._lookAheadBuf[i]) continue;
                    return -1;
                }
            }
            return bidx;
        }
    }

    private class HTTPSession
    implements Runnable {
        private final long startMillis = System.currentTimeMillis();
        static final int MAX_HEADER_BUFFER_SIZE = 65536;
        private Socket mySocket;

        public HTTPSession(Socket s) {
            this.mySocket = s;
            Thread t = new Thread((Runnable)this, "NanoHTTPD Session");
            t.setDaemon(true);
            t.setPriority(9);
            t.start();
        }

        @Override
        public void run() {
            try {
                Socket mySocket = this.mySocket;
                Throwable throwable = null;
                try {
                    Response r;
                    int splitbyte;
                    BufferedInputStream is = new BufferedInputStream(mySocket.getInputStream());
                    ((InputStream)is).mark(65536);
                    int bufsize = 8192;
                    byte[] buf = new byte[bufsize];
                    boolean nl = false;
                    int rlen = 0;
                    while (rlen < 65536) {
                        int b = ((InputStream)is).read();
                        if (b == -1) {
                            return;
                        }
                        buf[rlen++] = (byte)b;
                        if (b == 10) {
                            if (nl) break;
                            nl = true;
                        } else if (b != 13) {
                            nl = false;
                        }
                        if (rlen != buf.length) continue;
                        buf = Arrays.copyOf(buf, 2 * buf.length);
                    }
                    if (rlen == 65536) {
                        this.sendError(NanoHTTPD.HTTP_TOOLONGREQUEST, "Requested URL is too long!");
                    }
                    ByteArrayInputStream hbis = new ByteArrayInputStream(buf, 0, rlen);
                    BufferedReader hin = new BufferedReader(new InputStreamReader(hbis));
                    Properties pre = new Properties();
                    Properties parms = new Properties();
                    Properties header = new Properties();
                    this.decodeHeader(hin, pre, parms, header);
                    String method = pre.getProperty("method");
                    String uri = pre.getProperty("uri");
                    long size = Long.MAX_VALUE;
                    String contentLength = header.getProperty("content-length");
                    if (contentLength != null) {
                        try {
                            size = Integer.parseInt(contentLength);
                        }
                        catch (NumberFormatException ex) {
                            // empty catch block
                        }
                    }
                    boolean sbfound = false;
                    for (splitbyte = 0; splitbyte < rlen; ++splitbyte) {
                        if (buf[splitbyte] != 13 || buf[++splitbyte] != 10 || buf[++splitbyte] != 13 || buf[++splitbyte] != 10) continue;
                        sbfound = true;
                        break;
                    }
                    ((InputStream)is).reset();
                    ((InputStream)is).skip(++splitbyte);
                    if (splitbyte < rlen) {
                        size -= (long)(rlen - splitbyte + 1);
                    } else if (!sbfound || size == Long.MAX_VALUE) {
                        size = 0L;
                    }
                    BufferedReader in = new BufferedReader(new InputStreamReader(is));
                    if (method.equalsIgnoreCase("POST")) {
                        StringTokenizer st;
                        String contentType = "";
                        String contentTypeHeader = header.getProperty("content-type");
                        if (contentTypeHeader == null) {
                            contentTypeHeader = "";
                        }
                        if ((st = new StringTokenizer(contentTypeHeader, "; ")).hasMoreTokens()) {
                            contentType = st.nextToken();
                        }
                        if (contentType.equalsIgnoreCase("multipart/form-data")) {
                            String boundaryExp;
                            if (!st.hasMoreTokens()) {
                                this.sendError(NanoHTTPD.HTTP_BADREQUEST, "BAD REQUEST: Content type is multipart/form-data but boundary missing. Usage: GET /example/file.html");
                            }
                            if ((st = new StringTokenizer(boundaryExp = st.nextToken(), "=")).countTokens() != 2) {
                                this.sendError(NanoHTTPD.HTTP_BADREQUEST, "BAD REQUEST: Content type is multipart/form-data but boundary syntax error. Usage: GET /example/file.html");
                            }
                            st.nextToken();
                            String boundary = st.nextToken();
                            String paddedMethod = String.format("%-6s", method);
                            Log.info("Method: " + paddedMethod, ", URI: " + uri + ", route: " + "(special case)" + ", parms: " + parms);
                            RequestServer.alwaysLogRequest(uri, "POST", parms);
                            boolean handled = this.fileUpload(boundary, is, parms, uri);
                            if (handled) {
                                return;
                            }
                        } else {
                            String postLine = "";
                            if (size >= 0L) {
                                int n;
                                char[] pbuf = new char[4096];
                                long bytesToRead = size;
                                StringBuilder sb = new StringBuilder();
                                for (long bytesRead = 0L; bytesRead < bytesToRead && (n = in.read(pbuf)) >= 0; bytesRead += (long)n) {
                                    if (n == 0) {
                                        assert (false);
                                        break;
                                    }
                                    sb.append(pbuf, 0, n);
                                }
                                postLine = sb.toString();
                            } else {
                                char[] pbuf = new char[512];
                                int read = in.read(pbuf);
                                while (read >= 0 && !postLine.endsWith("\r\n")) {
                                    postLine = postLine + String.valueOf(pbuf, 0, read);
                                    read = in.read(pbuf);
                                }
                                postLine = postLine.trim();
                            }
                            if (contentType.equalsIgnoreCase(NanoHTTPD.MIME_JSON)) {
                                parms.put("_post_body", postLine);
                            } else {
                                this.decodeParms(postLine, parms);
                            }
                        }
                    }
                    if ((r = NanoHTTPD.this.serve(uri, method, header, parms)) == null) {
                        this.sendError(NanoHTTPD.HTTP_INTERNALERROR, "SERVER INTERNAL ERROR: Serve() returned a null response.");
                    } else {
                        this.sendResponse(r.status, r.mimeType, r.header, r.data);
                    }
                    in.close();
                    ((InputStream)is).close();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (mySocket != null) {
                        if (throwable != null) {
                            try {
                                mySocket.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                        } else {
                            mySocket.close();
                        }
                    }
                }
            }
            catch (IOException ioe) {
                try {
                    this.sendError(NanoHTTPD.HTTP_INTERNALERROR, "SERVER INTERNAL ERROR: IOException: " + ioe.getMessage());
                }
                catch (Throwable t) {
                    Log.err(t);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        private void decodeHeader(BufferedReader in, Properties pre, Properties parms, Properties header) throws InterruptedException {
            try {
                String uri;
                int qmi;
                String inLine = in.readLine();
                if (inLine == null) {
                    return;
                }
                StringTokenizer st = new StringTokenizer(inLine);
                if (!st.hasMoreTokens()) {
                    this.sendError(NanoHTTPD.HTTP_BADREQUEST, "BAD REQUEST: Syntax error. Usage: GET /example/file.html");
                }
                String method = st.nextToken();
                pre.put("method", method);
                if (!st.hasMoreTokens()) {
                    this.sendError(NanoHTTPD.HTTP_BADREQUEST, "BAD REQUEST: Missing URI. Usage: GET /example/file.html");
                }
                if ((qmi = (uri = st.nextToken()).indexOf(63)) >= 0) {
                    this.decodeParms(uri.substring(qmi + 1), parms);
                    uri = this.decodePercent(uri.substring(0, qmi));
                } else {
                    uri = this.decodePercent(uri);
                }
                if (st.hasMoreTokens()) {
                    String line = in.readLine();
                    while (line != null && line.trim().length() > 0) {
                        int p = line.indexOf(58);
                        if (p >= 0) {
                            header.put(line.substring(0, p).trim().toLowerCase(), line.substring(p + 1).trim());
                        }
                        line = in.readLine();
                    }
                }
                pre.put("uri", uri);
            }
            catch (IOException ioe) {
                this.sendError(NanoHTTPD.HTTP_INTERNALERROR, "SERVER INTERNAL ERROR: IOException: " + ioe.getMessage());
            }
        }

        public String readLine(InputStream in) throws IOException {
            int sz;
            StringBuilder sb = new StringBuilder();
            byte[] mem = new byte[1024];
            do {
                sz = this.readBufOrLine(in, mem);
                sb.append(new String(mem, 0, sz));
            } while (sz >= mem.length && mem[sz - 1] != 10);
            if (sb.length() == 0) {
                return null;
            }
            String line = sb.toString();
            if (line.endsWith("\r\n")) {
                line = line.substring(0, line.length() - 2);
            } else if (line.endsWith("\n")) {
                line = line.substring(0, line.length() - 1);
            }
            return line;
        }

        private int readBufOrLine(InputStream in, byte[] mem) throws IOException {
            byte[] bb = new byte[1];
            int sz = 0;
            while (sz != mem.length) {
                byte b2;
                byte b;
                try {
                    in.read(bb, 0, 1);
                    b = bb[0];
                    mem[sz++] = b;
                }
                catch (EOFException e) {
                    break;
                }
                if (b == 10 || sz == mem.length) break;
                if (b != 13) continue;
                try {
                    in.read(bb, 0, 1);
                    b2 = bb[0];
                    mem[sz++] = b2;
                }
                catch (EOFException e) {
                    break;
                }
                if (b2 != 10) continue;
                break;
            }
            return sz;
        }

        private boolean validKeyName(String name) {
            byte[] arr;
            for (byte b : arr = name.getBytes()) {
                if (b == 34) {
                    return false;
                }
                if (b != 92) continue;
                return false;
            }
            return true;
        }

        private boolean fileUpload(String boundary, InputStream in, Properties parms, String uri) throws InterruptedException {
            try {
                String line = this.readLine(in);
                int i = line.indexOf(boundary);
                if (i != 2) {
                    this.sendError(NanoHTTPD.HTTP_BADREQUEST, "BAD REQUEST: Content type is multipart/form-data but next chunk does not start with boundary. Usage: GET /example/file.html");
                }
                if (line.substring(i + boundary.length()).startsWith("--")) {
                    return false;
                }
                Properties item = new Properties();
                line = this.readLine(in);
                while (line != null && line.trim().length() > 0) {
                    int p = line.indexOf(58);
                    if (p != -1) {
                        item.put(line.substring(0, p).trim().toLowerCase(), line.substring(p + 1).trim());
                    }
                    line = this.readLine(in);
                }
                if (line != null) {
                    boolean uploadFile;
                    String contentDisposition = item.getProperty("content-disposition");
                    if (contentDisposition == null) {
                        this.sendError(NanoHTTPD.HTTP_BADREQUEST, "BAD REQUEST: Content type is multipart/form-data but no content-disposition info found. Usage: GET /example/file.html");
                    }
                    String key = parms.getProperty("key");
                    boolean nps = Pattern.matches("/[^/]+/NodePersistentStorage.*", uri);
                    if (nps) {
                        Pattern p = Pattern.compile(".*NodePersistentStorage/([^/]+)/([^/]+)");
                        Matcher m = p.matcher(uri);
                        boolean b = m.matches();
                        if (!b) {
                            this.sendError(NanoHTTPD.HTTP_BADREQUEST, "NodePersistentStorage URL malformed");
                        }
                        String categoryName = m.group(1);
                        String keyName = m.group(2);
                        H2O.getNPS().put(categoryName, keyName, new InputStreamWrapper(in, boundary.getBytes()));
                        long length = H2O.getNPS().get_length(categoryName, keyName);
                        String responsePayload = "{ \"category\" : \"" + categoryName + "\", " + "\"name\" : " + "\"" + keyName + "\", " + "\"total_bytes\" : " + length + " " + "}";
                        this.sendResponse(NanoHTTPD.HTTP_OK, NanoHTTPD.MIME_JSON, null, new ByteArrayInputStream(responsePayload.getBytes("UTF-8")));
                        return true;
                    }
                    String destination_key = parms.getProperty("destination_frame");
                    if (destination_key == null) {
                        destination_key = "upload" + Key.rand();
                    }
                    if (!this.validKeyName(destination_key)) {
                        this.sendError(NanoHTTPD.HTTP_BADREQUEST, "Invalid key name, contains illegal characters");
                    }
                    boolean bl = uploadFile = Pattern.matches("/PostFile", uri) || Pattern.matches("/[1-9][0-9]*/PostFile", uri) || Pattern.matches("/LATEST/PostFile", uri);
                    if (uploadFile) {
                        UploadFileVec.ReadPutStats stats = new UploadFileVec.ReadPutStats();
                        UploadFileVec.readPut(destination_key, (InputStream)new InputStreamWrapper(in, boundary.getBytes()), stats);
                        String responsePayload = "{ \"destination_frame\": \"" + destination_key + "\", \"total_bytes\": " + stats.total_bytes + " }\n";
                        this.sendResponse(NanoHTTPD.HTTP_OK, NanoHTTPD.MIME_JSON, null, new ByteArrayInputStream(responsePayload.getBytes("UTF-8")));
                        return true;
                    }
                    this.sendError(NanoHTTPD.HTTP_NOTFOUND, "(Attempt to upload data) URL not found");
                }
            }
            catch (Exception e) {
                this.sendError(NanoHTTPD.HTTP_INTERNALERROR, "SERVER INTERNAL ERROR: Exception: " + e.getMessage());
            }
            return false;
        }

        private String decodePercent(String str) throws InterruptedException {
            try {
                StringBuilder sb = new StringBuilder();
                block6: for (int i = 0; i < str.length(); ++i) {
                    char c = str.charAt(i);
                    switch (c) {
                        case '+': {
                            sb.append(' ');
                            continue block6;
                        }
                        case '%': {
                            sb.append((char)Integer.parseInt(str.substring(i + 1, i + 3), 16));
                            i += 2;
                            continue block6;
                        }
                        default: {
                            sb.append(c);
                        }
                    }
                }
                return sb.toString();
            }
            catch (Exception e) {
                this.sendError(NanoHTTPD.HTTP_BADREQUEST, "BAD REQUEST: Bad percent-encoding.");
                return null;
            }
        }

        private void decodeParms(String parms, Properties p) throws InterruptedException {
            if (parms == null) {
                return;
            }
            StringTokenizer st = new StringTokenizer(parms, "&");
            while (st.hasMoreTokens()) {
                String e = st.nextToken();
                int sep = e.indexOf(61);
                if (sep < 0) continue;
                String key = this.decodePercent(e.substring(0, sep)).trim();
                String value = this.decodePercent(e.substring(sep + 1));
                String old = p.getProperty(key, null);
                p.put(key, old == null ? value : old + "," + value);
            }
        }

        private void sendError(String status, String msg) throws InterruptedException {
            long deltaMillis = System.currentTimeMillis() - this.startMillis;
            String s = "         HTTP_status: " + status + ", millis: " + deltaMillis;
            Log.httpd(s);
            this.sendResponse2(status, NanoHTTPD.MIME_PLAINTEXT, null, new ByteArrayInputStream(msg.getBytes()));
            throw new InterruptedException();
        }

        private void sendResponse(String status, String mime, Properties header, InputStream data) {
            long deltaMillis = System.currentTimeMillis() - this.startMillis;
            String s = "         HTTP_status: " + status + ", millis: " + deltaMillis;
            Log.httpd(s);
            this.sendResponse2(status, mime, header, data);
        }

        private void sendResponse2(String status, String mime, Properties header, InputStream data) {
            try {
                if (status == null) {
                    throw new RuntimeException("sendResponse(): Status can't be null.");
                }
                OutputStream out = this.mySocket.getOutputStream();
                PrintWriter pw = new PrintWriter(out);
                pw.print("HTTP/1.0 " + status + " \r\n");
                if (mime != null) {
                    pw.print("Content-Type: " + mime + "\r\n");
                }
                if (header == null || header.getProperty("Date") == null) {
                    pw.print("Date: " + gmtFrmt.format(new Date()) + "\r\n");
                }
                if (header != null) {
                    Enumeration<Object> e = header.keys();
                    while (e.hasMoreElements()) {
                        String key = (String)e.nextElement();
                        String value = header.getProperty(key);
                        pw.print(key + ": " + value + "\r\n");
                    }
                }
                pw.print("X-h2o-build-project-version: " + H2O.ABV.projectVersion() + "\r\n");
                pw.print("X-h2o-rest-api-version-max: 3\r\n");
                pw.print("X-h2o-cluster-id: " + H2O.CLUSTER_ID + "\r\n");
                pw.print("\r\n");
                pw.flush();
                if (data != null) {
                    int read;
                    int pending = data.available();
                    byte[] buff = new byte[theBufferSize];
                    while (pending > 0 && (read = data.read(buff, 0, pending > theBufferSize ? theBufferSize : pending)) > 0) {
                        out.write(buff, 0, read);
                        pending = data.available();
                    }
                }
                out.flush();
                out.close();
                if (data != null) {
                    data.close();
                }
            }
            catch (IOException e) {
                Log.err(e);
                try {
                    this.mySocket.close();
                }
                catch (IOException ignore) {
                    // empty catch block
                }
            }
            if (H2O.getShutdownRequested()) {
                H2O.shutdown(0);
            }
        }
    }

    public class Response {
        public String status;
        public String mimeType;
        public InputStream data;
        public Properties header = new Properties();

        public Response() {
            this.status = NanoHTTPD.HTTP_OK;
        }

        public Response(String status, String mimeType, InputStream data) {
            this.status = status;
            this.mimeType = mimeType;
            this.data = data;
        }

        public Response(String status, String mimeType, String txt) {
            this.status = status;
            this.mimeType = mimeType;
            try {
                this.data = new ByteArrayInputStream(txt.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                Log.err(e);
            }
        }

        public void addHeader(String name, String value) {
            this.header.put(name, value);
        }
    }
}

