/*
 * Decompiled with CFR 0.152.
 */
package water;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Stack;
import water.Futures;
import water.Key;
import water.Keyed;

public class Scope {
    private static final ThreadLocal<Scope> _scope = new ThreadLocal<Scope>(){

        @Override
        protected Scope initialValue() {
            return new Scope();
        }
    };
    private final Stack<HashSet<Key>> _keys = new Stack();

    public static void enter() {
        Scope._scope.get()._keys.push(new HashSet());
    }

    public static Key[] exit(Key ... keep) {
        ArrayList<Key> keylist = new ArrayList<Key>();
        if (keep != null) {
            for (Key k : keep) {
                if (k == null) continue;
                keylist.add(k);
            }
        }
        Object[] arrkeep = keylist.toArray();
        Arrays.sort(arrkeep);
        Stack<HashSet<Key>> keys = Scope._scope.get()._keys;
        if (keys.size() > 0) {
            Futures fs = new Futures();
            for (Key key : keys.pop()) {
                int found = Arrays.binarySearch(arrkeep, key);
                if (arrkeep.length != 0 && found >= 0) continue;
                Keyed.remove(key, fs);
            }
            fs.blockForPending();
        }
        return keep;
    }

    public static void track(Key k) {
        if (k.user_allowed() || !k.isVec()) {
            return;
        }
        Scope scope = _scope.get();
        if (scope == null) {
            return;
        }
        if (scope._keys.size() == 0) {
            return;
        }
        if (!scope._keys.peek().contains(k)) {
            scope._keys.peek().add(k);
        }
    }
}

