/*
 * Decompiled with CFR 0.152.
 */
package water.fvec;

import water.AutoBuffer;
import water.fvec.Chunk;
import water.fvec.NewChunk;
import water.util.UnsafeUtils;

public class C8Chunk
extends Chunk {
    protected static final long _NA = Long.MIN_VALUE;

    C8Chunk(byte[] bs) {
        this._mem = bs;
        this._start = -1L;
        this.set_len(this._mem.length >> 3);
    }

    @Override
    protected final long at8_impl(int i) {
        long res = UnsafeUtils.get8(this._mem, i << 3);
        if (res == Long.MIN_VALUE) {
            throw new IllegalArgumentException("at8_abs but value is missing");
        }
        return res;
    }

    @Override
    protected final double atd_impl(int i) {
        long res = UnsafeUtils.get8(this._mem, i << 3);
        return res == Long.MIN_VALUE ? Double.NaN : (double)res;
    }

    @Override
    protected final boolean isNA_impl(int i) {
        return UnsafeUtils.get8(this._mem, i << 3) == Long.MIN_VALUE;
    }

    @Override
    boolean set_impl(int idx, long l) {
        return false;
    }

    @Override
    boolean set_impl(int i, double d) {
        return false;
    }

    @Override
    boolean set_impl(int i, float f) {
        return false;
    }

    @Override
    boolean setNA_impl(int idx) {
        UnsafeUtils.set8(this._mem, idx << 3, Long.MIN_VALUE);
        return true;
    }

    @Override
    public NewChunk inflate_impl(NewChunk nc) {
        for (int i = 0; i < this._len; ++i) {
            if (this.isNA(i)) {
                nc.addNA();
                continue;
            }
            nc.addNum(this.at8(i), 0);
        }
        nc.set_sparseLen(nc.set_len(this._len));
        return nc;
    }

    @Override
    public C8Chunk read_impl(AutoBuffer bb) {
        this._mem = bb.bufClose();
        this._start = -1L;
        this._cidx = -1;
        this.set_len(this._mem.length >> 3);
        assert (this._mem.length == this._len << 3);
        return this;
    }

    @Override
    public boolean hasFloat() {
        return false;
    }
}

