/*
 * Decompiled with CFR 0.152.
 */
package water.fvec;

import water.AutoBuffer;
import water.MemoryManager;
import water.fvec.Chunk;
import water.fvec.NewChunk;
import water.parser.ValueString;
import water.util.UnsafeUtils;

public class CStrChunk
extends Chunk {
    static final int NA = -1;
    protected static final int _OFF = 4;
    private int _valstart;

    public CStrChunk() {
    }

    public CStrChunk(int sslen, byte[] ss, int sparseLen, int idxLen, int[] strIdx) {
        int i;
        this._start = -1L;
        this._valstart = 4 + (idxLen << 2);
        this.set_len(idxLen);
        this._mem = MemoryManager.malloc1(4 + idxLen * 4 + sslen, false);
        UnsafeUtils.set4(this._mem, 0, 4 + idxLen * 4);
        for (i = 0; i < sparseLen; ++i) {
            UnsafeUtils.set4(this._mem, 4 + 4 * i, strIdx[i]);
        }
        for (i = sparseLen; i < idxLen; ++i) {
            UnsafeUtils.set4(this._mem, 4 + 4 * i, -1);
        }
        for (i = 0; i < sslen; ++i) {
            this._mem[4 + idxLen * 4 + i] = ss[i];
        }
    }

    @Override
    public boolean setNA_impl(int idx) {
        throw new IllegalArgumentException("Operation not allowed on string vector.");
    }

    @Override
    public boolean set_impl(int idx, float f) {
        throw new IllegalArgumentException("Operation not allowed on string vector.");
    }

    @Override
    public boolean set_impl(int idx, double d) {
        throw new IllegalArgumentException("Operation not allowed on string vector.");
    }

    @Override
    public boolean set_impl(int idx, long l) {
        throw new IllegalArgumentException("Operation not allowed on string vector.");
    }

    @Override
    public boolean set_impl(int idx, String str) {
        return false;
    }

    @Override
    public boolean isNA_impl(int idx) {
        int off = UnsafeUtils.get4(this._mem, (idx << 2) + 4);
        return off == -1;
    }

    @Override
    public long at8_impl(int idx) {
        throw new IllegalArgumentException("Operation not allowed on string vector.");
    }

    @Override
    public double atd_impl(int idx) {
        throw new IllegalArgumentException("Operation not allowed on string vector.");
    }

    @Override
    public ValueString atStr_impl(ValueString vstr, int idx) {
        int off = UnsafeUtils.get4(this._mem, (idx << 2) + 4);
        if (off == -1) {
            return null;
        }
        int len = 0;
        while (this._mem[this._valstart + off + len] != 0) {
            ++len;
        }
        return vstr.set(this._mem, this._valstart + off, len);
    }

    @Override
    public boolean isSparse() {
        return false;
    }

    @Override
    public int sparseLen() {
        return this._len;
    }

    @Override
    public CStrChunk read_impl(AutoBuffer bb) {
        this._mem = bb.bufClose();
        this._start = -1L;
        this._cidx = -1;
        this._valstart = UnsafeUtils.get4(this._mem, 0);
        this.set_len(this._valstart - 4 >> 2);
        return this;
    }

    @Override
    public NewChunk inflate_impl(NewChunk nc) {
        nc.set_len(this._len);
        nc.set_sparseLen(this.sparseLen());
        nc._is = MemoryManager.malloc4(this._len);
        for (int i = 0; i < this._len; ++i) {
            nc._is[i] = UnsafeUtils.get4(this._mem, (i << 2) + 4);
        }
        nc._sslen = this._mem.length - this._valstart;
        nc._ss = MemoryManager.malloc1(nc._sslen);
        System.arraycopy(this._mem, this._valstart, nc._ss, 0, nc._sslen);
        return nc;
    }
}

