/*
 * Decompiled with CFR 0.152.
 */
package water.fvec;

import java.util.Iterator;
import water.H2O;
import water.fvec.CXIChunk;
import water.fvec.NewChunk;
import water.util.UnsafeUtils;

public class CXDChunk
extends CXIChunk {
    protected CXDChunk(int len, int nzs, int valsz, byte[] buf) {
        super(len, nzs, valsz, buf);
    }

    protected final double getFValue(int off) {
        if (this.valsz() == 8) {
            return UnsafeUtils.get8d(this._mem, off + this.ridsz());
        }
        throw H2O.fail();
    }

    @Override
    protected long at8_impl(int idx) {
        int off = this.findOffset(idx);
        if (this.getId(off) != idx) {
            return 0L;
        }
        double d = this.getFValue(off);
        if (Double.isNaN(d)) {
            throw new IllegalArgumentException("at8_abs but value is missing");
        }
        return (long)d;
    }

    @Override
    protected double atd_impl(int idx) {
        int off = this.findOffset(idx);
        if (this.getId(off) != idx) {
            return 0.0;
        }
        return this.getFValue(off);
    }

    @Override
    protected boolean isNA_impl(int i) {
        int off = this.findOffset(i);
        if (this.getId(off) != i) {
            return false;
        }
        return Double.isNaN(this.getFValue(off));
    }

    @Override
    public NewChunk inflate_impl(NewChunk nc) {
        int slen = this.sparseLen();
        nc.set_len(this._len);
        nc.set_sparseLen(slen);
        nc.alloc_doubles(slen);
        nc.alloc_indices(slen);
        int off = 6;
        int i = 0;
        while (i < slen) {
            nc.indices()[i] = this.getId(off);
            nc.doubles()[i] = this.getFValue(off);
            ++i;
            off += this.ridsz() + this.valsz();
        }
        return nc;
    }

    @Override
    public Iterator<CXIChunk.Value> values() {
        return new CXIChunk.SparseIterator(new CXIChunk.Value(){

            @Override
            public final long asLong() {
                double d = CXDChunk.this.getFValue(this._off);
                if (Double.isNaN(d)) {
                    throw new IllegalArgumentException("at8_abs but value is missing");
                }
                return (long)d;
            }

            @Override
            public final double asDouble() {
                return CXDChunk.this.getFValue(this._off);
            }

            @Override
            public final boolean isNA() {
                double d = CXDChunk.this.getFValue(this._off);
                return Double.isNaN(d);
            }
        });
    }

    @Override
    public boolean hasFloat() {
        return true;
    }
}

