/*
 * Decompiled with CFR 0.152.
 */
package water.fvec;

import water.DKV;
import water.Futures;
import water.H2O;
import water.Key;
import water.TypeMap;
import water.Value;
import water.fvec.ByteVec;
import water.fvec.Frame;
import water.fvec.Vec;
import water.util.MathUtils;
import water.util.UnsafeUtils;

public abstract class FileVec
extends ByteVec {
    long _len;
    final byte _be;
    public static final int DFLT_LOG2_CHUNK_SIZE = 22;
    public static final int DFLT_CHUNK_SIZE = 0x400000;
    public int _log2ChkSize = 22;
    public int _chunkSize = 0x400000;

    protected FileVec(Key key, long len, byte be) {
        super(key, (long[])null);
        this._len = len;
        this._be = be;
    }

    public int setChunkSize(int chunkSize) {
        return this.setChunkSize(null, chunkSize);
    }

    public int setChunkSize(Frame fr, int chunkSize) {
        if (chunkSize <= 0) {
            throw new IllegalArgumentException("Chunk sizes must be > 0.");
        }
        if (chunkSize > 0x40000000) {
            throw new IllegalArgumentException("Chunk sizes must be < 1G.");
        }
        this._log2ChkSize = MathUtils.log2(chunkSize);
        this._chunkSize = 1 << this._log2ChkSize;
        Futures fs = new Futures();
        DKV.put(this._key, this, fs);
        if (fr != null) {
            fr.reloadVecs();
            DKV.put(fr._key, fr, fs);
        }
        fs.blockForPending();
        return this._chunkSize;
    }

    @Override
    public long length() {
        return this._len;
    }

    @Override
    public int nChunks() {
        return (int)Math.max(1L, this._len >> this._log2ChkSize);
    }

    @Override
    public boolean writable() {
        return false;
    }

    @Override
    public long byteSize() {
        return this.length();
    }

    @Override
    int elem2ChunkIdx(long i) {
        assert (0L <= i && i <= this._len) : " " + i + " < " + this._len;
        int cidx = (int)(i >> this._log2ChkSize);
        int nc = this.nChunks();
        if (i >= this._len) {
            return nc;
        }
        if (cidx >= nc) {
            cidx = nc - 1;
        }
        assert (0 <= cidx && cidx < nc);
        return cidx;
    }

    @Override
    long chunk2StartElem(int cidx) {
        return (long)cidx << this._log2ChkSize;
    }

    public static long chunkOffset(Key ckey) {
        return (long)FileVec.chunkIdx(ckey) << ((FileVec)Vec.getVecKey((Key)ckey).get())._log2ChkSize;
    }

    static int chunkIdx(Key ckey) {
        assert (ckey._kb[0] == 5);
        return UnsafeUtils.get4(ckey._kb, 6);
    }

    @Override
    public Value chunkIdx(int cidx) {
        long nchk = this.nChunks();
        assert (0 <= cidx && (long)cidx < nchk);
        Key dkey = this.chunkKey(cidx);
        Value val1 = DKV.get(dkey);
        if (val1 != null) {
            return val1;
        }
        int len = (int)((long)cidx < nchk - 1L ? (long)this._chunkSize : this._len - this.chunk2StartElem(cidx));
        Value val2 = new Value(dkey, len, null, TypeMap.C1NCHUNK, this._be);
        val2.setdsk();
        Futures fs = dkey.home() ? null : new Futures();
        Value val3 = DKV.DputIfMatch(dkey, val2, null, fs);
        if (!dkey.home() && fs != null) {
            fs.blockForPending();
        }
        return val3 == null ? val2 : val3;
    }

    public static int calcOptimalChunkSize(long totalSize, int numCols) {
        long localParseSize = totalSize / (long)H2O.getCloudSize();
        int chunkSize = (int)(localParseSize / (long)(Runtime.getRuntime().availableProcessors() * 4));
        if (chunkSize <= 65536) {
            return 0x400000;
        }
        if ((chunkSize = 1 << MathUtils.log2(chunkSize)) < 0x400000 && localParseSize / (long)chunkSize * (long)numCols < 0x200000L) {
            return chunkSize;
        }
        long tmp = localParseSize * (long)numCols / 0x200000L;
        if (tmp > 0x40000000L) {
            return 0x40000000;
        }
        if (tmp > 0x400000L) {
            chunkSize = 1 << MathUtils.log2((int)tmp);
            return chunkSize;
        }
        return 0x400000;
    }
}

