/*
 * Decompiled with CFR 0.152.
 */
package water.fvec;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import water.AutoBuffer;
import water.Futures;
import water.H2O;
import water.MemoryManager;
import water.fvec.AppendableVec;
import water.fvec.C0DChunk;
import water.fvec.C0LChunk;
import water.fvec.C16Chunk;
import water.fvec.C1Chunk;
import water.fvec.C1NChunk;
import water.fvec.C1SChunk;
import water.fvec.C2Chunk;
import water.fvec.C2SChunk;
import water.fvec.C4Chunk;
import water.fvec.C4SChunk;
import water.fvec.C8Chunk;
import water.fvec.C8DChunk;
import water.fvec.CBSChunk;
import water.fvec.CStrChunk;
import water.fvec.CUDChunk;
import water.fvec.CX0Chunk;
import water.fvec.CXDChunk;
import water.fvec.CXIChunk;
import water.fvec.Chunk;
import water.fvec.Vec;
import water.parser.ValueString;
import water.util.PrettyPrint;
import water.util.UnsafeUtils;

public class NewChunk
extends Chunk {
    public final int _cidx;
    public transient long[] _ls;
    public transient int[] _xs;
    public transient int[] _id;
    public transient double[] _ds;
    public transient byte[] _ss;
    public transient int[] _is;
    public int _sslen;
    public int _sparseLen;
    private int _naCnt = -1;
    private int _enumCnt;
    private int _strCnt;
    private int _nzCnt;
    private int _uuidCnt;
    public int _timCnt = 0;
    protected static final int MIN_SPARSE_RATIO = 32;
    private int _sparseRatio = 32;
    private static long[] NAS = new long[]{255L, -32768L, Integer.MIN_VALUE, Long.MIN_VALUE};

    long[] alloc_mantissa(int l) {
        this._ls = MemoryManager.malloc8(l);
        return this._ls;
    }

    int[] alloc_exponent(int l) {
        this._xs = MemoryManager.malloc4(l);
        return this._xs;
    }

    int[] alloc_indices(int l) {
        this._id = MemoryManager.malloc4(l);
        return this._id;
    }

    double[] alloc_doubles(int l) {
        this._ds = MemoryManager.malloc8d(l);
        return this._ds;
    }

    int[] alloc_str_indices(int l) {
        this._is = MemoryManager.malloc4(l);
        return this._is;
    }

    protected final long[] mantissa() {
        return this._ls;
    }

    protected final int[] exponent() {
        return this._xs;
    }

    protected final int[] indices() {
        return this._id;
    }

    protected final double[] doubles() {
        return this._ds;
    }

    @Override
    public boolean isSparse() {
        return this.sparse();
    }

    int set_sparseLen(int l) {
        this._sparseLen = l;
        return this._sparseLen;
    }

    @Override
    public int sparseLen() {
        return this._sparseLen;
    }

    protected int naCnt() {
        return this._naCnt;
    }

    protected int enumCnt() {
        return this._enumCnt;
    }

    protected int strCnt() {
        return this._strCnt;
    }

    public NewChunk(Vec vec, int cidx) {
        this._vec = vec;
        this._cidx = cidx;
    }

    public NewChunk(Vec vec, int cidx, boolean sparse) {
        this._vec = vec;
        this._cidx = cidx;
        if (sparse) {
            this._ls = new long[128];
            this._xs = new int[128];
            this._id = new int[128];
        }
    }

    public NewChunk(double[] ds) {
        this._cidx = -1;
        this._vec = null;
        this._ds = ds;
        this._sparseLen = this._len = ds.length;
    }

    public NewChunk(Vec vec, int cidx, long[] mantissa, int[] exponent, int[] indices, double[] doubles) {
        this._vec = vec;
        this._cidx = cidx;
        this._ls = mantissa;
        this._xs = exponent;
        this._id = indices;
        this._ds = doubles;
        if (this._ls != null && this.sparseLen() == 0) {
            this.set_sparseLen(this.set_len(this._ls.length));
        }
        if (this._xs != null && this.sparseLen() == 0) {
            this.set_sparseLen(this.set_len(this._xs.length));
        }
        if (this._id != null && this.sparseLen() == 0) {
            this.set_sparseLen(this.set_len(this._id.length));
        }
        if (this._ds != null && this.sparseLen() == 0) {
            this.set_sparseLen(this.set_len(this._ds.length));
        }
    }

    public NewChunk(Chunk c) {
        this(c._vec, c.cidx());
        this._start = c._start;
    }

    public NewChunk(Vec vec, int cidx, int len) {
        this(vec, cidx);
        this._ds = new double[len];
        Arrays.fill(this._ds, Double.NaN);
        this.set_sparseLen(this.set_len(len));
    }

    public NewChunk setSparseRatio(int s) {
        this._sparseRatio = s;
        return this;
    }

    public void set_vec(Vec vec) {
        this._vec = vec;
    }

    public NewChunk convertEnum2Str(ValueString[] emap) {
        NewChunk strChunk = new NewChunk(this._vec, this._cidx);
        int j = 0;
        int l = this._len;
        for (int i = 0; i < l; ++i) {
            if (this._id != null && this._id.length > 0 && j < this._id.length && this._id[j] == i) {
                strChunk.addStr(emap[(int)this._ls[j++] - 1]);
                continue;
            }
            if (this._xs[i] != Integer.MIN_VALUE) {
                strChunk.addStr(emap[(int)this._ls[i] - 1]);
                continue;
            }
            strChunk.addNA();
        }
        if (this._id != null) assert (j == this.sparseLen()) : "j = " + j + ", sparseLen = " + this.sparseLen();
        return strChunk;
    }

    public Iterator<Value> values() {
        return this.values(0, this._len);
    }

    public Iterator<Value> values(int fromIdx, int toIdx) {
        int gId;
        int lId;
        final int to = Math.min(toIdx, this._len);
        if (this.sparse()) {
            int x = Arrays.binarySearch(this._id, 0, this.sparseLen(), fromIdx);
            if (x < 0) {
                x = -x - 1;
            }
            lId = x;
            gId = x == this.sparseLen() ? this._len : this._id[x];
        } else {
            lId = gId = fromIdx;
        }
        final Value v = new Value(lId, gId);
        final Value next = new Value(lId, gId);
        return new Iterator<Value>(){

            @Override
            public final boolean hasNext() {
                return next._gId < to;
            }

            @Override
            public final Value next() {
                block1: {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    v._gId = next._gId++;
                    v._lId = next._lId++;
                    if (!NewChunk.this.sparse()) break block1;
                    next._gId = next._lId < NewChunk.this.sparseLen() ? NewChunk.this._id[next._lId] : NewChunk.this._len;
                }
                return v;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public byte type() {
        if (this._naCnt == -1) {
            int nas = 0;
            int es = 0;
            int nzs = 0;
            int ss = 0;
            if (this._ds != null && this._ls != null) {
                for (int i = 0; i < this.sparseLen(); ++i) {
                    if (this._xs != null && this._xs[i] == Integer.MIN_VALUE) {
                        ++nas;
                        continue;
                    }
                    if (this._ds[i] == 0.0 && this._ls[i] == 0L) continue;
                    ++nzs;
                }
                this._uuidCnt = this._len - nas;
            } else if (this._ds != null) {
                assert (this._xs == null);
                for (int i = 0; i < this.sparseLen(); ++i) {
                    if (Double.isNaN(this._ds[i])) {
                        ++nas;
                        continue;
                    }
                    if (this._ds[i] == 0.0) continue;
                    ++nzs;
                }
            } else {
                int i;
                if (this._ls != null && this._ls.length > 0) {
                    for (i = 0; i < this.sparseLen(); ++i) {
                        if (this.isNA2(i)) {
                            ++nas;
                            continue;
                        }
                        if (this.isEnum2(i)) {
                            ++es;
                        }
                        if (this._ls[i] == 0L) continue;
                        ++nzs;
                    }
                }
                if (this._is != null) {
                    for (i = 0; i < this.sparseLen(); ++i) {
                        if (this.isNA2(i)) {
                            ++nas;
                            continue;
                        }
                        ++ss;
                    }
                }
            }
            this._nzCnt = nzs;
            this._enumCnt = es;
            this._naCnt = nas;
            this._strCnt = ss;
        }
        if (this._naCnt == this._len) {
            return 1;
        }
        if (this._strCnt > 0) {
            return 6;
        }
        if (this._enumCnt > 0 && this._enumCnt + this._naCnt == this._len) {
            return 2;
        }
        if (this._uuidCnt > 0) {
            return 5;
        }
        int nums = this._len - this._naCnt - this._timCnt;
        return this._timCnt >= nums ? (byte)4 : 3;
    }

    protected final boolean isNA2(int idx) {
        if (this.isUUID()) {
            return this._ls[idx] == Long.MAX_VALUE && Double.doubleToRawLongBits(this._ds[idx]) == 0L;
        }
        if (this.isString()) {
            return this._is[idx] == -1;
        }
        return this._ds == null ? this._ls[idx] == Long.MAX_VALUE && this._xs[idx] == Integer.MIN_VALUE : Double.isNaN(this._ds[idx]);
    }

    protected final boolean isEnum2(int idx) {
        return this._xs != null && this._xs[idx] == -2147483647;
    }

    protected final boolean isEnum(int idx) {
        if (this._id == null) {
            return this.isEnum2(idx);
        }
        int j = Arrays.binarySearch(this._id, 0, this.sparseLen(), idx);
        return j >= 0 && this.isEnum2(j);
    }

    public void addEnum(int e) {
        this.append2(e, -2147483647);
    }

    public void addNA() {
        if (this.isUUID()) {
            this.addUUID(Long.MAX_VALUE, 0L);
        } else if (this.isString()) {
            this.addStr(null);
        } else if (this._ds != null) {
            this.addNum(Double.NaN);
        } else {
            this.append2(Long.MAX_VALUE, Integer.MIN_VALUE);
        }
    }

    public void addNum(long val, int exp) {
        if (this.isUUID() || this.isString()) {
            this.addNA();
        } else if (this._ds != null) {
            assert (this._ls == null);
            this.addNum((double)val * PrettyPrint.pow10(exp));
        } else {
            long t;
            if (val == 0L) {
                exp = 0;
            }
            while (exp < 0 && exp > -9999999 && (t = val / 10L) * 10L == val) {
                val = t;
                ++exp;
            }
            this.append2(val, exp);
        }
    }

    public void addNum(double d) {
        if (this.isUUID() || this.isString()) {
            this.addNA();
            return;
        }
        if (this._id == null || d != 0.0) {
            if (this._ls != null) {
                this.switch_to_doubles();
            }
            if (this._ds == null || this.sparseLen() >= this._ds.length) {
                this.append2slowd();
                this.addNum(d);
                assert (this.sparseLen() <= this._len);
                return;
            }
            if (this._id != null) {
                this._id[this.sparseLen()] = this._len;
            }
            this._ds[this.sparseLen()] = d;
            this.set_sparseLen(this.sparseLen() + 1);
        }
        this.set_len(this._len + 1);
        assert (this.sparseLen() <= this._len);
    }

    private void append_ss(String str) {
        if (this._ss == null) {
            this._ss = MemoryManager.malloc1((str.length() + 1) * 4);
        }
        while (this._ss.length < this._sslen + str.length() + 1) {
            this._ss = MemoryManager.arrayCopyOf(this._ss, this._ss.length << 1);
        }
        for (byte b : str.getBytes()) {
            this._ss[this._sslen++] = b;
        }
        this._ss[this._sslen++] = 0;
    }

    private void append_ss(ValueString str) {
        int strlen = str.length();
        int off = str.getOffset();
        byte[] b = str.getBuffer();
        if (this._ss == null) {
            this._ss = MemoryManager.malloc1((strlen + 1) * 4);
        }
        while (this._ss.length < this._sslen + strlen + 1) {
            this._ss = MemoryManager.arrayCopyOf(this._ss, this._ss.length << 1);
        }
        for (int i = off; i < off + strlen; ++i) {
            this._ss[this._sslen++] = b[i];
        }
        this._ss[this._sslen++] = 0;
    }

    public void addStr(ValueString str) {
        if (this._id == null || str != null) {
            if (this._is == null || this.sparseLen() >= this._is.length) {
                this.append2slowstr();
                this.addStr(str);
                assert (this.sparseLen() <= this._len);
                return;
            }
            if (str != null) {
                if (this._id != null) {
                    this._id[this.sparseLen()] = this._len;
                }
                this._is[this.sparseLen()] = this._sslen;
                this.set_sparseLen(this.sparseLen() + 1);
                this.append_ss(str);
            } else if (this._id == null) {
                this._is[this.sparseLen()] = -1;
                this.set_sparseLen(this.sparseLen() + 1);
            }
        }
        this.set_len(this._len + 1);
        assert (this.sparseLen() <= this._len);
    }

    public void addStr(Chunk c, long row) {
        if (c.isNA_abs(row)) {
            this.addNA();
        } else {
            this.addStr(c.atStr_abs(new ValueString(), row));
        }
    }

    public void addStr(Chunk c, int row) {
        if (c.isNA(row)) {
            this.addNA();
        } else {
            this.addStr(c.atStr(new ValueString(), row));
        }
    }

    public void addUUID(long lo, long hi) {
        if (this._ls == null || this._ds == null || this.sparseLen() >= this._ls.length) {
            this.append2slowUUID();
        }
        this._ls[this.sparseLen()] = lo;
        this._ds[this.sparseLen()] = Double.longBitsToDouble(hi);
        this.set_sparseLen(this.sparseLen() + 1);
        this.set_len(this._len + 1);
        assert (this.sparseLen() <= this._len);
    }

    public void addUUID(Chunk c, long row) {
        if (c.isNA_abs(row)) {
            this.addUUID(Long.MAX_VALUE, 0L);
        } else {
            this.addUUID(c.at16l_abs(row), c.at16h_abs(row));
        }
    }

    public void addUUID(Chunk c, int row) {
        if (c.isNA(row)) {
            this.addUUID(Long.MAX_VALUE, 0L);
        } else {
            this.addUUID(c.at16l(row), c.at16h(row));
        }
    }

    public final boolean isUUID() {
        return this._ls != null && this._ds != null;
    }

    public final boolean isString() {
        return this._is != null;
    }

    public final boolean sparse() {
        return this._id != null;
    }

    public void addZeros(int n) {
        if (!this.sparse()) {
            for (int i = 0; i < n; ++i) {
                this.addNum(0L, 0);
            }
        } else {
            this.set_len(this._len + n);
        }
    }

    public void add(NewChunk nc) {
        assert (this._cidx >= 0);
        assert (this.sparseLen() <= this._len);
        assert (nc.sparseLen() <= nc._len) : "_len = " + nc.sparseLen() + ", _len2 = " + nc._len;
        if (nc._len == 0) {
            return;
        }
        if (this._len == 0) {
            this._ls = nc._ls;
            nc._ls = null;
            this._xs = nc._xs;
            nc._xs = null;
            this._id = nc._id;
            nc._id = null;
            this._ds = nc._ds;
            nc._ds = null;
            this._is = nc._is;
            nc._is = null;
            this._ss = nc._ss;
            nc._ss = null;
            this.set_sparseLen(nc.sparseLen());
            this.set_len(nc._len);
            return;
        }
        if (nc.sparse() != this.sparse()) {
            this.cancel_sparse();
            nc.cancel_sparse();
        }
        if (this._ds != null) {
            throw H2O.fail();
        }
        while (this.sparseLen() + nc.sparseLen() >= this._xs.length) {
            this._xs = MemoryManager.arrayCopyOf(this._xs, this._xs.length << 1);
        }
        this._ls = MemoryManager.arrayCopyOf(this._ls, this._xs.length);
        System.arraycopy(nc._ls, 0, this._ls, this.sparseLen(), nc.sparseLen());
        System.arraycopy(nc._xs, 0, this._xs, this.sparseLen(), nc.sparseLen());
        if (this._id != null) {
            assert (nc._id != null);
            this._id = MemoryManager.arrayCopyOf(this._id, this._xs.length);
            System.arraycopy(nc._id, 0, this._id, this.sparseLen(), nc.sparseLen());
            int i = this.sparseLen();
            while (i < this.sparseLen() + nc.sparseLen()) {
                int n = i++;
                this._id[n] = this._id[n] + this._len;
            }
        } else assert (nc._id == null);
        this.set_sparseLen(this.sparseLen() + nc.sparseLen());
        this.set_len(this._len + nc._len);
        nc._ls = null;
        nc._xs = null;
        nc._id = null;
        nc.set_sparseLen(nc.set_len(0));
        assert (this.sparseLen() <= this._len);
    }

    public void addr(NewChunk nc) {
        long[] tmpl = this._ls;
        this._ls = nc._ls;
        nc._ls = tmpl;
        int[] tmpi = this._xs;
        this._xs = nc._xs;
        nc._xs = tmpi;
        tmpi = this._id;
        this._id = nc._id;
        nc._id = tmpi;
        double[] tmpd = this._ds;
        this._ds = nc._ds;
        nc._ds = tmpd;
        int tmp = this._sparseLen;
        this._sparseLen = nc._sparseLen;
        nc._sparseLen = tmp;
        tmp = this._len;
        this._len = nc._len;
        nc._len = tmp;
        this.add(nc);
    }

    void append2(long l, int x) {
        if (this._id == null || l != 0L) {
            if (this._ls == null || this.sparseLen() == this._ls.length) {
                this.append2slow();
                this.append2(l, x);
                return;
            }
            this._ls[this.sparseLen()] = l;
            this._xs[this.sparseLen()] = x;
            if (this._id != null) {
                this._id[this.sparseLen()] = this._len;
            }
            this.set_sparseLen(this.sparseLen() + 1);
        }
        this.set_len(this._len + 1);
        assert (this.sparseLen() <= this._len);
    }

    private void append2slowd() {
        if (this.sparseLen() > 0x400000) {
            throw new ArrayIndexOutOfBoundsException(this.sparseLen());
        }
        assert (this._ls == null);
        if (this._ds != null && this._ds.length > 0) {
            if (this._id == null) {
                int nzs = 0;
                for (double d : this._ds) {
                    if (d == 0.0) continue;
                    ++nzs;
                }
                if ((nzs + 1) * this._sparseRatio < this._len) {
                    this.set_sparse(nzs);
                }
            } else {
                this._id = MemoryManager.arrayCopyOf(this._id, this.sparseLen() << 1);
            }
            this._ds = MemoryManager.arrayCopyOf(this._ds, this.sparseLen() << 1);
        } else {
            this.alloc_doubles(4);
            if (this.sparse()) {
                this.alloc_indices(4);
            }
        }
        assert (this.sparseLen() == 0 || this._ds.length > this.sparseLen()) : "_ds.length = " + this._ds.length + ", _len = " + this.sparseLen();
    }

    private void append2slowUUID() {
        if (this.sparseLen() > 0x400000) {
            throw new ArrayIndexOutOfBoundsException(this.sparseLen());
        }
        if (this._ds == null && this._ls != null) {
            this._xs = null;
            this.alloc_doubles(this.sparseLen());
            Arrays.fill(this._ls, Long.MAX_VALUE);
            Arrays.fill(this._ds, Double.longBitsToDouble(0L));
        }
        if (this._ls != null && this._ls.length > 0) {
            this._ls = MemoryManager.arrayCopyOf(this._ls, this.sparseLen() << 1);
            this._ds = MemoryManager.arrayCopyOf(this._ds, this.sparseLen() << 1);
        } else {
            this.alloc_mantissa(4);
            this.alloc_doubles(4);
        }
        assert (this.sparseLen() == 0 || this._ls.length > this.sparseLen()) : "_ls.length = " + this._ls.length + ", _len = " + this.sparseLen();
    }

    private void append2slowstr() {
        if (this.sparseLen() > 0x400000) {
            throw new ArrayIndexOutOfBoundsException(this.sparseLen());
        }
        if (this._xs != null) {
            this._xs = null;
            this._ls = null;
            this.alloc_str_indices(this.sparseLen());
            Arrays.fill(this._is, -1);
        }
        if (this._is != null && this._is.length > 0) {
            if (this._id == null) {
                int nzs = 0;
                for (int i : this._is) {
                    if (i == -1) continue;
                    ++nzs;
                }
                if ((nzs + 1) * this._sparseRatio < this._len) {
                    this.set_sparse(nzs);
                }
            } else if (this._sparseRatio * this._sparseLen >> 1 > this._len) {
                this.cancel_sparse();
            } else {
                this._id = MemoryManager.arrayCopyOf(this._id, this._sparseLen << 1);
            }
            this._is = MemoryManager.arrayCopyOf(this._is, this.sparseLen() << 1);
            for (int i = this.sparseLen(); i < this._is.length; ++i) {
                this._is[i] = -1;
            }
        } else {
            this._is = MemoryManager.malloc4(4);
            for (int i = 0; i < this._is.length; ++i) {
                this._is[i] = -1;
            }
            if (this.sparse()) {
                this.alloc_indices(4);
            }
        }
        assert (this.sparseLen() == 0 || this._is.length > this.sparseLen()) : "_ls.length = " + this._is.length + ", _len = " + this.sparseLen();
    }

    private void append2slow() {
        if (this.sparseLen() > 0x400000) {
            throw new ArrayIndexOutOfBoundsException(this.sparseLen());
        }
        assert (this._ds == null);
        if (this._ls != null && this._ls.length > 0) {
            if (this._id == null) {
                int nzs = 0;
                for (int i = 0; i < this._ls.length; ++i) {
                    if (this._ls[i] == 0L && this._xs[i] == 0) continue;
                    ++nzs;
                }
                if ((nzs + 1) * this._sparseRatio < this._len) {
                    this.set_sparse(nzs);
                    assert (this.sparseLen() == 0 || this.sparseLen() <= this._ls.length) : "_len = " + this.sparseLen() + ", _ls.length = " + this._ls.length + ", nzs = " + nzs + ", len2 = " + this._len;
                    assert (this._id.length == this._ls.length);
                    assert (this.sparseLen() <= this._len);
                    return;
                }
            } else if (this._sparseRatio * this.sparseLen() >> 1 > this._len) {
                this.cancel_sparse();
            } else {
                this._id = MemoryManager.arrayCopyOf(this._id, this.sparseLen() << 1);
            }
            this._ls = MemoryManager.arrayCopyOf(this._ls, this.sparseLen() << 1);
            this._xs = MemoryManager.arrayCopyOf(this._xs, this.sparseLen() << 1);
        } else {
            this.alloc_mantissa(4);
            this.alloc_exponent(4);
            if (this._id != null) {
                this.alloc_indices(4);
            }
        }
        assert (this.sparseLen() == 0 || this.sparseLen() < this._ls.length) : "_len = " + this.sparseLen() + ", _ls.length = " + this._ls.length;
        assert (this._id == null || this._id.length == this._ls.length);
        assert (this.sparseLen() <= this._len);
    }

    public Chunk new_close() {
        Chunk chk = this.compress();
        if (this._vec instanceof AppendableVec) {
            ((AppendableVec)this._vec).closeChunk(this);
        }
        return chk;
    }

    public void close(Futures fs) {
        this.close(this._cidx, fs);
    }

    protected void switch_to_doubles() {
        assert (this._ds == null);
        double[] ds = MemoryManager.malloc8d(this.sparseLen());
        for (int i = 0; i < this.sparseLen(); ++i) {
            ds[i] = this.isNA2(i) || this.isEnum2(i) ? Double.NaN : (double)this._ls[i] * PrettyPrint.pow10(this._xs[i]);
        }
        this._ls = null;
        this._xs = null;
        this._ds = ds;
    }

    protected void set_sparse(int nzeros) {
        if (this.sparseLen() == nzeros && this._len != 0) {
            return;
        }
        if (this._id != null) {
            int[] id = MemoryManager.malloc4(nzeros);
            int j = 0;
            if (this._ds != null) {
                double[] ds = MemoryManager.malloc8d(nzeros);
                for (int i = 0; i < this.sparseLen(); ++i) {
                    if (this._ds[i] == 0.0) continue;
                    ds[j] = this._ds[i];
                    id[j] = this._id[i];
                    ++j;
                }
                this._ds = ds;
            } else if (this._is != null) {
                int[] is = MemoryManager.malloc4(nzeros);
                for (int i = 0; i < this.sparseLen(); ++i) {
                    if (this._is[i] == -1) continue;
                    is[j] = this._is[i];
                    id[j] = id[i];
                    ++j;
                }
            } else {
                long[] ls = MemoryManager.malloc8(nzeros);
                int[] xs = MemoryManager.malloc4(nzeros);
                for (int i = 0; i < this.sparseLen(); ++i) {
                    if (this._ls[i] == 0L) continue;
                    ls[j] = this._ls[i];
                    xs[j] = this._xs[i];
                    id[j] = this._id[i];
                    ++j;
                }
                this._ls = ls;
                this._xs = xs;
            }
            this._id = id;
            assert (j == nzeros);
            this.set_sparseLen(nzeros);
            return;
        }
        assert (this.sparseLen() == this._len) : "_len = " + this.sparseLen() + ", _len2 = " + this._len + ", nzeros = " + nzeros;
        int zs = 0;
        if (this._is != null) {
            assert (nzeros < this._is.length);
            this._id = MemoryManager.malloc4(this._is.length);
            for (int i = 0; i < this.sparseLen(); ++i) {
                if (this._is[i] == -1) {
                    ++zs;
                    continue;
                }
                this._is[i - zs] = this._is[i];
                this._id[i - zs] = i;
            }
        } else if (this._ds == null) {
            if (this._len == 0) {
                this._ls = new long[0];
                this._xs = new int[0];
                this._id = new int[0];
                this.set_sparseLen(0);
                return;
            }
            assert (nzeros < this.sparseLen());
            this._id = this.alloc_indices(this._ls.length);
            for (int i = 0; i < this.sparseLen(); ++i) {
                if (this._ls[i] == 0L && this._xs[i] == 0) {
                    ++zs;
                    continue;
                }
                this._ls[i - zs] = this._ls[i];
                this._xs[i - zs] = this._xs[i];
                this._id[i - zs] = i;
            }
        } else {
            assert (nzeros < this._ds.length);
            this._id = this.alloc_indices(this._ds.length);
            for (int i = 0; i < this.sparseLen(); ++i) {
                if (this._ds[i] == 0.0) {
                    ++zs;
                    continue;
                }
                this._ds[i - zs] = this._ds[i];
                this._id[i - zs] = i;
            }
        }
        assert (zs == this.sparseLen() - nzeros);
        this.set_sparseLen(nzeros);
    }

    protected void cancel_sparse() {
        if (this.sparseLen() != this._len) {
            if (this._is != null) {
                int i;
                int[] is = MemoryManager.malloc4(this._len);
                for (i = 0; i < this._len; ++i) {
                    is[i] = -1;
                }
                for (i = 0; i < this.sparseLen(); ++i) {
                    is[this._id[i]] = this._is[i];
                }
                this._is = is;
            } else if (this._ds == null) {
                int[] xs = MemoryManager.malloc4(this._len);
                long[] ls = MemoryManager.malloc8(this._len);
                for (int i = 0; i < this.sparseLen(); ++i) {
                    xs[this._id[i]] = this._xs[i];
                    ls[this._id[i]] = this._ls[i];
                }
                this._xs = xs;
                this._ls = ls;
            } else {
                double[] ds = MemoryManager.malloc8d(this._len);
                for (int i = 0; i < this.sparseLen(); ++i) {
                    ds[this._id[i]] = this._ds[i];
                }
                this._ds = ds;
            }
            this.set_sparseLen(this._len);
        }
        this._id = null;
    }

    public Chunk compress() {
        Chunk res = this.compress2();
        this._id = null;
        this._xs = null;
        this._ds = null;
        this._ls = null;
        this._is = null;
        this._ss = null;
        return res;
    }

    private static long leRange(long lemin, long lemax) {
        if (lemin < 0L && lemax >= Long.MAX_VALUE + lemin) {
            return Long.MAX_VALUE;
        }
        long res = lemax - lemin;
        assert (res >= 0L);
        return res;
    }

    private Chunk compress2() {
        boolean fpoint;
        int i;
        byte mode = this.type();
        if (mode == 1) {
            return new C0DChunk(Double.NaN, this.sparseLen());
        }
        if (mode == 6) {
            return new CStrChunk(this._sslen, this._ss, this.sparseLen(), this._len, this._is);
        }
        boolean rerun = false;
        if (mode == 2) {
            for (i = 0; i < this.sparseLen(); ++i) {
                if (this.isEnum2(i)) {
                    this._xs[i] = 0;
                    continue;
                }
                if (this.isNA2(i)) continue;
                this.setNA_impl2(i);
                ++this._naCnt;
            }
        } else if (mode == 3) {
            for (i = 0; i < this.sparseLen(); ++i) {
                if (!this.isEnum2(i)) continue;
                this.setNA_impl2(i);
                rerun = true;
            }
        }
        if (rerun) {
            this._naCnt = -1;
            this.type();
        }
        boolean sparse = false;
        if (this._sparseRatio * (this._naCnt + this._nzCnt) < this._len) {
            this.set_sparse(this._naCnt + this._nzCnt);
            sparse = true;
        } else if (this.sparseLen() != this._len) {
            this.cancel_sparse();
        }
        if (this._ds != null && this._ls != null) {
            return this.chunkUUID();
        }
        if (this._naCnt == this._len) {
            return new C0DChunk(Double.NaN, this._len);
        }
        if (this._ds != null) {
            int i2;
            for (i2 = 0; i2 < this.sparseLen() && (Double.isNaN(this._ds[i2]) || (double)((long)this._ds[i2]) == this._ds[i2]); ++i2) {
            }
            boolean isInteger = i2 == this.sparseLen();
            boolean isConstant = !sparse || this.sparseLen() == 0;
            double constVal = 0.0;
            if (!sparse) {
                constVal = this._ds[0];
                for (int j = 1; j < this._len; ++j) {
                    if (this._ds[j] == constVal) continue;
                    isConstant = false;
                    break;
                }
            }
            if (isConstant) {
                return isInteger ? new C0LChunk((long)constVal, this._len) : new C0DChunk(constVal, this._len);
            }
            if (!isInteger) {
                return sparse ? new CXDChunk(this._len, this.sparseLen(), 8, this.bufD(8)) : this.chunkD();
            }
            this._ls = new long[this._ds.length];
            this._xs = new int[this._ds.length];
            double[] ds = this._ds;
            this._ds = null;
            int naCnt = this._naCnt;
            for (i2 = 0; i2 < this.sparseLen(); ++i2) {
                if (Double.isNaN(ds[i2])) {
                    this.setNA_impl2(i2);
                    continue;
                }
                this._ls[i2] = (long)ds[i2];
            }
            this._naCnt = naCnt;
        }
        int xmin = Integer.MAX_VALUE;
        boolean floatOverflow = false;
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        int p10iLength = PrettyPrint.powers10i.length;
        long llo = Long.MAX_VALUE;
        long lhi = Long.MIN_VALUE;
        int xlo = Integer.MAX_VALUE;
        int xhi = Integer.MIN_VALUE;
        for (int i3 = 0; i3 < this.sparseLen(); ++i3) {
            long t;
            if (this.isNA2(i3)) continue;
            long l = this._ls[i3];
            int x = this._xs[i3];
            assert (x != Integer.MIN_VALUE) : "l = " + l + ", x = " + x;
            if (x == -2147483647) {
                x = 0;
            }
            assert (l != 0L || x == 0) : "l == 0 while x = " + x + " ls = " + Arrays.toString(this._ls);
            while (l != 0L && (t = l / 10L) * 10L == l) {
                l = t;
                ++x;
            }
            double d = (double)l * PrettyPrint.pow10(x);
            if (d < min) {
                min = d;
                llo = l;
                xlo = x;
            }
            if (d > max) {
                max = d;
                lhi = l;
                xhi = x;
            }
            floatOverflow = l < -2147483647L || l > Integer.MAX_VALUE;
            xmin = Math.min(xmin, x);
        }
        if (sparse) {
            if (min > 0.0) {
                min = 0.0;
                llo = 0L;
                xlo = 0;
            }
            if (max < 0.0) {
                max = 0.0;
                lhi = 0L;
                xhi = 0;
            }
            xmin = Math.min(xmin, 0);
        }
        if (this._naCnt == 0 && min == max) {
            if (llo == lhi && xlo == 0 && xhi == 0) {
                return new C0LChunk(llo, this._len);
            }
            if ((double)((long)min) == min) {
                return new C0LChunk((long)min, this._len);
            }
            return new C0DChunk(min, this._len);
        }
        boolean overflow = xhi - xmin >= p10iLength || xlo - xmin >= p10iLength;
        long lemax = 0L;
        long lemin = 0L;
        if (!overflow) {
            long pow10lo;
            long pow10 = PrettyPrint.pow10i(xhi - xmin);
            lemax = lhi * pow10;
            if (lemax / pow10 != lhi) {
                overflow = true;
            }
            if ((lemin = llo * (pow10lo = PrettyPrint.pow10i(xlo - xmin))) / pow10lo != llo) {
                overflow = true;
            }
        }
        if (max == 1.0 && min == 0.0 && xmin == 0 && !overflow) {
            if (sparse) {
                return this._naCnt == 0 ? new CX0Chunk(this._len, this.sparseLen(), this.bufS(0)) : new CXIChunk(this._len, this.sparseLen(), 1, this.bufS(1));
            }
            int bpv = this._enumCnt + this._naCnt > 0 ? 2 : 1;
            byte[] cbuf = this.bufB(bpv);
            return new CBSChunk(cbuf, cbuf[0], cbuf[1]);
        }
        boolean bl = fpoint = xmin < 0 || min < -9.223372036854776E18 || max > 9.223372036854776E18;
        if (sparse) {
            if (fpoint) {
                return new CXDChunk(this._len, this.sparseLen(), 8, this.bufD(8));
            }
            int sz = 8;
            if (-32768.0 <= min && max <= 32767.0) {
                sz = 2;
            } else if (-2.147483648E9 <= min && max <= 2.147483647E9) {
                sz = 4;
            }
            return new CXIChunk(this._len, this.sparseLen(), sz, this.bufS(sz));
        }
        if (overflow || fpoint && floatOverflow || -35 > xmin || xmin > 35) {
            return this.chunkD();
        }
        long leRange = NewChunk.leRange(lemin, lemax);
        if (fpoint) {
            if ((long)((int)lemin) == lemin && (long)((int)lemax) == lemax) {
                if (leRange < 255L) {
                    return new C1SChunk(this.bufX(lemin, xmin, 16, 0), lemin, PrettyPrint.pow10(xmin));
                }
                if (leRange < 65535L) {
                    long bias = 32767L + lemin;
                    return new C2SChunk(this.bufX(bias, xmin, 16, 1), bias, PrettyPrint.pow10(xmin));
                }
            }
            if (leRange < 0xFFFFFFFFL) {
                long bias = Integer.MAX_VALUE + lemin;
                return new C4SChunk(this.bufX(bias, xmin, 16, 2), bias, PrettyPrint.pow10(xmin));
            }
            return this.chunkD();
        }
        if (xmin == 0 && 0L <= lemin && lemax <= 255L && this._naCnt + this._enumCnt == 0) {
            return new C1NChunk(this.bufX(0L, 0, 0, 0));
        }
        if (lemin < Integer.MIN_VALUE) {
            return new C8Chunk(this.bufX(0L, 0, 0, 3));
        }
        if (leRange < 255L) {
            if (0.0 <= min && max < 255.0) {
                return new C1Chunk(this.bufX(0L, 0, 0, 0));
            }
            return new C1SChunk(this.bufX(lemin, xmin, 16, 0), lemin, PrettyPrint.pow10i(xmin));
        }
        if (leRange < 65535L) {
            if (xmin == 0 && -32768L < lemin && lemax <= 32767L) {
                return new C2Chunk(this.bufX(0L, 0, 0, 1));
            }
            long bias = lemin - -32767L;
            return new C2SChunk(this.bufX(bias, xmin, 16, 1), bias, PrettyPrint.pow10i(xmin));
        }
        if (-2.147483648E9 < min && max <= 2.147483647E9) {
            return new C4Chunk(this.bufX(0L, 0, 0, 2));
        }
        return new C8Chunk(this.bufX(0L, 0, 0, 3));
    }

    private byte[] bufS(int valsz) {
        int log = 0;
        while (1 << log < valsz) {
            ++log;
        }
        assert (valsz == 0 || 1 << log == valsz);
        int ridsz = this._len >= 65535 ? 4 : 2;
        int elmsz = ridsz + valsz;
        int off = 6;
        byte[] buf = MemoryManager.malloc1(off + this.sparseLen() * elmsz, true);
        int i = 0;
        while (i < this.sparseLen()) {
            if (ridsz == 2) {
                UnsafeUtils.set2(buf, off, (short)this._id[i]);
            } else {
                UnsafeUtils.set4(buf, off, this._id[i]);
            }
            if (valsz == 0) {
                assert (this._xs[i] == 0 && this._ls[i] == 1L);
            } else {
                assert (this._xs[i] == Integer.MIN_VALUE || this._xs[i] >= 0) : "unexpected exponent " + this._xs[i];
                long lval = this._xs[i] == Integer.MIN_VALUE ? NAS[log] : this._ls[i] * PrettyPrint.pow10i(this._xs[i]);
                switch (valsz) {
                    case 1: {
                        buf[off + ridsz] = (byte)lval;
                        break;
                    }
                    case 2: {
                        short sval = (short)lval;
                        UnsafeUtils.set2(buf, off + ridsz, sval);
                        break;
                    }
                    case 4: {
                        int ival = (int)lval;
                        UnsafeUtils.set4(buf, off + ridsz, ival);
                        break;
                    }
                    case 8: {
                        UnsafeUtils.set8(buf, off + ridsz, lval);
                        break;
                    }
                    default: {
                        throw H2O.fail();
                    }
                }
            }
            ++i;
            off += elmsz;
        }
        assert (off == buf.length);
        return buf;
    }

    private byte[] bufD(int valsz) {
        int log = 0;
        while (1 << log < valsz) {
            ++log;
        }
        assert (1 << log == valsz);
        int ridsz = this._len >= 65535 ? 4 : 2;
        int elmsz = ridsz + valsz;
        int off = 6;
        byte[] buf = MemoryManager.malloc1(off + this.sparseLen() * elmsz, true);
        int i = 0;
        while (i < this.sparseLen()) {
            if (ridsz == 2) {
                UnsafeUtils.set2(buf, off, (short)this._id[i]);
            } else {
                UnsafeUtils.set4(buf, off, this._id[i]);
            }
            double dval = this._ds == null ? (this.isNA2(i) ? Double.NaN : (double)this._ls[i] * PrettyPrint.pow10(this._xs[i])) : this._ds[i];
            switch (valsz) {
                case 4: {
                    UnsafeUtils.set4f(buf, off + ridsz, (float)dval);
                    break;
                }
                case 8: {
                    UnsafeUtils.set8d(buf, off + ridsz, dval);
                    break;
                }
                default: {
                    throw H2O.fail();
                }
            }
            ++i;
            off += elmsz;
        }
        assert (off == buf.length);
        return buf;
    }

    private byte[] bufX(long bias, int scale, int off, int log) {
        byte[] bs = new byte[(this._len << log) + off];
        int j = 0;
        block6: for (int i = 0; i < this._len; ++i) {
            long le = -bias;
            if (this._id == null || this._id.length == 0 || j < this._id.length && this._id[j] == i) {
                if (this.isNA2(j)) {
                    le = NAS[log];
                } else {
                    int x = (this._xs[j] == -2147483647 ? 0 : this._xs[j]) - scale;
                    le += x >= 0 ? this._ls[j] * PrettyPrint.pow10i(x) : this._ls[j] / PrettyPrint.pow10i(-x);
                }
                ++j;
            }
            switch (log) {
                case 0: {
                    bs[i + off] = (byte)le;
                    continue block6;
                }
                case 1: {
                    UnsafeUtils.set2(bs, (i << 1) + off, (short)le);
                    continue block6;
                }
                case 2: {
                    UnsafeUtils.set4(bs, (i << 2) + off, (int)le);
                    continue block6;
                }
                case 3: {
                    UnsafeUtils.set8(bs, (i << 3) + off, le);
                    continue block6;
                }
                default: {
                    throw H2O.fail();
                }
            }
        }
        assert (j == this.sparseLen()) : "j = " + j + ", len = " + this.sparseLen() + ", len2 = " + this._len + ", id[j] = " + this._id[j];
        return bs;
    }

    private Chunk chunkD() {
        HashMap<Long, Byte> hs = new HashMap<Long, Byte>(CUDChunk.MAX_UNIQUES);
        Byte dummy = 0;
        byte[] bs = MemoryManager.malloc1(this._len * 8, true);
        int j = 0;
        boolean fitsInUnique = true;
        for (int i = 0; i < this._len; ++i) {
            double d = 0.0;
            if (this._id == null || this._id.length == 0 || j < this._id.length && this._id[j] == i) {
                d = this._ds != null ? this._ds[j] : (this.isNA2(j) || this.isEnum(j) ? Double.NaN : (double)this._ls[j] * PrettyPrint.pow10(this._xs[j]));
                ++j;
            }
            if (fitsInUnique) {
                if (hs.size() < CUDChunk.MAX_UNIQUES) {
                    hs.put(new Long(Double.doubleToLongBits(d)), dummy);
                } else {
                    fitsInUnique = hs.size() == CUDChunk.MAX_UNIQUES ? hs.containsKey(Double.doubleToLongBits(d)) : false;
                }
            }
            UnsafeUtils.set8d(bs, 8 * i, d);
        }
        assert (j == this.sparseLen()) : "j = " + j + ", _len = " + this.sparseLen();
        if (fitsInUnique && (double)CUDChunk.computeByteSize(hs.size(), this.len()) < 0.8 * (double)bs.length) {
            return new CUDChunk(bs, hs, this.len());
        }
        return new C8DChunk(bs);
    }

    private Chunk chunkUUID() {
        byte[] bs = MemoryManager.malloc1(this._len * 16, true);
        int j = 0;
        for (int i = 0; i < this._len; ++i) {
            long lo = 0L;
            long hi = 0L;
            if (this._id == null || this._id.length == 0 || j < this._id.length && this._id[j] == i) {
                lo = this._ls[j];
                hi = Double.doubleToRawLongBits(this._ds[j++]);
                if (this._xs != null && this._xs[j] == Integer.MAX_VALUE) {
                    lo = Long.MIN_VALUE;
                    hi = 0L;
                }
            }
            UnsafeUtils.set8(bs, 16 * i, lo);
            UnsafeUtils.set8(bs, 16 * i + 8, hi);
        }
        assert (j == this.sparseLen()) : "j = " + j + ", _len = " + this.sparseLen();
        return new C16Chunk(bs);
    }

    private byte[] bufB(int bpv) {
        assert (bpv == 1 || bpv == 2) : "Only bit vectors with/without NA are supported";
        int off = 2;
        int clen = 2 + CBSChunk.clen(this._len, bpv);
        byte[] bs = new byte[clen];
        bs[0] = (byte)((this._len * bpv & 7) == 0 ? 0 : 8 - (this._len * bpv & 7));
        bs[1] = (byte)bpv;
        int boff = 0;
        byte b = 0;
        int idx = 2;
        int j = 0;
        for (int i = 0; i < this._len; ++i) {
            byte val = 0;
            if (this._id == null || j < this._id.length && this._id[j] == i) {
                assert (bpv == 2 || !this.isNA2(j));
                val = (byte)(this.isNA2(j) ? 2L : this._ls[j]);
                ++j;
            }
            b = bpv == 1 ? CBSChunk.write1b(b, val, boff) : CBSChunk.write2b(b, val, boff);
            if ((boff += bpv) <= 8 - bpv) continue;
            assert (boff == 8);
            bs[idx] = b;
            boff = 0;
            b = 0;
            ++idx;
        }
        assert (j == this.sparseLen());
        assert (bs[0] == (byte)(boff == 0 ? 0 : 8 - boff)) : "b[0] = " + bs[0] + ", boff = " + boff + ", bpv = " + bpv;
        if (boff > 0) {
            bs[idx] = b;
        }
        return bs;
    }

    @Override
    boolean set_impl(int i, long l) {
        if (this._ds != null) {
            return this.set_impl(i, (double)l);
        }
        if (this.sparseLen() != this._len) {
            int idx = Arrays.binarySearch(this._id, 0, this.sparseLen(), i);
            if (idx >= 0) {
                i = idx;
            } else {
                this.cancel_sparse();
            }
        }
        this._ls[i] = l;
        this._xs[i] = 0;
        this._naCnt = -1;
        return true;
    }

    @Override
    public boolean set_impl(int i, double d) {
        if (this._ds == null) {
            assert (this.sparseLen() == 0 || this._ls != null);
            this.switch_to_doubles();
        }
        if (this.sparseLen() != this._len) {
            int idx = Arrays.binarySearch(this._id, 0, this.sparseLen(), i);
            if (idx >= 0) {
                i = idx;
            } else {
                this.cancel_sparse();
            }
        }
        assert (i < this.sparseLen());
        this._ds[i] = d;
        this._naCnt = -1;
        return true;
    }

    @Override
    boolean set_impl(int i, float f) {
        return this.set_impl(i, (double)f);
    }

    @Override
    boolean set_impl(int i, String str) {
        if (this._is == null && this._len > 0) {
            assert (this.sparseLen() == 0);
            this.alloc_str_indices(this._len);
            Arrays.fill(this._is, -1);
        }
        if (this.sparseLen() != this._len) {
            int idx = Arrays.binarySearch(this._id, 0, this.sparseLen(), i);
            if (idx >= 0) {
                i = idx;
            } else {
                this.cancel_sparse();
            }
        }
        this._is[i] = this._sslen;
        this.append_ss(str);
        return true;
    }

    protected final boolean setNA_impl2(int i) {
        if (this.isNA2(i)) {
            return true;
        }
        if (this._ls != null) {
            this._ls[i] = Long.MAX_VALUE;
            this._xs[i] = Integer.MIN_VALUE;
        }
        if (this._ds != null) {
            this._ds[i] = Double.NaN;
        }
        this._naCnt = -1;
        return true;
    }

    @Override
    boolean setNA_impl(int i) {
        if (this.isNA_impl(i)) {
            return true;
        }
        if (this.sparseLen() != this._len) {
            int idx = Arrays.binarySearch(this._id, 0, this.sparseLen(), i);
            if (idx >= 0) {
                i = idx;
            } else {
                this.cancel_sparse();
            }
        }
        return this.setNA_impl2(i);
    }

    @Override
    public long at8_impl(int i) {
        if (this._len != this.sparseLen()) {
            int idx = Arrays.binarySearch(this._id, 0, this.sparseLen(), i);
            if (idx >= 0) {
                i = idx;
            } else {
                return 0L;
            }
        }
        if (this.isNA2(i)) {
            throw new RuntimeException("Attempting to access NA as integer value.");
        }
        if (this._ls == null) {
            return (long)this._ds[i];
        }
        return this._ls[i] * PrettyPrint.pow10i(this._xs[i]);
    }

    @Override
    public double atd_impl(int i) {
        if (this._len != this.sparseLen()) {
            int idx = Arrays.binarySearch(this._id, 0, this.sparseLen(), i);
            if (idx >= 0) {
                i = idx;
            } else {
                return 0.0;
            }
        }
        if (this._ds == null) {
            return this.isNA2(i) || this._xs[i] >= 0 ? (double)this.at8_impl(i) : (double)this._ls[i] * Math.pow(10.0, this._xs[i]);
        }
        assert (this._xs == null);
        return this._ds[i];
    }

    @Override
    protected long at16l_impl(int idx) {
        if (this._ls[idx] == Long.MAX_VALUE) {
            throw new RuntimeException("Attempting to access NA as integer value.");
        }
        return this._ls[idx];
    }

    @Override
    protected long at16h_impl(int idx) {
        long hi = Double.doubleToRawLongBits(this._ds[idx]);
        if (hi == 0L) {
            throw new RuntimeException("Attempting to access NA as integer value.");
        }
        return hi;
    }

    @Override
    public boolean isNA_impl(int i) {
        if (this._len != this.sparseLen()) {
            int idx = Arrays.binarySearch(this._id, 0, this.sparseLen(), i);
            if (idx >= 0) {
                i = idx;
            } else {
                return false;
            }
        }
        return this.isNA2(i);
    }

    @Override
    public ValueString atStr_impl(ValueString vstr, int i) {
        if (this.sparseLen() != this._len) {
            int idx = Arrays.binarySearch(this._id, 0, this.sparseLen(), i);
            if (idx >= 0) {
                i = idx;
            } else {
                return null;
            }
        }
        if (this._is[i] == -1) {
            return null;
        }
        int len = 0;
        while (this._ss[this._is[i] + len] != 0) {
            ++len;
        }
        return vstr.set(this._ss, this._is[i], len);
    }

    @Override
    public NewChunk read_impl(AutoBuffer bb) {
        throw H2O.fail();
    }

    @Override
    public AutoBuffer write_impl(AutoBuffer bb) {
        throw H2O.fail();
    }

    @Override
    public NewChunk inflate_impl(NewChunk nc) {
        throw H2O.fail();
    }

    @Override
    public String toString() {
        return "NewChunk._len=" + this.sparseLen();
    }

    @Override
    public int cidx() {
        return this._cidx;
    }

    public final class Value {
        int _gId;
        int _lId;

        public Value(int lid, int gid) {
            this._lId = lid;
            this._gId = gid;
        }

        public final int rowId0() {
            return this._gId;
        }

        public void add2Chunk(NewChunk c) {
            if (NewChunk.this._ds == null && NewChunk.this._ss == null) {
                c.addNum(NewChunk.this._ls[this._lId], NewChunk.this._xs[this._lId]);
            } else if (NewChunk.this._ls != null) {
                c.addUUID(NewChunk.this._ls[this._lId], Double.doubleToRawLongBits(NewChunk.this._ds[this._lId]));
            } else if (NewChunk.this._ss != null) {
                int nextNotNAIdx;
                int sidx = NewChunk.this._is[this._lId];
                for (nextNotNAIdx = this._lId + 1; nextNotNAIdx < NewChunk.this._is.length && NewChunk.this._is[nextNotNAIdx] == -1; ++nextNotNAIdx) {
                }
                int slen = nextNotNAIdx < NewChunk.this._is.length ? NewChunk.this._is[nextNotNAIdx] - sidx : NewChunk.this._sslen - sidx;
                ValueString vstr = sidx == -1 ? null : new ValueString().set(NewChunk.this._ss, sidx, slen);
                c.addStr(vstr);
            } else {
                c.addNum(NewChunk.this._ds[this._lId]);
            }
        }
    }
}

