/*
 * Decompiled with CFR 0.152.
 */
package water.parser;

import java.util.concurrent.atomic.AtomicInteger;
import water.AutoBuffer;
import water.H2O;
import water.Iced;
import water.nbhm.NonBlockingHashMap;
import water.parser.ValueString;
import water.util.Log;
import water.util.PrettyPrint;

public final class Categorical
extends Iced {
    public static final int MAX_CATEGORICAL_COUNT = 10000000;
    AtomicInteger _id = new AtomicInteger();
    int _maxId = -1;
    volatile NonBlockingHashMap<ValueString, Integer> _map = new NonBlockingHashMap();
    boolean maxEnumExceeded = false;
    public static final int MAX_EXAMPLES = 10;

    Categorical() {
    }

    int addKey(ValueString str) {
        NonBlockingHashMap<ValueString, Integer> m = this._map;
        if (m == null) {
            return Integer.MAX_VALUE;
        }
        Integer res = m.get(str);
        if (res != null) {
            return res;
        }
        assert (str.length() < 65535);
        int newVal = this._id.incrementAndGet();
        res = m.putIfAbsent(new ValueString(str), newVal);
        if (res != null) {
            return res;
        }
        if (m.size() > 10000000) {
            this.maxEnumExceeded = true;
        }
        return newVal;
    }

    final boolean containsKey(ValueString key) {
        return this._map.containsKey(key);
    }

    public String toString() {
        return "{" + this._map + " }";
    }

    int getTokenId(ValueString str) {
        return this._map.get(str);
    }

    int maxId() {
        return this._maxId == -1 ? this._id.get() : this._maxId;
    }

    int size() {
        return this._map.size();
    }

    boolean isMapFull() {
        return this.maxEnumExceeded;
    }

    ValueString[] getColumnDomain() {
        return this._map.keySet().toArray(new ValueString[this._map.size()]);
    }

    public void convertToUTF8(int col) {
        int hexConvCnt = 0;
        ValueString[] vs = this._map.keySet().toArray(new ValueString[this._map.size()]);
        StringBuilder hexSB = new StringBuilder();
        for (int i = 0; i < vs.length; ++i) {
            String s = vs[i].toString();
            if (vs[i].equals(s)) continue;
            if (s.contains("\ufffd")) {
                s = vs[i].bytesToString();
                if (hexConvCnt++ < 10) {
                    hexSB.append(s + ", ");
                }
                if (hexConvCnt == 10) {
                    hexSB.append("...");
                }
            }
            int val = this._map.get(vs[i]);
            this._map.remove(vs[i]);
            vs[i] = new ValueString(s);
            this._map.put(vs[i], val);
        }
        if (hexConvCnt > 0) {
            Log.info("Found categoricals with non-UTF-8 characters in the " + PrettyPrint.withOrdinalIndicator(col) + " column. Converting unrecognized characters into hex:  " + hexSB.toString());
        }
    }

    @Override
    public AutoBuffer write_impl(AutoBuffer ab) {
        if (this._map == null) {
            return ab.put1(1);
        }
        ab.put1(0);
        ab.put4(this.maxId());
        for (ValueString key : this._map.keySet()) {
            ab.put2((char)key.length()).putA1(key.getBuffer(), key.length()).put4(this._map.get(key));
        }
        return ab.put2('\uffff');
    }

    @Override
    public Categorical read_impl(AutoBuffer ab) {
        char len;
        assert (this._map == null || this._map.size() == 0);
        this._map = null;
        if (ab.get1() == 1) {
            return this;
        }
        this._maxId = ab.get4();
        this._map = new NonBlockingHashMap();
        while ((len = ab.get2()) != '\uffff') {
            this._map.put(new ValueString(ab.getA1(len)), ab.get4());
        }
        return this;
    }

    @Override
    public AutoBuffer writeJSON_impl(AutoBuffer ab) {
        throw H2O.unimpl();
    }

    @Override
    public Categorical readJSON_impl(AutoBuffer ab) {
        throw H2O.unimpl();
    }
}

