/*
 * Decompiled with CFR 0.152.
 */
package water.parser;

import water.Futures;
import water.Iced;
import water.exceptions.H2OParseException;
import water.fvec.AppendableVec;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.parser.Categorical;
import water.parser.ParseTime;
import water.parser.ParseUUID;
import water.parser.StreamParseWriter;
import water.parser.ValueString;

public class FVecParseWriter
extends Iced
implements StreamParseWriter {
    protected transient NewChunk[] _nvs;
    protected AppendableVec[] _vecs;
    protected final Categorical[] _enums;
    protected transient byte[] _ctypes;
    long _nLines;
    int _nCols;
    int _col = -1;
    final int _cidx;
    final int _chunkSize;
    boolean _closedVecs = false;
    int _nChunks;
    private final Vec.VectorGroup _vg;

    public int nChunks() {
        return this._nChunks;
    }

    public FVecParseWriter(Vec.VectorGroup vg, int cidx, Categorical[] enums, byte[] ctypes, int chunkSize, AppendableVec[] avs) {
        this._ctypes = ctypes != null ? ctypes : new byte[avs.length];
        this._vecs = avs;
        this._nvs = new NewChunk[avs.length];
        for (int i = 0; i < avs.length; ++i) {
            this._nvs[i] = this._vecs[i].chunkForChunkIdx(cidx);
        }
        this._enums = enums;
        this._nCols = avs.length;
        this._cidx = cidx;
        this._vg = vg;
        this._chunkSize = chunkSize;
    }

    @Override
    public FVecParseWriter reduce(StreamParseWriter sdout) {
        FVecParseWriter dout = (FVecParseWriter)sdout;
        if (dout == null) {
            return this;
        }
        this._nCols = Math.max(this._nCols, dout._nCols);
        this._nChunks += dout._nChunks;
        if (dout != null && this._vecs != dout._vecs) {
            if (dout._vecs.length > this._vecs.length) {
                AppendableVec[] v = this._vecs;
                this._vecs = dout._vecs;
                for (int i = 1; i < this._vecs.length; ++i) {
                    this._vecs[i]._tmp_espc = this._vecs[0]._tmp_espc;
                }
                dout._vecs = v;
            }
            for (int i = 0; i < dout._vecs.length; ++i) {
                this._vecs[i].reduce(dout._vecs[i]);
            }
        }
        return this;
    }

    @Override
    public FVecParseWriter close() {
        Futures fs = new Futures();
        this.close(fs);
        fs.blockForPending();
        return this;
    }

    @Override
    public FVecParseWriter close(Futures fs) {
        ++this._nChunks;
        if (this._nvs == null) {
            return this;
        }
        for (NewChunk nv : this._nvs) {
            nv.close(this._cidx, fs);
        }
        this._nvs = null;
        return this;
    }

    @Override
    public FVecParseWriter nextChunk() {
        return new FVecParseWriter(this._vg, this._cidx + 1, this._enums, this._ctypes, this._chunkSize, this._vecs);
    }

    @Override
    public void newLine() {
        if (this._col >= 0) {
            ++this._nLines;
            for (int i = this._col + 1; i < this._nCols; ++i) {
                this.addInvalidCol(i);
            }
        }
        this._col = -1;
    }

    @Override
    public void addNumCol(int colIdx, long number, int exp) {
        if (colIdx < this._nCols) {
            this._col = colIdx;
            this._nvs[this._col].addNum(number, exp);
            if (this._ctypes[colIdx] == 0) {
                this._ctypes[colIdx] = 3;
            }
        }
    }

    @Override
    public final void addInvalidCol(int colIdx) {
        if (colIdx < this._nCols) {
            this._col = colIdx;
            this._nvs[this._col].addNA();
        }
    }

    @Override
    public boolean isString(int colIdx) {
        return colIdx < this._nCols && (this._ctypes[colIdx] == 4 || this._ctypes[colIdx] == 2);
    }

    @Override
    public void addStrCol(int colIdx, ValueString str) {
        if (colIdx < this._nvs.length) {
            if (this._ctypes[colIdx] == 3) {
                this.addInvalidCol(colIdx);
                return;
            }
            if (this._ctypes[colIdx] == 0 && ParseTime.isTime(str)) {
                this._ctypes[colIdx] = 5;
            }
            if (this._ctypes[colIdx] == 0 && ParseUUID.isUUID(str)) {
                this._ctypes[colIdx] = 1;
            }
            if (this._ctypes[colIdx] == 5) {
                long l = ParseTime.attemptTimeParse(str);
                if (l == Long.MIN_VALUE) {
                    this.addInvalidCol(colIdx);
                } else {
                    this.addNumCol(colIdx, l, 0);
                    ++this._nvs[this._col]._timCnt;
                }
            } else if (this._ctypes[colIdx] == 1) {
                long[] uuid = ParseUUID.attemptUUIDParse(str);
                if (colIdx < this._nCols) {
                    this._col = colIdx;
                    this._nvs[this._col].addUUID(uuid[0], uuid[1]);
                }
            } else if (this._ctypes[colIdx] == 2) {
                this._col = colIdx;
                this._nvs[this._col].addStr(str);
            } else if (!this._enums[colIdx].isMapFull()) {
                this._col = colIdx;
                int id = this._enums[this._col].addKey(str);
                if (this._ctypes[colIdx] == 0 && id > 1) {
                    this._ctypes[colIdx] = 4;
                }
                this._nvs[colIdx].addEnum(id);
            } else {
                throw new H2OParseException("Exceeded enumeration limit on column #" + (colIdx + 1) + " (using 1-based indexing).  Consider reparsing this column as a string.");
            }
        }
    }

    @Override
    public void addNumCol(int colIdx, double value) {
        if (Double.isNaN(value)) {
            this.addInvalidCol(colIdx);
        } else {
            double d = value;
            int exp = 0;
            long number = (long)d;
            while ((double)number != d) {
                --exp;
                number = (long)(d *= 10.0);
            }
            this.addNumCol(colIdx, number, exp);
        }
    }

    @Override
    public void setColumnNames(String[] names) {
    }

    @Override
    public final void rollbackLine() {
    }

    @Override
    public void invalidLine(String err) {
        this.newLine();
    }
}

