/*
 * Decompiled with CFR 0.152.
 */
package water.parser;

import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import water.DKV;
import water.Iced;
import water.Key;
import water.MRTask;
import water.api.ParseSetupV3;
import water.exceptions.H2OIllegalArgumentException;
import water.exceptions.H2OParseException;
import water.exceptions.H2OParseSetupException;
import water.fvec.ByteVec;
import water.fvec.FileVec;
import water.fvec.Frame;
import water.fvec.UploadFileVec;
import water.fvec.Vec;
import water.parser.ARFFParser;
import water.parser.CsvParser;
import water.parser.ParseTime;
import water.parser.ParseUUID;
import water.parser.Parser;
import water.parser.ParserType;
import water.parser.PreviewParseWriter;
import water.parser.SVMLightParser;
import water.parser.ValueString;
import water.parser.XlsParser;
import water.parser.ZipUtil;

public final class ParseSetup
extends Iced {
    public static final byte GUESS_SEP = -1;
    public static final int NO_HEADER = -1;
    public static final int GUESS_HEADER = 0;
    public static final int HAS_HEADER = 1;
    public static final int GUESS_COL_CNT = -1;
    ParserType _parse_type;
    byte _separator;
    boolean _single_quotes;
    int _check_header;
    int _number_columns;
    String[] _column_names;
    byte[] _column_types;
    String[][] _domains;
    String[][] _na_strings;
    String[][] _data;
    int _chunk_size = 0x400000;
    PreviewParseWriter _column_previews = null;
    private static final ParserType[] guessFileTypeOrder = new ParserType[]{ParserType.ARFF, ParserType.XLS, ParserType.XLSX, ParserType.SVMLight, ParserType.CSV};

    public ParseSetup(ParseSetup ps) {
        this(ps._parse_type, ps._separator, ps._single_quotes, ps._check_header, ps._number_columns, ps._column_names, ps._column_types, ps._domains, ps._na_strings, ps._data, ps._chunk_size);
    }

    public ParseSetup(ParserType t, byte sep, boolean singleQuotes, int checkHeader, int ncols, String[] columnNames, byte[] ctypes, String[][] domains, String[][] naStrings, String[][] data, int chunkSize) {
        this._parse_type = t;
        this._separator = sep;
        this._single_quotes = singleQuotes;
        this._check_header = checkHeader;
        this._number_columns = ncols;
        this._column_names = columnNames;
        this._column_types = ctypes;
        this._domains = domains;
        this._na_strings = naStrings;
        this._data = data;
        this._chunk_size = chunkSize;
    }

    public ParseSetup(ParseSetupV3 ps) {
        this(ps.parse_type, ps.separator, ps.single_quotes, ps.check_header, -1, ps.column_names, ParseSetup.strToColumnTypes(ps.column_types), null, ps.na_strings, null, ps.chunk_size);
        if (ps.parse_type == null) {
            this._parse_type = ParserType.GUESS;
        }
        if (ps.separator == 0) {
            this._separator = (byte)-1;
        }
    }

    public ParseSetup(ParserType t, byte sep, boolean singleQuotes, int checkHeader, int ncols, String[] columnNames, byte[] ctypes, String[][] domains, String[][] naStrings, String[][] data) {
        this(t, sep, singleQuotes, checkHeader, ncols, columnNames, ctypes, domains, naStrings, data, 0x400000);
    }

    public ParseSetup(ParserType t, byte sep, boolean singleQuotes, int checkHeader, int ncols, String[][] data) {
        this(t, sep, singleQuotes, checkHeader, ncols, null, null, null, null, data, 0x400000);
    }

    public ParseSetup() {
    }

    public String[] getColumnNames() {
        return this._column_names;
    }

    public String[][] getData() {
        return this._data;
    }

    public String[] getColumnTypeStrings() {
        String[] types = new String[this._column_types.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = Vec.TYPE_STR[this._column_types[i]];
        }
        return types;
    }

    public static byte[] strToColumnTypes(String[] strs) {
        if (strs == null) {
            return null;
        }
        byte[] types = new byte[strs.length];
        block16: for (int i = 0; i < types.length; ++i) {
            String string = strs[i].toLowerCase();
            int n = -1;
            switch (string.hashCode()) {
                case -284840886: {
                    if (!string.equals("unknown")) break;
                    n = 0;
                    break;
                }
                case 3601339: {
                    if (!string.equals("uuid")) break;
                    n = 1;
                    break;
                }
                case -891985903: {
                    if (!string.equals("string")) break;
                    n = 2;
                    break;
                }
                case -2000413939: {
                    if (!string.equals("numeric")) break;
                    n = 3;
                    break;
                }
                case 3118337: {
                    if (!string.equals("enum")) break;
                    n = 4;
                    break;
                }
                case 3560141: {
                    if (!string.equals("time")) break;
                    n = 5;
                }
            }
            switch (n) {
                case 0: {
                    types[i] = 0;
                    continue block16;
                }
                case 1: {
                    types[i] = 1;
                    continue block16;
                }
                case 2: {
                    types[i] = 2;
                    continue block16;
                }
                case 3: {
                    types[i] = 3;
                    continue block16;
                }
                case 4: {
                    types[i] = 4;
                    continue block16;
                }
                case 5: {
                    types[i] = 5;
                    continue block16;
                }
                default: {
                    types[i] = 0;
                    throw new H2OIllegalArgumentException("Provided column type " + strs[i] + " is unknown. ", "Cannot proceed with parse due to invalid argument.");
                }
            }
        }
        return types;
    }

    public Parser parser(Key jobKey) {
        switch (this._parse_type) {
            case CSV: {
                return new CsvParser(this, jobKey);
            }
            case XLS: {
                return new XlsParser(this, jobKey);
            }
            case SVMLight: {
                return new SVMLightParser(this, jobKey);
            }
            case ARFF: {
                return new ARFFParser(this, jobKey);
            }
        }
        throw new H2OIllegalArgumentException("Unknown file type.  Parse cannot be completed.", "Attempted to invoke a parser for ParseType:" + (Object)((Object)this._parse_type) + ", which doesn't exist.");
    }

    HashSet<String> checkDupColumnNames() {
        HashSet<String> conflictingNames = new HashSet<String>();
        if (this._column_names == null) {
            return conflictingNames;
        }
        HashSet uniqueNames = new HashSet();
        for (String n : this._column_names) {
            if (n == null) continue;
            (uniqueNames.contains(n) ? conflictingNames : uniqueNames).add(n);
        }
        return conflictingNames;
    }

    public String toString() {
        return this._parse_type.toString(this._number_columns, this._separator);
    }

    static boolean allStrings(String[] line) {
        ValueString str = new ValueString();
        for (String s : line) {
            try {
                Double.parseDouble(s);
                return false;
            }
            catch (NumberFormatException e) {
                str.setTo(s);
                if (ParseTime.isTime(str)) {
                    return false;
                }
                if (!ParseUUID.isUUID(str)) continue;
                return false;
            }
        }
        return true;
    }

    static boolean hasHeader(String[] l1, String[] l2) {
        return ParseSetup.allStrings(l1) && !ParseSetup.allStrings(l2);
    }

    public static ParseSetup guessSetup(Key[] fkeys, boolean singleQuote, int checkHeader) {
        return ParseSetup.guessSetup(fkeys, new ParseSetup(ParserType.GUESS, -1, singleQuote, checkHeader, -1, null));
    }

    public static ParseSetup guessSetup(Key[] fkeys, ParseSetup userSetup) {
        GuessSetupTsk t = new GuessSetupTsk(userSetup);
        ((GuessSetupTsk)t.doAll(fkeys)).getResult();
        Object ice = DKV.getGet(fkeys[0]);
        t._gblSetup._chunk_size = ice instanceof Frame && ((Frame)ice).vec(0) instanceof UploadFileVec ? 0x400000 : FileVec.calcOptimalChunkSize(t._totalParseSize, t._gblSetup._number_columns);
        return t._gblSetup;
    }

    public static ParseSetup guessSetup(byte[] bits, ParseSetup userSetup) {
        return ParseSetup.guessSetup(bits, userSetup._parse_type, userSetup._separator, -1, userSetup._single_quotes, userSetup._check_header, userSetup._column_names, userSetup._column_types, null, null);
    }

    public static ParseSetup guessSetup(byte[] bits, ParserType pType, byte sep, int ncols, boolean singleQuotes, int checkHeader, String[] columnNames, byte[] columnTypes, String[][] domains, String[][] naStrings) {
        switch (pType) {
            case CSV: {
                return CsvParser.guessSetup(bits, sep, ncols, singleQuotes, checkHeader, columnNames, columnTypes, naStrings);
            }
            case SVMLight: {
                return SVMLightParser.guessSetup(bits);
            }
            case XLS: {
                return XlsParser.guessSetup(bits);
            }
            case ARFF: {
                return ARFFParser.guessSetup(bits, sep, singleQuotes, columnNames, naStrings);
            }
            case GUESS: {
                for (ParserType pTypeGuess : guessFileTypeOrder) {
                    try {
                        ParseSetup ps = ParseSetup.guessSetup(bits, pTypeGuess, sep, ncols, singleQuotes, checkHeader, columnNames, columnTypes, domains, naStrings);
                        if (ps == null) continue;
                        return ps;
                    }
                    catch (Throwable ignore) {
                        // empty catch block
                    }
                }
                break;
            }
        }
        throw new H2OParseSetupException("Cannot determine file type.");
    }

    public static String createHexName(String n) {
        int i;
        int sep = n.lastIndexOf(File.separatorChar);
        if (sep > 0) {
            n = n.substring(sep + 1);
        }
        int dot = n.lastIndexOf(46);
        while (dot > 0 && (n.endsWith("zip") || n.endsWith("gz") || n.endsWith("csv") || n.endsWith("xls") || n.endsWith("txt") || n.endsWith("svm") || n.endsWith("arff"))) {
            n = n.substring(0, dot);
            dot = n.lastIndexOf(46);
        }
        if (!Character.isJavaIdentifierStart(n.charAt(0))) {
            n = "X" + n;
        }
        char[] cs = n.toCharArray();
        for (i = 1; i < cs.length; ++i) {
            if (Character.isJavaIdentifierPart(cs[i])) continue;
            cs[i] = 95;
        }
        n = new String(cs);
        i = 0;
        String res = n + ".hex";
        Key k = Key.make(res);
        while (DKV.get(k) != null) {
            res = n + ++i + ".hex";
            k = Key.make(res);
        }
        return res;
    }

    private static final void checkCharEncoding(byte[] bits) {
        if (bits.length >= 2 && (bits[0] == -1 && bits[1] == -2 || bits[0] == -2 && bits[1] == -1)) {
            throw new H2OParseSetupException("UTF16 encoding detected, but is not supported.");
        }
    }

    public static class GuessSetupTsk
    extends MRTask<GuessSetupTsk> {
        final ParseSetup _userSetup;
        boolean _empty = true;
        public ParseSetup _gblSetup;
        public long _totalParseSize;

        public GuessSetupTsk(ParseSetup userSetup) {
            this._userSetup = userSetup;
        }

        @Override
        public void map(Key key) {
            Object ice = DKV.getGet(key);
            if (ice == null) {
                throw new H2OIllegalArgumentException("Missing data", "Did not find any data under key " + key);
            }
            ByteVec bv = (ByteVec)(ice instanceof ByteVec ? ice : ((Frame)ice).vecs()[0]);
            byte[] bits = ZipUtil.getFirstUnzippedBytes(bv);
            if (bits.length > 0) {
                this._empty = false;
                float decompRatio = ZipUtil.decompressionRatio(bv);
                this._totalParseSize = (double)decompRatio > 1.0 ? (long)((float)this._totalParseSize + (float)bv.length() * decompRatio) : (this._totalParseSize += bv.length());
                ParseSetup.checkCharEncoding(bits);
                try {
                    this._gblSetup = ParseSetup.guessSetup(bits, this._userSetup);
                }
                catch (H2OParseException pse) {
                    throw new H2OParseSetupException(key, pse);
                }
            }
        }

        @Override
        public void reduce(GuessSetupTsk other) {
            if (other._empty) {
                return;
            }
            if (this._gblSetup == null) {
                this._empty = false;
                this._gblSetup = other._gblSetup;
                assert (this._gblSetup != null);
                return;
            }
            this._gblSetup = this.mergeSetups(this._gblSetup, other._gblSetup);
            this._totalParseSize += other._totalParseSize;
        }

        @Override
        public void postGlobal() {
            if (this._gblSetup._column_previews != null && this._gblSetup._parse_type != ParserType.ARFF) {
                this._gblSetup._column_types = this._gblSetup._column_previews.guessTypes();
                this._gblSetup._na_strings = this._userSetup._na_strings == null ? this._gblSetup._column_previews.guessNAStrings(this._gblSetup._column_types) : this._userSetup._na_strings;
            }
        }

        private ParseSetup mergeSetups(ParseSetup setupA, ParseSetup setupB) {
            if (setupA == null) {
                return setupB;
            }
            ParseSetup mergedSetup = setupA;
            mergedSetup._check_header = GuessSetupTsk.unifyCheckHeader(setupA._check_header, setupB._check_header);
            mergedSetup._separator = GuessSetupTsk.unifyColumnSeparators(setupA._separator, setupB._separator);
            mergedSetup._number_columns = GuessSetupTsk.unifyColumnCount(setupA._number_columns, setupB._number_columns);
            mergedSetup._column_names = GuessSetupTsk.unifyColumnNames(setupA._column_names, setupB._column_names);
            if (setupA._parse_type != ParserType.ARFF || setupB._parse_type != ParserType.CSV) {
                if (setupA._parse_type == ParserType.CSV && setupB._parse_type == ParserType.ARFF) {
                    mergedSetup._parse_type = ParserType.ARFF;
                    mergedSetup._column_types = setupB._column_types;
                } else if (setupA._parse_type == setupB._parse_type) {
                    mergedSetup._column_previews = PreviewParseWriter.unifyColumnPreviews(setupA._column_previews, setupB._column_previews);
                } else {
                    throw new H2OParseSetupException("File type mismatch. Cannot parse files of type " + (Object)((Object)setupA._parse_type) + " and " + (Object)((Object)setupB._parse_type) + " as one dataset.");
                }
            }
            if (mergedSetup._data.length < 10) {
                int n = mergedSetup._data.length;
                int m = Math.min(10, n + setupB._data.length - 1);
                mergedSetup._data = (String[][])Arrays.copyOf(mergedSetup._data, m);
                System.arraycopy(setupB._data, 0, mergedSetup._data, n, m - n);
            }
            return mergedSetup;
        }

        private static int unifyCheckHeader(int chkHdrA, int chkHdrB) {
            if (chkHdrA == 0 || chkHdrB == 0) {
                throw new H2OParseSetupException("Unable to determine header on a file. Not expected.");
            }
            if (chkHdrA == 1 || chkHdrB == 1) {
                return 1;
            }
            return -1;
        }

        private static byte unifyColumnSeparators(byte sepA, byte sepB) {
            if (sepA == sepB) {
                return sepA;
            }
            if (sepA == -1) {
                return sepB;
            }
            if (sepB == -1) {
                return sepA;
            }
            throw new H2OParseSetupException("Column separator mismatch. One file seems to use \"" + (char)sepA + "\" and the other uses \"" + (char)sepB + "\".");
        }

        private static int unifyColumnCount(int cntA, int cntB) {
            if (cntA == cntB) {
                return cntA;
            }
            if (cntA == 0) {
                return cntB;
            }
            if (cntB == 0) {
                return cntA;
            }
            throw new H2OParseSetupException("Files conflict in number of columns. " + cntA + " vs. " + cntB + ".");
        }

        private static String[] unifyColumnNames(String[] namesA, String[] namesB) {
            if (namesA == null) {
                return namesB;
            }
            if (namesB == null) {
                return namesA;
            }
            for (int i = 0; i < namesA.length; ++i) {
                if (i <= namesB.length && namesA[i].equals(namesB[i])) continue;
                throw new H2OParseSetupException("Column names do not match between files.");
            }
            return namesA;
        }
    }
}

