/*
 * Decompiled with CFR 0.152.
 */
package water.parser;

import com.google.common.base.Charsets;
import java.util.Arrays;
import java.util.Formatter;
import water.Iced;

public class ValueString
extends Iced
implements Comparable<ValueString> {
    private byte[] _buf;
    private int _off;
    private int _len;

    ValueString(byte[] buf, int off, int len) {
        this._buf = buf;
        this._off = off;
        this._len = len;
    }

    ValueString(byte[] buf) {
        this(buf, 0, buf.length);
    }

    public ValueString(String from) {
        this(from.getBytes(Charsets.UTF_8));
    }

    ValueString(ValueString from) {
        this(Arrays.copyOfRange(from._buf, from._off, from._off + from._len));
    }

    public ValueString() {
    }

    @Override
    public int compareTo(ValueString o) {
        int len = Math.min(this._len, o._len);
        for (int i = 0; i < len; ++i) {
            int x = (0xFF & this._buf[this._off + i]) - (0xFF & o._buf[o._off + i]);
            if (x == 0) continue;
            return x;
        }
        return this._len - o._len;
    }

    public int hashCode() {
        int hash = 0;
        int n = this.getOffset() + this.length();
        for (int i = this.getOffset(); i < n; ++i) {
            hash = 31 * hash + this.getBuffer()[i];
        }
        return hash;
    }

    void addChar() {
        ++this._len;
    }

    void addBuff(byte[] bits) {
        byte[] buf = new byte[this.length()];
        int l1 = this.getBuffer().length - this.getOffset();
        System.arraycopy(this.getBuffer(), this.getOffset(), buf, 0, l1);
        System.arraycopy(bits, 0, buf, l1, this.length() - l1);
        this._off = 0;
        this._buf = buf;
    }

    public String toString() {
        return new String(this._buf, this._off, this._len, Charsets.UTF_8);
    }

    public String bytesToString() {
        StringBuilder sb = new StringBuilder(this._len * 2);
        Formatter formatter = new Formatter(sb);
        boolean inHex = false;
        for (int i = 0; i < this._len; ++i) {
            if ((this._buf[this._off + i] & 0x80) == 128) {
                if (!inHex) {
                    sb.append("<0x");
                }
                formatter.format("%02X", this._buf[this._off + i]);
                inHex = true;
                continue;
            }
            if (inHex) {
                sb.append(">");
                inHex = false;
            }
            formatter.format("%c", this._buf[this._off + i]);
        }
        if (inHex) {
            sb.append(">");
        }
        return sb.toString();
    }

    public static String[] toString(ValueString[] vs) {
        if (vs == null) {
            return null;
        }
        String[] ss = new String[vs.length];
        for (int i = 0; i < vs.length; ++i) {
            ss[i] = vs[i].toString();
        }
        return ss;
    }

    public static ValueString[] toValueString(String[] strings) {
        if (strings == null) {
            return null;
        }
        ValueString[] res = new ValueString[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            res[i] = new ValueString();
            res[i].setTo(strings[i]);
        }
        return res;
    }

    public ValueString set(byte[] buf, int off, int len) {
        this._buf = buf;
        this._off = off;
        this._len = len;
        return this;
    }

    public ValueString setTo(String what) {
        this._buf = what.getBytes(Charsets.UTF_8);
        this._off = 0;
        this._len = this._buf.length;
        return this;
    }

    public void setOff(int off) {
        this._off = off;
    }

    public boolean equals(Object o) {
        if (o instanceof ValueString) {
            ValueString str = (ValueString)o;
            if (str.length() != this._len) {
                return false;
            }
            for (int i = 0; i < this._len; ++i) {
                if (this.getBuffer()[this.getOffset() + i] == str.getBuffer()[str.getOffset() + i]) continue;
                return false;
            }
            return true;
        }
        if (o instanceof String) {
            String str = (String)o;
            if (str.length() != this.length()) {
                return false;
            }
            for (int i = 0; i < this.length(); ++i) {
                if (this.getBuffer()[this.getOffset() + i] == str.charAt(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public final byte[] getBuffer() {
        return this._buf;
    }

    public final int getOffset() {
        return this._off;
    }

    public final int length() {
        return this._len;
    }
}

