/*
 * Decompiled with CFR 0.152.
 */
package water.persist;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicLong;
import water.H2O;
import water.Key;
import water.Value;
import water.exceptions.H2OIllegalArgumentException;
import water.fvec.UploadFileVec;
import water.persist.Persist;
import water.persist.PersistFS;
import water.persist.PersistNFS;
import water.persist.PersistS3;
import water.util.Log;

public class PersistManager {
    public static final int MAX_BACKENDS = 8;
    private Persist[] I = new Persist[8];
    private PersistStatsEntry[] stats = new PersistStatsEntry[8];

    public PersistStatsEntry[] getStats() {
        return this.stats;
    }

    public static boolean isHdfsPath(String path) {
        String s = path.toLowerCase();
        return s.startsWith("hdfs:") || s.startsWith("s3:") || s.startsWith("s3n:") || s.startsWith("s3a:") || s.startsWith("maprfs:");
    }

    private void validateHdfsConfigured() {
        if (this.I[2] == null) {
            throw new H2OIllegalArgumentException("HDFS, S3, S3N, and S3A support is not configured");
        }
    }

    public PersistManager(URI iceRoot) {
        for (int i = 0; i < this.stats.length; ++i) {
            this.stats[i] = new PersistStatsEntry();
        }
        if (iceRoot == null) {
            Log.err("ice_root must be specified.  Exiting.");
            H2O.exit(1);
        }
        PersistFS ice = null;
        boolean windowsPath = iceRoot.toString().matches("^[a-zA-Z]:.*");
        if (windowsPath) {
            ice = new PersistFS(new File(iceRoot.toString()));
        } else if (iceRoot.getScheme() == null || "file".equals(iceRoot.getScheme())) {
            ice = new PersistFS(new File(iceRoot.getPath()));
        } else if ("hdfs".equals(iceRoot.getScheme())) {
            Log.err("HDFS ice_root not yet supported.  Exiting.");
            H2O.exit(1);
        }
        this.I[1] = ice;
        this.I[4] = new PersistNFS();
        try {
            Class<?> klass = Class.forName("water.persist.PersistHdfs");
            Constructor<?> constructor = klass.getConstructor(new Class[0]);
            this.I[2] = (Persist)constructor.newInstance(new Object[0]);
            Log.info("HDFS subsystem successfully initialized");
        }
        catch (Throwable ignore) {
            Log.info("HDFS subsystem not available");
        }
        try {
            this.I[3] = new PersistS3();
            Log.info("S3 subsystem successfully initialized");
        }
        catch (NoClassDefFoundError ignore) {
            Log.info("S3 subsystem not available");
        }
    }

    public void store(int backend, Value v) {
        this.stats[backend].store_count.incrementAndGet();
        this.I[backend].store(v);
    }

    public void delete(int backend, Value v) {
        this.stats[backend].delete_count.incrementAndGet();
        this.I[backend].delete(v);
    }

    public byte[] load(int backend, Value v) throws IOException {
        this.stats[backend].load_count.incrementAndGet();
        byte[] arr = this.I[backend].load(v);
        this.stats[backend].load_bytes.addAndGet(arr.length);
        return arr;
    }

    public Persist getIce() {
        return this.I[1];
    }

    public final Key anyURIToKey(URI uri) throws IOException {
        Key ikey = null;
        String scheme = uri.getScheme();
        if ("hdfs".equals(scheme)) {
            ikey = this.I[2].uriToKey(uri);
        } else if ("s3".equals(scheme) || "s3n".equals(scheme) || "s3a".equals(scheme)) {
            ikey = this.I[2].uriToKey(uri);
        } else if ("file".equals(scheme) || scheme == null) {
            ikey = this.I[4].uriToKey(uri);
        } else {
            throw new H2OIllegalArgumentException("Unsupported schema '" + scheme + "' for given uri " + uri);
        }
        return ikey;
    }

    private static boolean httpUrlExists(String URLName) {
        try {
            HttpURLConnection con = (HttpURLConnection)new URL(URLName).openConnection();
            con.setInstanceFollowRedirects(false);
            con.setRequestMethod("HEAD");
            return con.getResponseCode() == 200;
        }
        catch (Exception e) {
            return false;
        }
    }

    public ArrayList<String> calcTypeaheadMatches(String filter, int limit) {
        String s = filter.toLowerCase();
        if (s.startsWith("http:") || s.startsWith("https:")) {
            if (PersistManager.httpUrlExists(filter)) {
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(filter);
                return arrayList;
            }
            return new ArrayList<String>();
        }
        if (s.startsWith("hdfs:") || s.startsWith("s3:") || s.startsWith("s3n:") || s.startsWith("s3a:") || s.startsWith("maprfs:")) {
            if (this.I[2] == null) {
                throw new H2OIllegalArgumentException("HDFS, S3, S3N, and S3A support is not configured");
            }
            return this.I[2].calcTypeaheadMatches(filter, limit);
        }
        return this.I[4].calcTypeaheadMatches(filter, limit);
    }

    public void importFiles(String path, ArrayList<String> files, ArrayList<String> keys, ArrayList<String> fails, ArrayList<String> dels) {
        assert (path != null);
        String s = path.toLowerCase();
        if (s.startsWith("http:") || s.startsWith("https:")) {
            try {
                URL url = new URL(path);
                Key destination_key = Key.make(path);
                InputStream is = url.openStream();
                if (is == null) {
                    Log.err("Unable to open stream to URL " + path);
                }
                UploadFileVec.ReadPutStats stats = new UploadFileVec.ReadPutStats();
                UploadFileVec.readPut(destination_key, is, stats);
                files.add(path);
                keys.add(destination_key.toString());
            }
            catch (Throwable e) {
                fails.add(path);
            }
            return;
        }
        if (s.startsWith("hdfs:") || s.startsWith("s3:") || s.startsWith("s3n:") || s.startsWith("s3a:") || s.startsWith("maprfs:")) {
            if (this.I[2] == null) {
                throw new H2OIllegalArgumentException("HDFS, S3, S3N, and S3A support is not configured");
            }
            this.I[2].importFiles(path, files, keys, fails, dels);
            return;
        }
        this.I[4].importFiles(path, files, keys, fails, dels);
    }

    public String getHdfsHomeDirectory() {
        if (this.I[2] == null) {
            return null;
        }
        return this.I[2].getHomeDirectory();
    }

    public Persist.PersistEntry[] list(String path) {
        if (PersistManager.isHdfsPath(path)) {
            this.validateHdfsConfigured();
            Persist.PersistEntry[] arr = this.I[2].list(path);
            return arr;
        }
        File dir = new File(path);
        File[] files = dir.listFiles();
        if (files == null) {
            return new Persist.PersistEntry[0];
        }
        ArrayList<Persist.PersistEntry> arr = new ArrayList<Persist.PersistEntry>();
        for (File f : files) {
            Persist.PersistEntry entry = new Persist.PersistEntry(f.getName(), f.length(), f.lastModified());
            arr.add(entry);
        }
        return arr.toArray(new Persist.PersistEntry[arr.size()]);
    }

    public boolean exists(String path) {
        if (PersistManager.isHdfsPath(path)) {
            this.validateHdfsConfigured();
            boolean b = this.I[2].exists(path);
            return b;
        }
        File f = new File(path);
        return f.exists();
    }

    public long length(String path) {
        if (PersistManager.isHdfsPath(path)) {
            this.validateHdfsConfigured();
            long l = this.I[2].length(path);
            return l;
        }
        File f = new File(path);
        if (!f.exists()) {
            throw new IllegalArgumentException("File not found (" + path + ")");
        }
        return f.length();
    }

    public InputStream open(String path) {
        if (PersistManager.isHdfsPath(path)) {
            this.validateHdfsConfigured();
            InputStream os = this.I[2].open(path);
            return os;
        }
        try {
            File f = new File(path);
            return new FileInputStream(f);
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("File not found (" + path + ")");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean mkdirs(String path) {
        if (PersistManager.isHdfsPath(path)) {
            this.validateHdfsConfigured();
            boolean b = this.I[2].mkdirs(path);
            return b;
        }
        File f = new File(path);
        boolean b = f.mkdirs();
        return b;
    }

    public boolean rename(String fromPath, String toPath) {
        if (PersistManager.isHdfsPath(fromPath) || PersistManager.isHdfsPath(toPath)) {
            this.validateHdfsConfigured();
            boolean b = this.I[2].rename(fromPath, toPath);
            return b;
        }
        File f = new File(fromPath);
        File t = new File(toPath);
        boolean b = f.renameTo(t);
        return b;
    }

    public OutputStream create(String path, boolean overwrite) {
        if (PersistManager.isHdfsPath(path)) {
            this.validateHdfsConfigured();
            return this.I[2].create(path, overwrite);
        }
        try {
            File f;
            if (!overwrite && (f = new File(path)).exists()) {
                throw new IllegalArgumentException("File already exists (" + path + ")");
            }
            FileOutputStream fos = new FileOutputStream(path);
            return fos;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean delete(String path) {
        if (PersistManager.isHdfsPath(path)) {
            this.validateHdfsConfigured();
            boolean b = this.I[2].delete(path);
            return b;
        }
        File f = new File(path);
        boolean b = f.delete();
        return b;
    }

    public Persist getPersistForURI(URI uri) {
        String scheme = uri.getScheme();
        if (scheme != null) {
            String string = scheme;
            int n = -1;
            switch (string.hashCode()) {
                case 3143036: {
                    if (!string.equals("file")) break;
                    n = 0;
                    break;
                }
                case 3197641: {
                    if (!string.equals("hdfs")) break;
                    n = 1;
                    break;
                }
                case 112206: {
                    if (!string.equals("s3n")) break;
                    n = 2;
                    break;
                }
                case 112193: {
                    if (!string.equals("s3a")) break;
                    n = 3;
                    break;
                }
                case 3616: {
                    if (!string.equals("s3")) break;
                    n = 4;
                }
            }
            switch (n) {
                case 0: {
                    return this.I[1];
                }
                case 1: 
                case 2: 
                case 3: {
                    return this.I[2];
                }
                case 4: {
                    return this.I[3];
                }
            }
            throw new IllegalArgumentException("Cannot find persist manager for scheme " + scheme);
        }
        return this.I[1];
    }

    public static class PersistStatsEntry {
        public AtomicLong store_count = new AtomicLong();
        public AtomicLong store_bytes = new AtomicLong();
        public AtomicLong delete_count = new AtomicLong();
        public AtomicLong load_count = new AtomicLong();
        public AtomicLong load_bytes = new AtomicLong();
    }

    public static class Schemes {
        public static final String FILE = "file";
        public static final String HDFS = "hdfs";
        public static final String S3 = "s3";
        public static final String S3N = "s3n";
        public static final String S3A = "s3a";
        public static final String NFS = "nfs";
    }
}

