/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import water.H2O;
import water.rapids.ASTBinOp;
import water.rapids.ASTOp;
import water.rapids.Env;
import water.rapids.ValNum;

class ASTAND
extends ASTBinOp {
    @Override
    String opStr() {
        return "&&";
    }

    ASTAND() {
    }

    @Override
    double op(double d0, double d1) {
        throw H2O.unimpl();
    }

    @Override
    String op(String s0, double d1) {
        throw new IllegalArgumentException("Cannot '&&' Strings.");
    }

    @Override
    String op(double d0, String s1) {
        throw new IllegalArgumentException("Cannot '&&' Strings.");
    }

    @Override
    String op(String s0, String s1) {
        throw new IllegalArgumentException("Cannot '&&' Strings.");
    }

    @Override
    ASTOp make() {
        return new ASTAND();
    }

    @Override
    void apply(Env env) {
        double op1 = env.isNum() ? env.peekDbl() : (env.isAry() ? env.peekAry().vecs()[0].at(0L) : Double.NaN);
        env.pop();
        double op2 = env.isNum() ? env.peekDbl() : (env.isAry() ? env.peekAry().vecs()[0].at(0L) : Double.NaN);
        env.pop();
        if (Double.isNaN(op1) && Double.isNaN(op2)) {
            env.push(new ValNum(Double.NaN));
            return;
        }
        if (op1 == 0.0 || op2 == 0.0) {
            env.push(new ValNum(0.0));
            return;
        }
        if (Double.isNaN(op1) || Double.isNaN(op2)) {
            env.push(new ValNum(Double.NaN));
            return;
        }
        env.push(new ValNum(1.0));
    }
}

