/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import java.util.ArrayList;
import java.util.Iterator;
import water.Iced;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;
import water.rapids.AST;
import water.rapids.ASTDoubleList;
import water.rapids.ASTNum;
import water.rapids.ASTOp;
import water.rapids.ASTSeries;
import water.rapids.ASTSpan;
import water.rapids.ASTStringList;
import water.rapids.ASTUniPrefixOp;
import water.rapids.Env;
import water.rapids.Exec;
import water.rapids.ValSeries;

class ASTCat
extends ASTUniPrefixOp {
    long[] _tilNext;

    @Override
    String opStr() {
        return "c";
    }

    public ASTCat() {
        super(new String[]{"cat", "dbls", "..."});
    }

    @Override
    ASTOp make() {
        return new ASTCat();
    }

    @Override
    ASTCat parse_impl(Exec E) {
        ArrayList<Double> dbls = new ArrayList<Double>();
        ArrayList<ASTSpan> spans = new ArrayList<ASTSpan>();
        ArrayList<Long> cnts = new ArrayList<Long>();
        boolean strs = false;
        long cnt = 0L;
        while (!E.isEnd()) {
            AST a = E.parse();
            if (a instanceof ASTStringList) {
                strs = true;
                continue;
            }
            if (a instanceof ASTDoubleList) {
                cnt += ASTCat.addAll(dbls, ((ASTDoubleList)a)._d);
                continue;
            }
            if (a instanceof ASTNum) {
                dbls.add(((ASTNum)a)._d);
                ++cnt;
                continue;
            }
            if (a instanceof ASTSpan) {
                spans.add((ASTSpan)a);
                cnts.add(cnt);
                cnt = 0L;
                cnts.add(cnt);
                continue;
            }
            throw new IllegalArgumentException("'c' expected a dlist, a number, or a span. Got: " + a.getClass());
        }
        if (!strs) {
            cnts.add(cnt);
            this._tilNext = new long[cnts.size()];
            int i = 0;
            Iterator i$ = cnts.iterator();
            while (i$.hasNext()) {
                long l = (Long)i$.next();
                this._tilNext[i++] = l;
            }
            ASTSeries s = new ASTSeries(null, ASTCat.toArray(dbls), spans.toArray(new ASTSpan[spans.size()]));
            E.eatEnd();
            ASTCat res = (ASTCat)this.clone();
            res._asts = new AST[]{s};
            return res;
        }
        return new ASTCat();
    }

    @Override
    void apply(Env env) {
        final ValSeries s = (ValSeries)env.pop();
        assert (s._d != null);
        long len = s._d.length;
        if (s._spans != null) {
            for (ASTSpan as : s._spans) {
                len += as.length();
            }
        }
        Vec v = Vec.makeZero(len);
        long[] v_espcs = v._espc;
        int nChunks = v.nChunks();
        int spanOrDbl = 0;
        int dblIdx = 0;
        int spIdx = 0;
        ASTSpan sp = null;
        long splitPoint = 0L;
        final Marker[][] chunkMarkers = new Marker[nChunks][];
        for (int i = 0; i < nChunks; ++i) {
            ArrayList<Marker> markers = new ArrayList<Marker>();
            long clen = v_espcs[i + 1] - v_espcs[i];
            Marker m = null;
            while (clen > 0L) {
                if (sp == null && spanOrDbl < this._tilNext.length && this._tilNext[spanOrDbl] != 0L) {
                    long ndbls = this._tilNext[spanOrDbl];
                    if (ndbls > clen) {
                        m = new Marker(0, dblIdx, dblIdx, (long)dblIdx + clen);
                        int n = spanOrDbl;
                        this._tilNext[n] = this._tilNext[n] - clen;
                        dblIdx = (int)((long)dblIdx + clen);
                        clen = 0L;
                    } else if (ndbls <= clen) {
                        m = new Marker(0, dblIdx, dblIdx, (long)dblIdx + ndbls);
                        this._tilNext[spanOrDbl++] = 0L;
                        dblIdx = (int)((long)dblIdx + ndbls);
                        clen -= ndbls;
                    }
                } else if (s._spans != null) {
                    if (sp == null) {
                        sp = s._spans[spIdx];
                        long spLength = sp.length();
                        if (sp.length() <= clen) {
                            m = new Marker(1, spIdx, sp._min, (long)sp._max);
                            sp = null;
                            ++spIdx;
                            ++spanOrDbl;
                            clen -= spLength;
                        } else {
                            splitPoint = sp._min + clen - 1L;
                            m = new Marker(1, spIdx, sp._min, splitPoint);
                            clen = 0L;
                        }
                    } else {
                        long leftInSpan = (long)sp._max - splitPoint + 1L;
                        if (leftInSpan <= clen) {
                            m = new Marker(1, spIdx, splitPoint + 1L, (long)sp._max);
                            sp = null;
                            splitPoint = 0L;
                            ++spIdx;
                            ++spanOrDbl;
                            clen = clen - leftInSpan + 1L;
                        } else if (leftInSpan > clen) {
                            m = new Marker(1, spIdx, splitPoint + 1L, splitPoint + 1L + clen);
                            splitPoint += clen;
                            clen = 0L;
                        }
                    }
                }
                markers.add(m);
            }
            chunkMarkers[i] = markers.toArray(new Marker[markers.size()]);
        }
        Frame fr = ((MRTask)new MRTask(){

            @Override
            public void map(Chunk c) {
                Marker[] markers;
                int cidx = c.cidx();
                int i = 0;
                for (Marker m : markers = chunkMarkers[cidx]) {
                    long j;
                    if (m._t == 0) {
                        for (j = m._start; j < m._stop; ++j) {
                            c.set(i++, s._d[(int)j]);
                        }
                        continue;
                    }
                    for (j = m._start; j <= m._stop; ++j) {
                        c.set(i++, j);
                    }
                }
            }
        }.doAll((Vec[])new Vec[]{v}))._fr;
        env.pushAry(fr);
    }

    private static long addAll(ArrayList<Double> dbls, double[] d) {
        for (double dd : d) {
            dbls.add(dd);
        }
        return d.length;
    }

    private static double[] toArray(ArrayList<Double> dbls) {
        double[] r = new double[dbls.size()];
        int i = 0;
        for (double d : dbls) {
            r[i++] = d;
        }
        return r;
    }

    private class Marker
    extends Iced {
        final byte _t;
        final int _idx;
        final long _start;
        final long _stop;

        Marker(byte t, int idx, long start, long stop) {
            this._t = t;
            this._idx = idx;
            this._start = start;
            this._stop = stop;
        }
    }
}

