/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.rapids.ASTOp;
import water.rapids.ASTUniPrefixOp;
import water.rapids.Env;
import water.util.ArrayUtils;

class ASTCumMax
extends ASTUniPrefixOp {
    @Override
    String opStr() {
        return "cummax";
    }

    @Override
    ASTOp make() {
        return new ASTCumMax();
    }

    public ASTCumMax() {
        super(new String[]{"x"});
    }

    @Override
    public void apply(Env e) {
        Frame f = e.popAry();
        if (f.numCols() != 1) {
            throw new IllegalArgumentException("Must give a single numeric column.");
        }
        if (!f.anyVec().isNumeric()) {
            throw new IllegalArgumentException("Column must be numeric.");
        }
        CumMaxTask t = new CumMaxTask(f.anyVec().nChunks());
        t.doAll(1, f.anyVec());
        final double[] chkMaxs = t._chkMaxs;
        Vec cumuVec = t.outputFrame().anyVec();
        new MRTask(){

            @Override
            public void map(Chunk c) {
                if (c.cidx() != 0) {
                    double d = chkMaxs[c.cidx() - 1];
                    for (int i = 0; i < c._len; ++i) {
                        c.set(i, Math.min(c.atd(i), d));
                    }
                }
            }
        }.doAll(cumuVec);
        e.pushAry(new Frame(cumuVec));
    }

    private class CumMaxTask
    extends MRTask<CumMaxTask> {
        final int _nchks;
        double[] _chkMaxs;

        CumMaxTask(int nchks) {
            this._nchks = nchks;
        }

        @Override
        public void setupLocal() {
            this._chkMaxs = new double[this._nchks];
        }

        @Override
        public void map(Chunk c, NewChunk nc) {
            double max = -1.7976931348623157E308;
            for (int i = 0; i < c._len; ++i) {
                double d = max = c.isNA(i) ? Double.NaN : Math.max(max, c.atd(i));
                if (Double.isNaN(max)) {
                    nc.addNA();
                    continue;
                }
                nc.addNum(max);
            }
            this._chkMaxs[c.cidx()] = max;
        }

        @Override
        public void reduce(CumMaxTask t) {
            if (this._chkMaxs != t._chkMaxs) {
                ArrayUtils.add(this._chkMaxs, t._chkMaxs);
            }
        }

        @Override
        public void postGlobal() {
            for (int i = 1; i < this._chkMaxs.length; ++i) {
                this._chkMaxs[i] = this._chkMaxs[i - 1] > this._chkMaxs[i] ? this._chkMaxs[i - 1] : this._chkMaxs[i];
            }
        }
    }
}

