/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.rapids.ASTOp;
import water.rapids.ASTUniPrefixOp;
import water.rapids.Env;
import water.util.ArrayUtils;

class ASTCumMin
extends ASTUniPrefixOp {
    @Override
    String opStr() {
        return "cummin";
    }

    @Override
    ASTOp make() {
        return new ASTCumMin();
    }

    public ASTCumMin() {
        super(new String[]{"x"});
    }

    @Override
    public void apply(Env e) {
        Frame f = e.popAry();
        if (f.numCols() != 1) {
            throw new IllegalArgumentException("Must give a single numeric column.");
        }
        if (!f.anyVec().isNumeric()) {
            throw new IllegalArgumentException("Column must be numeric.");
        }
        CumMinTask t = new CumMinTask(f.anyVec().nChunks());
        t.doAll(1, f.anyVec());
        final double[] chkMins = t._chkMins;
        Vec cumuVec = t.outputFrame().anyVec();
        new MRTask(){

            @Override
            public void map(Chunk c) {
                if (c.cidx() != 0) {
                    double d = chkMins[c.cidx() - 1];
                    for (int i = 0; i < c._len; ++i) {
                        c.set(i, Math.min(c.atd(i), d));
                    }
                }
            }
        }.doAll(cumuVec);
        e.pushAry(new Frame(cumuVec));
    }

    private class CumMinTask
    extends MRTask<CumMinTask> {
        final int _nchks;
        double[] _chkMins;

        CumMinTask(int nchks) {
            this._nchks = nchks;
        }

        @Override
        public void setupLocal() {
            this._chkMins = new double[this._nchks];
        }

        @Override
        public void map(Chunk c, NewChunk nc) {
            double min = Double.MAX_VALUE;
            for (int i = 0; i < c._len; ++i) {
                double d = min = c.isNA(i) ? Double.NaN : Math.min(min, c.atd(i));
                if (Double.isNaN(min)) {
                    nc.addNA();
                    continue;
                }
                nc.addNum(min);
            }
            this._chkMins[c.cidx()] = min;
        }

        @Override
        public void reduce(CumMinTask t) {
            if (this._chkMins != t._chkMins) {
                ArrayUtils.add(this._chkMins, t._chkMins);
            }
        }

        @Override
        public void postGlobal() {
            for (int i = 1; i < this._chkMins.length; ++i) {
                this._chkMins[i] = this._chkMins[i - 1] < this._chkMins[i] ? this._chkMins[i - 1] : this._chkMins[i];
            }
        }
    }
}

