/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.rapids.ASTOp;
import water.rapids.ASTUniPrefixOp;
import water.rapids.Env;
import water.util.ArrayUtils;

class ASTCumProd
extends ASTUniPrefixOp {
    @Override
    String opStr() {
        return "cumprod";
    }

    @Override
    ASTOp make() {
        return new ASTCumProd();
    }

    public ASTCumProd() {
        super(new String[]{"x"});
    }

    @Override
    public void apply(Env e) {
        Frame f = e.popAry();
        if (f.numCols() != 1) {
            throw new IllegalArgumentException("Must give a single numeric column.");
        }
        if (!f.anyVec().isNumeric()) {
            throw new IllegalArgumentException("Column must be numeric.");
        }
        CumProdTask t = new CumProdTask(f.anyVec().nChunks());
        t.doAll(1, f.anyVec());
        final double[] chkProds = t._chkProds;
        Vec cumuVec = t.outputFrame().anyVec();
        new MRTask(){

            @Override
            public void map(Chunk c) {
                if (c.cidx() != 0) {
                    double d = chkProds[c.cidx() - 1];
                    for (int i = 0; i < c._len; ++i) {
                        c.set(i, c.atd(i) * d);
                    }
                }
            }
        }.doAll(cumuVec);
        e.pushAry(new Frame(cumuVec));
    }

    private class CumProdTask
    extends MRTask<CumProdTask> {
        final int _nchks;
        double[] _chkProds;

        CumProdTask(int nchks) {
            this._nchks = nchks;
        }

        @Override
        public void setupLocal() {
            this._chkProds = new double[this._nchks];
        }

        @Override
        public void map(Chunk c, NewChunk nc) {
            double prod = 1.0;
            for (int i = 0; i < c._len; ++i) {
                if (Double.isNaN(prod *= c.isNA(i) ? Double.NaN : c.atd(i))) {
                    nc.addNA();
                    continue;
                }
                nc.addNum(prod);
            }
            this._chkProds[c.cidx()] = prod;
        }

        @Override
        public void reduce(CumProdTask t) {
            if (this._chkProds != t._chkProds) {
                ArrayUtils.add(this._chkProds, t._chkProds);
            }
        }

        @Override
        public void postGlobal() {
            for (int i = 1; i < this._chkProds.length; ++i) {
                int n = i;
                this._chkProds[n] = this._chkProds[n] * this._chkProds[i - 1];
            }
        }
    }
}

