/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.rapids.AST;
import water.rapids.ASTDoubleList;
import water.rapids.ASTFrame;
import water.rapids.ASTId;
import water.rapids.ASTLongList;
import water.rapids.ASTNull;
import water.rapids.ASTNum;
import water.rapids.ASTOp;
import water.rapids.ASTString;
import water.rapids.ASTStringList;
import water.rapids.ASTUniPrefixOp;
import water.rapids.Env;
import water.rapids.Exec;

class ASTCut
extends ASTUniPrefixOp {
    String[] _labels = null;
    double[] _cuts;
    boolean _includelowest = false;
    boolean _right = true;
    double _diglab = 3.0;

    ASTCut() {
        super(new String[]{"cut", "ary", "breaks", "labels", "include.lowest", "right", "dig.lab"});
    }

    @Override
    String opStr() {
        return "cut";
    }

    @Override
    ASTOp make() {
        return new ASTCut();
    }

    @Override
    ASTCut parse_impl(Exec E) {
        ASTNum diglab;
        AST ary = E.parse();
        AST breaks = E.parse();
        if (breaks instanceof ASTDoubleList) {
            this._cuts = ((ASTDoubleList)breaks)._d;
        } else if (breaks instanceof ASTLongList) {
            int i = 0;
            this._cuts = new double[((ASTLongList)breaks)._l.length];
            for (long l : ((ASTLongList)breaks)._l) {
                this._cuts[i++] = l;
            }
        } else if (breaks instanceof ASTNum) {
            this._cuts = new double[]{((ASTNum)breaks)._d};
        } else {
            throw new IllegalArgumentException("`breaks` argument expected to be a dlist or number. Got: " + breaks.getClass());
        }
        AST labels = E.parse();
        if (labels instanceof ASTStringList) {
            this._labels = ((ASTStringList)labels)._s;
        } else if (labels instanceof ASTString) {
            this._labels = new String[]{((ASTString)labels)._s};
        } else if (labels instanceof ASTFrame) {
            this._labels = new String[]{((ASTFrame)labels)._key};
        } else if (labels instanceof ASTNull) {
            this._labels = null;
        } else {
            throw new IllegalArgumentException("`labels` argument expected to be a slist or String. Got: " + labels.getClass());
        }
        if (this._labels != null) {
            for (int i = 0; i < this._labels.length; ++i) {
                this._labels[i] = this._labels[i].replace("\"", "").replace("'", "");
            }
        }
        AST inc_lowest = E.parse();
        inc_lowest = E._env.lookup((ASTId)inc_lowest);
        try {
            this._includelowest = ((ASTNum)inc_lowest).dbl() == 1.0;
        }
        catch (ClassCastException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("Argument `include.lowest` expected to be TRUE/FALSE.");
        }
        AST right = E.parse();
        right = E._env.lookup((ASTId)right);
        try {
            this._right = ((ASTNum)right).dbl() == 1.0;
        }
        catch (ClassCastException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("Argument `right` expected to be a TRUE/FALSE.");
        }
        try {
            diglab = (ASTNum)E.parse();
        }
        catch (ClassCastException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("Argument `dig.lab` expected to be a number.");
        }
        this._diglab = diglab.dbl();
        this._diglab = this._diglab >= 12.0 ? 12.0 : this._diglab;
        E.eatEnd();
        ASTCut res = (ASTCut)this.clone();
        res._asts = new AST[]{ary};
        return res;
    }

    private String left() {
        return this._right ? "(" : "[";
    }

    private String rite() {
        return this._right ? "]" : ")";
    }

    @Override
    void apply(Env env) {
        double width;
        Frame fr = env.popAry();
        if (fr.vecs().length != 1 || fr.vecs()[0].isEnum()) {
            throw new IllegalArgumentException("First argument must be a numeric column vector");
        }
        double fmin = fr.anyVec().min();
        double fmax = fr.anyVec().max();
        int nbins = this._cuts.length - 1;
        if (nbins == 0) {
            if (this._cuts[0] < 2.0) {
                throw new IllegalArgumentException("The number of cuts must be >= 2. Got: " + this._cuts[0]);
            }
            nbins = (int)Math.floor(this._cuts[0]);
            width = (fmax - fmin) / (double)nbins;
            this._cuts = new double[nbins];
            this._cuts[0] = fmin - 0.001 * (fmax - fmin);
            for (int i = 1; i < this._cuts.length; ++i) {
                this._cuts[i] = i == this._cuts.length - 1 ? fmax + 0.001 * (fmax - fmin) : fmin + (double)i * width;
            }
        }
        if ((width = (fmax - fmin) / (double)nbins) == 0.0) {
            throw new IllegalArgumentException("Data vector is constant!");
        }
        if (this._labels != null && this._labels.length != nbins) {
            throw new IllegalArgumentException("`labels` vector does not match the number of cuts.");
        }
        final double[] cuts = this._cuts;
        for (int i = 0; i < this._cuts.length; ++i) {
            this._cuts[i] = Math.floor(this._cuts[i] * Math.pow(10.0, this._diglab) + 0.5) / Math.pow(10.0, this._diglab);
        }
        String[][] domains = new String[1][nbins];
        if (this._labels == null) {
            domains[0][0] = (this._includelowest ? "[" : this.left()) + this._cuts[0] + "," + this._cuts[1] + this.rite();
            for (int i = 1; i < this._cuts.length - 1; ++i) {
                domains[0][i] = this.left() + this._cuts[i] + "," + this._cuts[i + 1] + this.rite();
            }
        } else {
            domains[0] = this._labels;
        }
        final boolean incLow = this._includelowest;
        Frame fr2 = ((MRTask)new MRTask(){

            @Override
            public void map(Chunk c, NewChunk nc) {
                int rows = c._len;
                block0: for (int r = 0; r < rows; ++r) {
                    double x = c.atd(r);
                    if (Double.isNaN(x) || incLow && x < cuts[0] || !incLow && x <= cuts[0] || ASTCut.this._right && x > cuts[cuts.length - 1] || !ASTCut.this._right && x >= cuts[cuts.length - 1]) {
                        nc.addNum(Double.NaN);
                        continue;
                    }
                    for (int i = 1; i < cuts.length; ++i) {
                        if (ASTCut.this._right) {
                            if (!(x <= cuts[i])) continue;
                            nc.addNum(i - 1);
                            continue block0;
                        }
                        if (!(x < cuts[i])) continue;
                        nc.addNum(i - 1);
                        continue block0;
                    }
                }
            }
        }.doAll(1, fr)).outputFrame(fr.names(), domains);
        env.pushAry(fr2);
    }
}

