/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import water.AutoBuffer;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;
import water.nbhm.NonBlockingHashMap;
import water.rapids.AST;
import water.rapids.ASTOp;
import water.rapids.ASTUniPrefixOp;
import water.rapids.COp;
import water.rapids.Env;
import water.rapids.Exec;
import water.rapids.ROp;
import water.rapids.Val;

class ASTFoldCombine
extends ASTUniPrefixOp {
    private ROp _red;
    private COp _combine;

    ASTFoldCombine() {
        super(null);
    }

    @Override
    String opStr() {
        return "RC";
    }

    @Override
    ASTOp make() {
        return new ASTFoldCombine();
    }

    @Override
    ASTFoldCombine parse_impl(Exec E) {
        AST ary = E.parse();
        this._red = (ROp)E.parse();
        this._combine = (COp)E.parse();
        E.eatEnd();
        ASTFoldCombine res = (ASTFoldCombine)this.clone();
        res._asts = new AST[]{ary};
        return res;
    }

    @Override
    void apply(Env e) {
        Frame f = e.popAry();
        if (f.numCols() != 1) {
            throw new IllegalArgumentException("Expected one column, got " + f.numCols());
        }
        NonBlockingHashMap<String, Val> accum = ((RTask)new RTask((ROp)this._red).doAll((Vec[])new Vec[]{f.anyVec()}))._accum;
        e.push(this._combine.combine(accum));
    }

    private static class RTask
    extends MRTask<RTask> {
        NonBlockingHashMap<String, Val> _accum;
        private ROp _red;

        RTask(ROp red) {
            this._red = red;
        }

        @Override
        public void setupLocal() {
            this._accum = new NonBlockingHashMap();
        }

        @Override
        public void map(Chunk cs) {
            for (int i = 0; i < cs._len; ++i) {
                this._red.map(this._accum, cs, i);
            }
        }

        @Override
        public void reduce(RTask t) {
            this._red.reduce(this._accum, t._accum);
        }

        @Override
        public AutoBuffer write_impl(AutoBuffer ab) {
            ab.put(this._red);
            if (this._accum == null) {
                return ab.put4(0);
            }
            ab.put4(this._accum.size());
            for (String s : this._accum.keySet()) {
                ab.putStr(s);
                ab.put(this._accum.get(s));
            }
            return ab;
        }

        @Override
        public RTask read_impl(AutoBuffer ab) {
            this._red = ab.get(ROp.class);
            int len = ab.get4();
            if (len == 0) {
                return this;
            }
            this._accum = new NonBlockingHashMap();
            for (int i = 0; i < len; ++i) {
                this._accum.put(ab.getStr(), ab.get(Val.class));
            }
            return this;
        }
    }
}

