/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import sun.misc.Unsafe;
import water.AutoBuffer;
import water.H2O;
import water.Iced;
import water.Key;
import water.Keyed;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.nbhm.NonBlockingHashSet;
import water.nbhm.UtilUnsafe;
import water.rapids.AST;
import water.rapids.ASTAry;
import water.rapids.ASTDoubleList;
import water.rapids.ASTLongList;
import water.rapids.ASTNull;
import water.rapids.ASTNum;
import water.rapids.ASTOp;
import water.rapids.ASTString;
import water.rapids.ASTStringList;
import water.rapids.ASTUniPrefixOp;
import water.rapids.Env;
import water.rapids.Exec;
import water.util.ArrayUtils;
import water.util.IcedHashMap;
import water.util.Log;

public class ASTGroupBy
extends ASTUniPrefixOp {
    private long[] _gbCols;
    private AGG[] _agg;
    private AST[] _gbColsDelayed;
    private String[] _gbColsDelayedByName;
    private long[] _orderByCols;

    ASTGroupBy() {
        super(null);
    }

    @Override
    String opStr() {
        return "GB";
    }

    @Override
    ASTOp make() {
        return new ASTGroupBy();
    }

    @Override
    ASTGroupBy parse_impl(Exec E) {
        AST ary = E.parse();
        AST s = E.parse();
        if (s instanceof ASTLongList) {
            this._gbCols = ((ASTLongList)s)._l;
        } else if (s instanceof ASTNum) {
            this._gbCols = new long[]{(long)((ASTNum)s)._d};
        } else if (s instanceof ASTAry) {
            this._gbColsDelayed = ((ASTAry)s)._a;
        } else if (s instanceof ASTStringList) {
            this._gbColsDelayedByName = ((ASTStringList)s)._s;
        } else if (s instanceof ASTDoubleList) {
            double[] d = ((ASTDoubleList)s)._d;
            this._gbCols = new long[d.length];
            for (int i = 0; i < d.length; ++i) {
                this._gbCols[i] = (long)d[i];
            }
        } else {
            throw new IllegalArgumentException("Badly formed AST. Columns argument must be a llist or number. Got: " + s.getClass());
        }
        this._agg = ((AGG)E.parse())._aggs;
        s = E.parse();
        if (s instanceof ASTLongList) {
            this._orderByCols = ((ASTLongList)s)._l;
        } else if (s instanceof ASTNum) {
            this._orderByCols = new long[]{(long)((ASTNum)s)._d};
        } else if (s instanceof ASTNull) {
            this._orderByCols = null;
        } else {
            throw new IllegalArgumentException("Order by column must be an index or list of indexes. Got " + s.getClass());
        }
        E.eatEnd();
        ASTGroupBy res = (ASTGroupBy)this.clone();
        res._asts = new AST[]{ary};
        return res;
    }

    @Override
    void apply(Env e) {
        String[][] modeDomains;
        Frame fr = e.popAry();
        if (this._gbCols == null) {
            this._gbCols = this._gbColsDelayed == null ? this.findCols(fr, this._gbColsDelayedByName) : this.findCols(fr, this._gbColsDelayed);
        }
        this.computeCols(this._agg, fr);
        for (AGG a : this._agg) {
            if (a._type != 11) continue;
            AGG.access$202(a, fr.domains()[a._c]);
        }
        long s = System.currentTimeMillis();
        GBTask p1 = (GBTask)new GBTask(this._gbCols, this._agg).doAll(fr);
        Log.info("Group By Task done in " + (double)(System.currentTimeMillis() - s) / 1000.0 + " (s)");
        int nGrps = p1._g.size();
        G[] tmpGrps = p1._g.keySet().toArray(new G[nGrps]);
        while (tmpGrps[nGrps - 1] == null) {
            --nGrps;
        }
        Object[] grps = new G[nGrps];
        System.arraycopy(tmpGrps, 0, grps, 0, nGrps);
        ParallelPostGlobal t = new ParallelPostGlobal((G[])grps, nGrps, this._orderByCols);
        H2O.submitTask(t).join();
        Object object = modeDomains = t._modeDomain == null ? (String[][])null : new String[t._modeDomain.length][];
        if (t._modeDomain != null) {
            for (int i = 0; i < t._modeDomain.length; ++i) {
                modeDomains[i] = t._modeDomain[i].toArray(new String[t._modeDomain[i].size()]);
                Arrays.sort(modeDomains[i]);
            }
        }
        if (this._orderByCols != null) {
            Arrays.sort(grps);
        }
        int nCols = this._gbCols.length + this._agg.length;
        Vec v = Vec.makeZero(nGrps);
        String[] names = new String[nCols];
        String[][] domains = new String[nCols][];
        for (int i = 0; i < this._gbCols.length; ++i) {
            names[i] = fr.name((int)this._gbCols[i]);
            domains[i] = fr.domains()[(int)this._gbCols[i]];
        }
        if (modeDomains != null) {
            int a = 0;
            for (int i = this._gbCols.length; i < nCols; ++i) {
                domains[i] = this._agg[a]._type == 11 ? modeDomains[a++] : null;
            }
        }
        System.arraycopy(AGG.names(this._agg), 0, names, this._gbCols.length, this._agg.length);
        AGG[] agg = this._agg;
        Frame f = ((MRTask)new MRTask((G[])grps, agg, modeDomains){
            final /* synthetic */ G[] val$grps;
            final /* synthetic */ AGG[] val$agg;
            final /* synthetic */ String[][] val$modeDomains;
            {
                this.val$grps = gArray;
                this.val$agg = aGGArray;
                this.val$modeDomains = stringArray;
            }

            @Override
            public void map(Chunk[] c, NewChunk[] ncs) {
                int start = (int)c[0].start();
                for (int i = 0; i < c[0]._len; ++i) {
                    int j;
                    G g = this.val$grps[i + start];
                    for (j = 0; j < g._ds.length; ++j) {
                        ncs[j].addNum(g._ds[j]);
                    }
                    block16: for (int a = 0; a < this.val$agg.length; ++a) {
                        byte type = this.val$agg[a]._type;
                        switch (type) {
                            case 0: {
                                ncs[j++].addNum(g._N);
                                continue block16;
                            }
                            case 6: {
                                ncs[j++].addNum(g._avs[a]);
                                continue block16;
                            }
                            case 4: {
                                ncs[j++].addNum(g._min[a]);
                                continue block16;
                            }
                            case 5: {
                                ncs[j++].addNum(g._max[a]);
                                continue block16;
                            }
                            case 8: {
                                ncs[j++].addNum(g._vars[a]);
                                continue block16;
                            }
                            case 7: {
                                ncs[j++].addNum(g._sdevs[a]);
                                continue block16;
                            }
                            case 9: {
                                ncs[j++].addNum(g._sum[a]);
                                continue block16;
                            }
                            case 10: {
                                ncs[j++].addNum(g._ss[a]);
                                continue block16;
                            }
                            case 1: {
                                ncs[j++].addNum(g._ND[a]);
                                continue block16;
                            }
                            case 2: {
                                ncs[j++].addNum(g._f[a]);
                                continue block16;
                            }
                            case 3: {
                                ncs[j++].addNum(g._l[a]);
                                continue block16;
                            }
                            case 11: {
                                ncs[j++].addNum(Arrays.asList(this.val$modeDomains[a]).indexOf(g._mode[a]));
                                continue block16;
                            }
                            default: {
                                throw new IllegalArgumentException("Unsupported aggregation type: " + type);
                            }
                        }
                    }
                }
            }
        }.doAll(nCols, v)).outputFrame(names, domains);
        p1._g = null;
        Keyed.remove(v._key);
        e.pushAry(f);
    }

    private long[] findCols(Frame f, String[] names) {
        long[] res = new long[names.length];
        int i = 0;
        for (String name : names) {
            long c = f.find(name);
            if (c == -1L) {
                throw new IllegalArgumentException("Column not found: " + name);
            }
            res[i++] = c;
        }
        return res;
    }

    private long[] findCols(Frame f, AST[] asts) {
        long[] res = new long[asts.length];
        int i = 0;
        for (AST ast : asts) {
            Env e = this.treeWalk(new Env(new HashSet<Key>()));
            if (e.isAry()) {
                res[i++] = f.find(e.popAry().anyVec());
                continue;
            }
            if (e.isNum()) {
                res[i++] = (int)e.popDbl();
                continue;
            }
            if (e.isStr()) {
                res[i++] = f.find(e.popStr());
                continue;
            }
            throw new IllegalArgumentException("Don't know what to do with: " + ast.getClass() + "; " + e.pop());
        }
        return res;
    }

    private void computeCols(AGG[] aggs, Frame f) {
        for (AGG a : aggs) {
            if (a._c != null) continue;
            if (a._delayedColByName != null) {
                a._c = f.find(a._delayedColByName);
                continue;
            }
            if (a._delayedCol != null) {
                Env e = this.treeWalk(new Env(new HashSet<Key>()));
                if (e.isAry()) {
                    a._c = f.find(e.popAry().anyVec());
                    continue;
                }
                if (e.isNum()) {
                    a._c = (int)e.popDbl();
                    continue;
                }
                if (e.isStr()) {
                    a._c = f.find(e.popStr());
                    continue;
                }
                throw new IllegalArgumentException("No column found for: " + e.pop());
            }
            throw new IllegalArgumentException("Missing column for aggregate: " + a._name);
        }
    }

    static class AGG
    extends AST {
        private AGG[] _aggs;
        private static final byte T_N = 0;
        private static final byte T_ND = 1;
        private static final byte T_F = 2;
        private static final byte T_L = 3;
        private static final byte T_MIN = 4;
        private static final byte T_MAX = 5;
        private static final byte T_AVG = 6;
        private static final byte T_SD = 7;
        private static final byte T_VAR = 8;
        private static final byte T_SUM = 9;
        private static final byte T_SS = 10;
        private static final byte T_MODE = 11;
        private static final byte T_ALL = 0;
        private static final byte T_IG = 1;
        private static final byte T_RM = 2;
        private static transient HashMap<String, Byte> TM = new HashMap();
        private final byte _type;
        private Integer _c;
        private final String _name;
        private final byte _na_handle;
        private AST _delayedCol;
        private String _delayedColByName;
        private String[] _domainsForMode;

        @Override
        AGG make() {
            return new AGG();
        }

        @Override
        String opStr() {
            return "agg";
        }

        @Override
        AGG parse_impl(Exec E) {
            ArrayList<AGG> aggs = new ArrayList<AGG>();
            while (!E.isEnd()) {
                String type = E.parseString(E.peekPlus());
                AST colast = E.parse();
                Integer col = null;
                AST delayedCol = null;
                String delayedColByName = null;
                if (colast instanceof ASTNum) {
                    col = (int)((ASTNum)colast)._d;
                } else if (colast instanceof ASTString) {
                    delayedColByName = ((ASTString)colast)._s;
                } else {
                    delayedCol = colast;
                }
                String na = E.parseString(E.peekPlus());
                String name = E.parseString(E.peekPlus());
                aggs.add(new AGG(type, col, na, name, delayedColByName, delayedCol));
            }
            this._aggs = aggs.toArray(new AGG[aggs.size()]);
            E.eatEnd();
            return this;
        }

        AGG() {
            this._type = 0;
            this._c = -1;
            this._name = null;
            this._na_handle = 0;
        }

        AGG(String s, Integer c, String na, String name, String delayedColByName, AST delayedCol) {
            this._type = TM.get(s.toLowerCase());
            this._c = c;
            this._delayedCol = delayedCol;
            this._delayedColByName = delayedColByName;
            String string = this._name = name == null || name.equals("") ? s + "_C" + (c + 1) : name;
            if (!TM.keySet().contains(na)) {
                Log.info("Unknown NA handle type given: `" + na + "`. Switching to \"ignore\" method.");
                this._na_handle = 0;
            } else {
                this._na_handle = TM.get(na);
            }
        }

        private static String[] names(AGG[] _agg) {
            String[] names = new String[_agg.length];
            for (int i = 0; i < names.length; ++i) {
                names[i] = _agg[i]._name;
            }
            return names;
        }

        private static byte[] naMethods(AGG[] agg) {
            byte[] methods = new byte[agg.length];
            for (int i = 0; i < agg.length; ++i) {
                methods[i] = agg[i]._na_handle;
            }
            return methods;
        }

        private static byte[] types(AGG[] agg) {
            HashSet<Byte> typesHS = new HashSet<Byte>();
            block5: for (AGG a : agg) {
                switch (a._type) {
                    case 6: {
                        typesHS.add((byte)9);
                        continue block5;
                    }
                    case 8: {
                        typesHS.add((byte)9);
                        typesHS.add((byte)10);
                        continue block5;
                    }
                    case 7: {
                        typesHS.add((byte)9);
                        typesHS.add((byte)10);
                        continue block5;
                    }
                    default: {
                        typesHS.add(a._type);
                    }
                }
            }
            byte[] types = new byte[typesHS.size()];
            int i = 0;
            Iterator i$ = typesHS.iterator();
            while (i$.hasNext()) {
                byte b = (Byte)i$.next();
                types[i++] = b;
            }
            return types;
        }

        private boolean isIgnore() {
            return this._na_handle == 0;
        }

        private boolean isRemove() {
            return this._na_handle == 1;
        }

        private boolean isAll() {
            return this._na_handle == 2;
        }

        @Override
        void exec(Env e) {
            throw H2O.fail();
        }

        @Override
        String value() {
            return "agg";
        }

        @Override
        int type() {
            return 0;
        }

        static /* synthetic */ String[] access$202(AGG x0, String[] x1) {
            x0._domainsForMode = x1;
            return x1;
        }

        static {
            TM.put("count", (byte)0);
            TM.put("nrow", (byte)0);
            TM.put("count_unique", (byte)1);
            TM.put("first", (byte)2);
            TM.put("last", (byte)3);
            TM.put("min", (byte)4);
            TM.put("max", (byte)5);
            TM.put("mean", (byte)6);
            TM.put("avg", (byte)6);
            TM.put("sd", (byte)7);
            TM.put("stdev", (byte)7);
            TM.put("var", (byte)8);
            TM.put("sum", (byte)9);
            TM.put("ss", (byte)10);
            TM.put("mode", (byte)11);
            TM.put("most", (byte)11);
            TM.put("all", (byte)0);
            TM.put("ignore", (byte)1);
            TM.put("rm", (byte)2);
        }
    }

    public static class G
    extends Iced
    implements Comparable<G> {
        public int[] _orderByCols;
        public final double[] _ds;
        public int _hash;
        private AGG[] _aggs;
        public long _N;
        public long[] _ND;
        public long[] _NA;
        public long[] _f;
        public long[] _l;
        public double[] _min;
        public double[] _max;
        public double[] _sum;
        public double[] _ss;
        public double[] _avs;
        public double[] _vars;
        public double[] _sdevs;
        public long[][] _m;
        public String[] _mode;
        private byte[] _NAMethod;
        private static final Unsafe U = UtilUnsafe.getUnsafe();
        private static final long _NOffset;
        private static final int _8B;
        private static final int _8S;
        private static final int _dB;
        private static final int _dS;

        public G fill(int row, Chunk[] chks, long[] cols) {
            for (int c = 0; c < cols.length; ++c) {
                this._ds[c] = chks[(int)cols[c]].atd(row);
            }
            this._hash = this.hash();
            return this;
        }

        private int hash() {
            long h = 0L;
            for (double d : this._ds) {
                h += Double.doubleToRawLongBits(d);
            }
            h ^= h >>> 20 ^ h >>> 12;
            h ^= h >>> 7 ^ h >>> 4;
            return (int)((h ^ h >> 32) & Integer.MAX_VALUE);
        }

        public boolean equals(Object o) {
            return o instanceof G && Arrays.equals(this._ds, ((G)o)._ds);
        }

        public int hashCode() {
            return this._hash;
        }

        public String toString() {
            return Arrays.toString(this._ds);
        }

        @Override
        public int compareTo(G g) {
            for (int i : this._orderByCols) {
                if (Double.isNaN(this._ds[i]) || this._ds[i] < g._ds[i]) {
                    return -1;
                }
                if (!Double.isNaN(g._ds[i]) && !(this._ds[i] > g._ds[i])) continue;
                return 1;
            }
            return 0;
        }

        private static long longRawIdx(int i) {
            return _8B + _8S * i;
        }

        private static long doubleRawIdx(int i) {
            return _dB + _dS * i;
        }

        G(int row, Chunk[] cs, long[] cols, int aggs, byte[] naMethod) {
            this(cols.length, aggs, naMethod);
            this.fill(row, cs, cols);
        }

        G(int len, AGG[] aggs) {
            byte[] types;
            this._aggs = aggs;
            this._ds = new double[len];
            this._NAMethod = AGG.naMethods(aggs);
            this._NA = new long[aggs.length];
            block10: for (byte t : types = AGG.types(aggs)) {
                switch (t) {
                    case 1: {
                        this._ND = new long[aggs.length];
                        continue block10;
                    }
                    case 2: {
                        this._f = new long[aggs.length];
                        continue block10;
                    }
                    case 3: {
                        this._l = new long[aggs.length];
                        continue block10;
                    }
                    case 4: {
                        int i;
                        this._min = new double[aggs.length];
                        for (i = 0; i < this._min.length; ++i) {
                            this._min[i] = Double.POSITIVE_INFINITY;
                        }
                        continue block10;
                    }
                    case 5: {
                        int i;
                        this._max = new double[aggs.length];
                        for (i = 0; i < this._max.length; ++i) {
                            this._max[i] = Double.NEGATIVE_INFINITY;
                        }
                        continue block10;
                    }
                    case 9: {
                        this._sum = new double[aggs.length];
                        continue block10;
                    }
                    case 10: {
                        this._ss = new double[aggs.length];
                        continue block10;
                    }
                    case 11: {
                        int i;
                        this._m = new long[aggs.length][];
                        for (i = 0; i < this._m.length; ++i) {
                            this._m[i] = aggs[i]._domainsForMode == null ? null : new long[aggs[i]._domainsForMode.length];
                        }
                        continue block10;
                    }
                }
            }
        }

        G(int len, int aggs, byte[] naMethod) {
            int i;
            this._ds = new double[len];
            this._NAMethod = naMethod;
            this._ND = new long[aggs];
            this._NA = new long[aggs];
            this._f = new long[aggs];
            this._l = new long[aggs];
            this._min = new double[aggs];
            this._max = new double[aggs];
            this._sum = new double[aggs];
            this._ss = new double[aggs];
            this._avs = new double[aggs];
            this._vars = new double[aggs];
            this._sdevs = new double[aggs];
            this._mode = new String[aggs];
            this._m = new long[aggs][];
            for (i = 0; i < this._min.length; ++i) {
                this._min[i] = Double.POSITIVE_INFINITY;
            }
            for (i = 0; i < this._max.length; ++i) {
                this._max[i] = Double.NEGATIVE_INFINITY;
            }
        }

        G(int len) {
            this._ds = new double[len];
        }

        G() {
            this._ds = null;
        }

        G(double[] ds) {
            this._ds = ds;
        }

        private void close() {
            int i;
            this._avs = this._sum == null ? null : new double[this._NAMethod.length];
            this._vars = this._sum == null || this._ss == null ? null : new double[this._avs.length];
            this._sdevs = this._vars == null ? null : new double[this._vars.length];
            for (i = 0; i < this._NAMethod.length; ++i) {
                long n;
                long l = n = this._NAMethod[i] == 2 ? this._N - this._NA[i] : this._N;
                if (this._avs != null) {
                    this._avs[i] = this._sum[i] / (double)n;
                }
                if (this._vars != null) {
                    this._vars[i] = (this._ss[i] - this._sum[i] * this._sum[i] / (double)n) / (double)n;
                }
                if (this._sdevs == null) continue;
                this._sdevs[i] = Math.sqrt(this._vars[i]);
            }
            if (this._m != null && this._aggs != null) {
                this._mode = new String[this._NAMethod.length];
                for (i = 0; i < this._m.length; ++i) {
                    if (this._m[i] == null) continue;
                    this._mode[i] = this._aggs[i]._domainsForMode[ArrayUtils.maxIndex(this._m[i])];
                }
            }
        }

        protected static boolean CAS_N(G g, long o, long n) {
            return U.compareAndSwapLong(g, _NOffset, o, n);
        }

        private static boolean CAS_NA(G g, long off, long o, long n) {
            return U.compareAndSwapLong(g._NA, off, o, n);
        }

        private static boolean CAS_f(G g, long off, long o, long n) {
            return U.compareAndSwapLong(g._f, off, o, n);
        }

        private static boolean CAS_l(G g, long off, long o, long n) {
            return U.compareAndSwapLong(g._l, off, o, n);
        }

        private static boolean CAS_m(G g, int c, int lvl, long o, long n) {
            return U.compareAndSwapLong(g._m[c], G.longRawIdx(lvl), o, n);
        }

        private static boolean CAS_min(G g, long off, long o, long n) {
            return U.compareAndSwapLong(g._min, off, o, n);
        }

        private static boolean CAS_max(G g, long off, long o, long n) {
            return U.compareAndSwapLong(g._max, off, o, n);
        }

        private static boolean CAS_sum(G g, long off, long o, long n) {
            return U.compareAndSwapLong(g._sum, off, o, n);
        }

        private static boolean CAS_ss(G g, long off, long o, long n) {
            return U.compareAndSwapLong(g._ss, off, o, n);
        }

        static {
            _8B = U.arrayBaseOffset(long[].class);
            _8S = U.arrayIndexScale(long[].class);
            _dB = U.arrayBaseOffset(double[].class);
            _dS = U.arrayIndexScale(double[].class);
            try {
                _NOffset = U.objectFieldOffset(G.class.getDeclaredField("_N"));
            }
            catch (Exception e) {
                throw H2O.fail();
            }
        }
    }

    private static class NBHSAD
    extends Iced {
        private transient NonBlockingHashSet[] _nd;
        private int _n;

        NBHSAD(int n) {
            this._nd = new NonBlockingHashSet[n];
            this._n = n;
        }

        @Override
        public AutoBuffer write_impl(AutoBuffer ab) {
            int len = this._nd.length;
            ab.put4(len);
            for (NonBlockingHashSet a_nd : this._nd) {
                if (a_nd == null) {
                    ab.put4(0);
                    continue;
                }
                int s = a_nd.size();
                ab.put4(s);
                for (Object d : a_nd) {
                    ab.put8d((Double)d);
                }
            }
            return ab;
        }

        @Override
        public NBHSAD read_impl(AutoBuffer ab) {
            int len;
            this._n = len = ab.get4();
            this._nd = new NonBlockingHashSet[len];
            for (int i = 0; i < len; ++i) {
                this._nd[i] = new NonBlockingHashSet();
                int s = ab.get4();
                if (s == 0) continue;
                for (int j = 0; j < s; ++j) {
                    this._nd[i].add(ab.get8d());
                }
            }
            return this;
        }
    }

    public static class ParallelPostGlobal
    extends H2O.H2OCountedCompleter<ParallelPostGlobal> {
        private final G[] _g;
        private final int _ngrps;
        private final long[] _orderByCols;
        private final int _maxP = 50000;
        private final AtomicInteger _ctr;
        private NonBlockingHashSet<String>[] _modeDomain;

        ParallelPostGlobal(G[] g, int ngrps, long[] orderByCols) {
            this._g = g;
            this._ctr = new AtomicInteger(49999);
            this._ngrps = ngrps;
            this._orderByCols = orderByCols;
            NonBlockingHashSet[] nonBlockingHashSetArray = this._modeDomain = this._g[0]._aggs == null ? null : new NonBlockingHashSet[this._g[0]._aggs.length];
            if (this._modeDomain != null) {
                for (int i = 0; i < this._modeDomain.length; ++i) {
                    this._modeDomain[i] = new NonBlockingHashSet();
                }
            }
        }

        @Override
        protected void compute2() {
            this.addToPendingCount(this._g.length - 1);
            for (int i = 0; i < Math.min(this._g.length, 50000); ++i) {
                this.frkTsk(i);
            }
        }

        private void frkTsk(int i) {
            new GTask(new Callback(), this._g[i], this._orderByCols, this._modeDomain).fork();
        }

        private class Callback
        extends H2O.H2OCallback {
            public Callback() {
                super(ParallelPostGlobal.this);
            }

            public void callback(H2O.H2OCountedCompleter cc) {
                int i = ParallelPostGlobal.this._ctr.incrementAndGet();
                if (i < ParallelPostGlobal.this._g.length) {
                    ParallelPostGlobal.this.frkTsk(i);
                }
            }
        }
    }

    private static class GTask
    extends H2O.H2OCountedCompleter<GTask> {
        private final G _g;
        private final long[] _orderByCols;
        private NonBlockingHashSet<String>[] _modeDomain;

        GTask(H2O.H2OCountedCompleter cc, G g, long[] orderByCols, NonBlockingHashSet<String>[] modeDomain) {
            super(cc);
            this._g = g;
            this._orderByCols = orderByCols;
            this._modeDomain = modeDomain;
        }

        @Override
        protected void compute2() {
            int i;
            int[] orderByCols;
            this._g.close();
            int[] nArray = orderByCols = this._orderByCols == null ? null : new int[this._orderByCols.length];
            if (orderByCols != null) {
                for (i = 0; i < orderByCols.length; ++i) {
                    orderByCols[i] = (int)this._orderByCols[i];
                }
            }
            this._g._orderByCols = orderByCols;
            if (this._g._mode != null) {
                for (i = 0; i < this._g._mode.length; ++i) {
                    this._modeDomain[i].add(this._g._mode[i]);
                }
            }
            this.tryComplete();
        }
    }

    public static class GBTask
    extends MRTask<GBTask> {
        IcedHashMap<G, String> _g;
        private long[] _gbCols;
        private AGG[] _agg;

        GBTask(long[] gbCols, AGG[] agg) {
            this._gbCols = gbCols;
            this._agg = agg;
        }

        @Override
        public void setupLocal() {
            this._g = new IcedHashMap();
        }

        @Override
        public void map(Chunk[] c) {
            long start = c[0].start();
            G g = new G(this._gbCols.length, this._agg);
            for (int i = 0; i < c[0]._len; ++i) {
                G gOld;
                g.fill(i, c, this._gbCols);
                String g_old = this._g.putIfAbsent(g, "");
                if (g_old == null) {
                    gOld = g;
                    g = new G(this._gbCols.length, this._agg);
                } else {
                    gOld = this._g.getk(g);
                }
                long r = gOld._N;
                while (!G.CAS_N(gOld, r, r + 1L)) {
                    r = gOld._N;
                }
                GBTask.perRow(this._agg, i, start, c, gOld);
            }
        }

        @Override
        public void reduce(GBTask t) {
            if (this._g != t._g) {
                IcedHashMap<G, String> l = this._g;
                IcedHashMap<G, String> r = t._g;
                if (l.size() < r.size()) {
                    l = r;
                    r = this._g;
                }
                for (G rg : r.keySet()) {
                    G lg = l.getk(rg);
                    if (l.putIfAbsent(rg, "") == null) continue;
                    assert (lg != null);
                    long R = lg._N;
                    while (!G.CAS_N(lg, R, R + rg._N)) {
                        R = lg._N;
                    }
                    GBTask.reduceGroup(this._agg, lg, rg);
                }
                this._g = l;
                t._g = null;
            }
        }

        private static void perRow(AGG[] agg, int chkRow, long rowOffset, Chunk[] c, G g) {
            GBTask.perRow(agg, chkRow, rowOffset, c, g, null);
        }

        private static void reduceGroup(AGG[] agg, G g, G that) {
            GBTask.perRow(agg, -1, -1L, null, g, that);
        }

        private static void perRow(AGG[] agg, int chkRow, long rowOffset, Chunk[] c, G g, G that) {
            block10: for (int i = 0; i < agg.length; ++i) {
                byte type;
                int col = agg[i]._c;
                if (c != null) {
                    if (c[col].isNA(chkRow)) {
                        GBTask.setNA(g, 1L, i);
                    }
                } else {
                    GBTask.setNA(g, that._NA[i], i);
                }
                if ((type = agg[i]._type) == 0 || c != null && !agg[i].isAll() && c[col].isNA(chkRow)) continue;
                long bits = -1L;
                int domLvl = -1;
                if (c != null) {
                    if (c[col].isNA(chkRow)) continue;
                    bits = Double.doubleToRawLongBits(c[col].atd(chkRow));
                    if (c[col].vec().isEnum()) {
                        domLvl = (int)c[col].at8(chkRow);
                    }
                }
                if (type == 1) continue;
                switch (type) {
                    case 6: 
                    case 9: {
                        GBTask.setSum(g, c == null ? Double.doubleToRawLongBits(that._sum[i]) : bits, i);
                        continue block10;
                    }
                    case 4: {
                        GBTask.setMin(g, c == null ? Double.doubleToRawLongBits(that._min[i]) : bits, i);
                        continue block10;
                    }
                    case 5: {
                        GBTask.setMax(g, c == null ? Double.doubleToRawLongBits(that._max[i]) : bits, i);
                        continue block10;
                    }
                    case 7: 
                    case 8: {
                        GBTask.setSum(g, c == null ? Double.doubleToRawLongBits(that._sum[i]) : bits, i);
                    }
                    case 10: {
                        GBTask.setSS(g, c == null ? Double.doubleToRawLongBits(that._ss[i]) : bits, i, c == null);
                        continue block10;
                    }
                    case 2: {
                        GBTask.setFirst(g, c == null ? that._f[i] : (long)chkRow + rowOffset, i);
                        continue block10;
                    }
                    case 3: {
                        GBTask.setLast(g, c == null ? that._l[i] : (long)chkRow + rowOffset, i);
                        continue block10;
                    }
                    case 11: {
                        GBTask.setMode(g, c == null ? that._m[i] : null, domLvl, i);
                        continue block10;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported aggregation type: " + type);
                    }
                }
            }
        }

        private static void setMode(G g, long[] arr, int lvl, int c) {
            if (arr == null && lvl == -1) {
                throw new IllegalArgumentException("Trying to compute mode on a non-categorical column.");
            }
            if (arr == null) {
                long o = g._m[c][lvl];
                while (!G.CAS_m(g, c, lvl, o, o + 1L)) {
                    o = g._m[c][lvl];
                }
            } else {
                for (int l = 0; l < g._m[c].length; ++l) {
                    long o = g._m[c][l];
                    while (!G.CAS_m(g, c, l, o, o + arr[l])) {
                        o = g._m[c][l];
                    }
                }
            }
        }

        private static void setFirst(G g, long v, int c) {
            long o = g._f[c];
            while (v < o && !G.CAS_f(g, G.longRawIdx(c), o, v)) {
                o = g._f[c];
            }
        }

        private static void setLast(G g, long v, int c) {
            long o = g._l[c];
            while (v > o && !G.CAS_l(g, G.longRawIdx(c), o, v)) {
                o = g._l[c];
            }
        }

        private static void setMin(G g, long v, int c) {
            double o = g._min[c];
            double vv = Double.longBitsToDouble(v);
            while (vv < o && !G.CAS_min(g, G.doubleRawIdx(c), Double.doubleToRawLongBits(o), v)) {
                o = g._min[c];
            }
        }

        private static void setMax(G g, long v, int c) {
            double o = g._max[c];
            double vv = Double.longBitsToDouble(v);
            while (vv > o && !G.CAS_max(g, G.doubleRawIdx(c), Double.doubleToRawLongBits(o), v)) {
                o = g._max[c];
            }
        }

        private static void setSum(G g, long vv, int c) {
            double v = Double.longBitsToDouble(vv);
            double o = g._sum[c];
            while (!G.CAS_sum(g, G.doubleRawIdx(c), Double.doubleToRawLongBits(o), Double.doubleToRawLongBits(o + v))) {
                o = g._sum[c];
            }
        }

        private static void setSS(G g, long vv, int c, boolean isReduce) {
            double v = Double.longBitsToDouble(vv);
            double o = g._ss[c];
            if (isReduce) {
                while (!G.CAS_ss(g, G.doubleRawIdx(c), Double.doubleToRawLongBits(o), Double.doubleToRawLongBits(o + v))) {
                    o = g._ss[c];
                }
            } else {
                while (!G.CAS_ss(g, G.doubleRawIdx(c), Double.doubleToRawLongBits(o), Double.doubleToRawLongBits(o + v * v))) {
                    o = g._ss[c];
                }
            }
        }

        private static void setNA(G g, long n, int c) {
            long o = g._NA[c];
            while (!G.CAS_NA(g, G.longRawIdx(c), o, o + n)) {
                o = g._NA[c];
            }
        }
    }

    public static class IcedNBHS<T extends Iced>
    extends Iced
    implements Iterable<T> {
        NonBlockingHashSet<T> _g = new NonBlockingHashSet();

        IcedNBHS() {
        }

        boolean add(T t) {
            return this._g.add(t);
        }

        boolean addAll(Collection<? extends T> c) {
            return this._g.addAll(c);
        }

        T get(T g) {
            return (T)((Iced)this._g.get(g));
        }

        int size() {
            return this._g.size();
        }

        @Override
        public AutoBuffer write_impl(AutoBuffer ab) {
            if (this._g == null) {
                return ab.put4(0);
            }
            ab.put4(this._g.size());
            for (Iced g : this._g) {
                ab.put(g);
            }
            return ab;
        }

        @Override
        public IcedNBHS read_impl(AutoBuffer ab) {
            int len = ab.get4();
            if (len == 0) {
                return this;
            }
            this._g = new NonBlockingHashSet();
            for (int i = 0; i < len; ++i) {
                this._g.add((Iced)ab.get());
            }
            return this;
        }

        @Override
        public Iterator<T> iterator() {
            return this._g.iterator();
        }
    }
}

