/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import water.rapids.AST;
import water.rapids.Env;
import water.rapids.Exec;
import water.rapids.ValId;

class ASTId
extends AST {
    final String _id;
    final char _type;

    @Override
    String opStr() {
        switch (this._type) {
            case '$': {
                return "$";
            }
            case '!': {
                return "!";
            }
            case '&': {
                return "&";
            }
        }
        throw new IllegalArgumentException("No such type for ID: " + this._type);
    }

    ASTId(char type, String id) {
        this._type = type;
        this._id = id;
    }

    @Override
    AST parse_impl(Exec E) {
        String id = E.isQuoted(E.peek()) ? E.parseString(E.getQuote()) : E.parseID();
        AST ast = Env.staticLookup(new ASTId(this._type, id));
        return ast;
    }

    public String toString() {
        return this._type + this._id;
    }

    @Override
    void exec(Env e) {
        e.push(new ValId(this._type, this._id));
    }

    @Override
    int type() {
        return 0;
    }

    @Override
    String value() {
        return this._id;
    }

    boolean isLocalSet() {
        return this._type == '&';
    }

    boolean isGlobalSet() {
        return this._type == '!';
    }

    boolean isLookup() {
        return this._type == '%';
    }

    boolean isValid() {
        return this.isLocalSet() || this.isGlobalSet() || this.isLookup();
    }

    @Override
    ASTId make() {
        return new ASTId(this._type, "");
    }
}

