/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import water.DKV;
import water.Key;
import water.MRTask;
import water.exceptions.H2OIllegalArgumentException;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.parser.ValueString;
import water.rapids.AST;
import water.rapids.ASTFrame;
import water.rapids.ASTId;
import water.rapids.ASTNum;
import water.rapids.ASTOp;
import water.rapids.ASTUniPrefixOp;
import water.rapids.Env;
import water.rapids.Exec;
import water.util.Log;

class ASTIfElse
extends ASTUniPrefixOp {
    static final String[] VARS = new String[]{"ifelse", "tst", "true", "false"};

    ASTIfElse() {
        super(VARS);
    }

    @Override
    ASTOp make() {
        return new ASTIfElse();
    }

    @Override
    String opStr() {
        return "ifelse";
    }

    @Override
    ASTIfElse parse_impl(Exec E) {
        AST tst = E.parse();
        if (tst instanceof ASTId) {
            try {
                double d = ((ASTNum)E._env.lookup((ASTId)((ASTId)tst)))._d;
                if (d == 0.0 || d == 1.0) {
                    tst = new ASTFrame(new Frame(Key.make(), null, new Vec[]{Vec.makeCon(d, 1L)}));
                }
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("`test` must be a frame or TRUE/FALSE");
            }
        }
        AST yes = E.parse();
        AST no = E.parse();
        E.eatEnd();
        ASTIfElse res = (ASTIfElse)this.clone();
        res._asts = new AST[]{no, yes, tst};
        return res;
    }

    private Frame adaptToTst(Frame src, Frame tgt) {
        Frame ret;
        Key k;
        Key key = k = src._key == null ? Key.make() : src._key;
        if (src._key == null || DKV.get(src._key) == null) {
            DKV.put(k, new Frame(k, src.names(), src.vecs()));
        }
        StringBuilder sb = null;
        if (src.numRows() < tgt.numRows()) {
            int nrbins = 1 + (int)((tgt.numRows() - src.numRows()) / src.numRows());
            long remainder = tgt.numRows() % src.numRows();
            sb = new StringBuilder("(rbind ");
            for (int i = 0; i < nrbins; ++i) {
                sb.append("%").append(k).append(i == nrbins - 1 && remainder < 0L ? "" : " ");
            }
            sb.append(remainder > 0L ? "([ %" + k + " (: #0 #" + (remainder - 1L) + ") \"null\"))" : ")");
            Log.info("extending frame:" + sb.toString());
        } else if (src.numRows() > tgt.numRows()) {
            long rmax = tgt.numRows() - 1L;
            sb = new StringBuilder("([ %" + k + " (: #0 #" + rmax + "))");
        }
        if (sb != null) {
            Frame res;
            Env env = null;
            try {
                env = Exec.exec(sb.toString());
                res = env.popAry();
                res.unlock_all();
            }
            catch (Exception e) {
                throw new H2OIllegalArgumentException("Bad expression Rapids: " + sb.toString(), "Bad expression Rapids: " + sb.toString() + "; exception: " + e.toString());
            }
            finally {
                if (env != null) {
                    env.unlock();
                }
            }
            return tgt.makeCompatible(res);
        }
        src = (Frame)DKV.remove(k).get();
        if (src != (ret = tgt.makeCompatible(src))) {
            src.delete();
        }
        return ret;
    }

    private Frame adaptToTst(double d, Frame tgt) {
        Frame v = new Frame(Vec.makeCon(d, tgt.numRows()));
        Frame ret = tgt.makeCompatible(v);
        if (ret != v) {
            v.delete();
        }
        return ret;
    }

    @Override
    void apply(Env env) {
        Frame fr2;
        Frame tst;
        if (env.isNum()) {
            tst = new Frame(new String[]{"tst"}, new Vec[]{Vec.makeCon(env.popDbl(), 1L)});
        } else {
            if (!env.isAry()) {
                throw new IllegalArgumentException("`test` argument must be a frame: ifelse(`test`, `yes`, `no`)");
            }
            tst = env.popAry();
        }
        if (tst.numCols() != 1) {
            throw new IllegalArgumentException("`test` has " + tst.numCols() + " columns. `test` must have exactly 1 column.");
        }
        Frame yes = null;
        double dyes = 0.0;
        Frame no = null;
        double dno = 0.0;
        if (env.isAry()) {
            yes = env.popAry();
        } else {
            dyes = env.popDbl();
        }
        if (env.isAry()) {
            no = env.popAry();
        } else {
            dno = env.popDbl();
        }
        if (yes != null && no != null) {
            if (!(yes.numCols() == no.numCols() || yes.numCols() == 1 && no.numCols() != 1 || yes.numCols() != 1 && no.numCols() == 1)) {
                throw new IllegalArgumentException("Column mismatch between `yes` and `no`. `yes` has " + yes.numCols() + " columns; `no` has " + no.numCols() + " columns.");
            }
        } else if (yes != null) {
            if (yes.numCols() != 1) {
                throw new IllegalArgumentException("Column mismatch between `yes` and `no`. `yes` has " + yes.numCols() + " columns; `no` has " + 1 + " columns.");
            }
        } else if (no != null && no.numCols() != 1) {
            throw new IllegalArgumentException("Column mismatch between `yes` and `no`. `yes` has 1; `no` has " + no.numCols() + ".");
        }
        if (tst.numRows() == 1L && tst.numCols() == 1) {
            fr2 = tst.anyVec().at(0L) != 0.0 ? new Frame(new String[]{"C1"}, new Vec[]{Vec.makeCon(yes == null ? dyes : yes.vecs()[0].at(0L), 1L)}) : new Frame(new String[]{"C1"}, new Vec[]{Vec.makeCon(no == null ? dno : no.vecs()[0].at(0L), 1L)});
        } else {
            String[] stringArray;
            Frame a_yes = yes == null ? this.adaptToTst(dyes, tst) : this.adaptToTst(yes, tst);
            Frame a_no = no == null ? this.adaptToTst(dno, tst) : this.adaptToTst(no, tst);
            Frame frtst = new Frame(tst).add(a_yes).add(a_no);
            final int ycols = a_yes.numCols();
            Object t = new MRTask(){

                @Override
                public void map(Chunk[] chks, NewChunk[] nchks) {
                    int rows = chks[0]._len;
                    int cols = chks.length;
                    Chunk pred = chks[0];
                    for (int r = 0; r < rows; ++r) {
                        int col = 0;
                        for (int c = pred.atd(r) != 0.0 ? 1 : ycols + 1; c < (pred.atd(r) != 0.0 ? ycols + 1 : cols); ++c) {
                            if (chks[c].vec().isUUID()) {
                                nchks[col++].addUUID(chks[c], r);
                                continue;
                            }
                            if (chks[c].vec().isString()) {
                                nchks[col++].addStr(chks[c].atStr(new ValueString(), r));
                                continue;
                            }
                            nchks[col++].addNum(chks[c].atd(r));
                        }
                    }
                }
            }.doAll(yes == null ? 1 : yes.numCols(), frtst);
            if (yes == null) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "C1";
            } else {
                stringArray = yes.names();
            }
            fr2 = ((MRTask)t).outputFrame(stringArray, null);
        }
        env.pushAry(fr2);
    }
}

