/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import hex.quantile.QuantileModel;
import sun.misc.Unsafe;
import water.H2O;
import water.MRTask;
import water.MemoryManager;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.nbhm.UtilUnsafe;
import water.rapids.AST;
import water.rapids.ASTGroupBy;
import water.rapids.ASTId;
import water.rapids.ASTLongList;
import water.rapids.ASTMedian;
import water.rapids.ASTNum;
import water.rapids.ASTOp;
import water.rapids.ASTUniPrefixOp;
import water.rapids.ASTVar;
import water.rapids.Env;
import water.rapids.Exec;
import water.rapids.ValFrame;
import water.util.Log;

class ASTImpute
extends ASTUniPrefixOp {
    ImputeMethod _method;
    long[] _by;
    int _colIdx;
    boolean _inplace;
    int _maxGap;
    QuantileModel.CombineMethod _combine_method;

    @Override
    String opStr() {
        return "h2o.impute";
    }

    @Override
    ASTOp make() {
        return new ASTImpute();
    }

    public ASTImpute() {
        super(new String[]{"vec", "method", "combine_method", "by", "inplace"});
    }

    @Override
    ASTImpute parse_impl(Exec E) {
        AST ary = E.parse();
        this._colIdx = (int)E.nextDbl();
        this._method = ImputeMethod.valueOf(E.nextStr().toUpperCase());
        this._combine_method = QuantileModel.CombineMethod.valueOf(E.nextStr().toUpperCase());
        AST a = E.parse();
        this._by = a instanceof ASTLongList ? ((ASTLongList)a)._l : (long[])(a instanceof ASTNum ? new long[]{(long)((ASTNum)a)._d} : null);
        a = E.parse();
        if (a instanceof ASTId) {
            this._inplace = ((ASTNum)E._env.lookup((ASTId)((ASTId)a)))._d == 1.0;
        }
        E.eatEnd();
        ASTImpute res = (ASTImpute)this.clone();
        res._asts = new AST[]{ary};
        res._by = this._by;
        res._method = this._method;
        return res;
    }

    @Override
    public void apply(Env e) {
        Frame f2;
        Frame f = e.popAry();
        Vec v = f.vecs()[this._colIdx];
        if (this._by == null) {
            double imputeValue;
            if (!v.isNumeric() && this._method != ImputeMethod.MODE) {
                Log.info("Can only impute non-numeric columns with the mode.");
                this._method = ImputeMethod.MODE;
            }
            switch (this._method) {
                case MEAN: {
                    imputeValue = ASTVar.getMean(v, true, "");
                    break;
                }
                case MEDIAN: {
                    imputeValue = ASTMedian.median(v, this._combine_method);
                    break;
                }
                case MODE: {
                    imputeValue = this.mode(v);
                    break;
                }
                default: {
                    throw H2O.unimpl("Unknown type: " + (Object)((Object)this._method));
                }
            }
            if (this._inplace) {
                new MRTask(){

                    @Override
                    public void map(Chunk c) {
                        for (int i = 0; i < c._len; ++i) {
                            if (!c.isNA(i)) continue;
                            c.set(i, imputeValue);
                        }
                    }
                }.doAll(v);
                f2 = f;
            } else {
                f2 = ((MRTask)new MRTask(){

                    @Override
                    public void map(Chunk c, NewChunk n) {
                        for (int i = 0; i < c._len; ++i) {
                            n.addNum(c.isNA(i) ? imputeValue : c.atd(i));
                        }
                    }
                }.doAll(1, v)).outputFrame(null, new String[]{f.names()[this._colIdx]}, new String[][]{f.domains()[this._colIdx]});
            }
        } else {
            if (this._method == ImputeMethod.MEDIAN) {
                throw H2O.unimpl("Currently cannot impute with the median over groups. Try mean.");
            }
            ASTGroupBy.AGG[] agg = new ASTGroupBy.AGG[]{new ASTGroupBy.AGG("mean", this._colIdx, "rm", "_avg", null, null)};
            ASTGroupBy.GBTask t = (ASTGroupBy.GBTask)new ASTGroupBy.GBTask(this._by, agg).doAll(f);
            final ASTGroupBy.IcedNBHS s = new ASTGroupBy.IcedNBHS();
            s.addAll(t._g.keySet());
            int nGrps = t._g.size();
            ASTGroupBy.G[] grps = t._g.keySet().toArray(new ASTGroupBy.G[nGrps]);
            H2O.submitTask(new ASTGroupBy.ParallelPostGlobal(grps, nGrps, null)).join();
            final long[] cols = this._by;
            final int colIdx = this._colIdx;
            if (this._inplace) {
                new MRTask(){
                    transient ASTGroupBy.IcedNBHS<ASTGroupBy.G> _s;

                    @Override
                    public void setupLocal() {
                        this._s = s;
                    }

                    @Override
                    public void map(Chunk[] c) {
                        ASTGroupBy.G g = new ASTGroupBy.G(cols.length);
                        Chunk ch = c[colIdx];
                        for (int i = 0; i < c[0]._len; ++i) {
                            g.fill(i, c, cols);
                            double impute_value = this._s.get((ASTGroupBy.G)g)._avs[0];
                            if (!ch.isNA(i)) continue;
                            ch.set(i, impute_value);
                        }
                    }
                }.doAll(f);
                f2 = f;
            } else {
                f2 = ((MRTask)new MRTask(){
                    transient ASTGroupBy.IcedNBHS<ASTGroupBy.G> _s;

                    @Override
                    public void setupLocal() {
                        this._s = s;
                    }

                    @Override
                    public void map(Chunk[] c, NewChunk n) {
                        ASTGroupBy.G g = new ASTGroupBy.G(cols.length);
                        Chunk ch = c[colIdx];
                        for (int i = 0; i < c[0]._len; ++i) {
                            g.fill(i, c, cols);
                            double impute_value = this._s.get((ASTGroupBy.G)g)._avs[0];
                            n.addNum(ch.isNA(i) ? impute_value : ch.atd(i));
                        }
                    }
                }.doAll(1, f)).outputFrame(null, new String[]{f.names()[this._colIdx]}, new String[][]{f.domains()[this._colIdx]});
            }
        }
        e.push(new ValFrame(f2));
    }

    private double mode(Vec v) {
        return ((ModeTask)new ModeTask((int)((int)v.max())).doAll((Vec[])new Vec[]{v}))._max;
    }

    private static class ModeTask
    extends MRTask<ModeTask> {
        int _m;
        long _max;
        long[] _cnts;
        private static final long _maxOffset;
        private static final Unsafe U;
        private static final int _b;
        private static final int _s;

        private static long ssid(int i) {
            return _b + _s * i;
        }

        ModeTask(int m) {
            this._m = m;
        }

        @Override
        public void setupLocal() {
            this._cnts = MemoryManager.malloc8(this._m + 1);
            this._max = Integer.MIN_VALUE;
        }

        @Override
        public void map(Chunk c) {
            for (int i = 0; i < c._len; ++i) {
                if (c.isNA(i)) continue;
                int h = (int)c.at8(i);
                long offset = ModeTask.ssid(h);
                long cnt = this._cnts[h];
                while (!U.compareAndSwapLong(this._cnts, offset, cnt, cnt + 1L)) {
                    cnt = this._cnts[h];
                }
            }
        }

        @Override
        public void postGlobal() {
            int maxIdx = 0;
            assert (this._cnts != null);
            for (int i = 0; i < this._cnts.length; ++i) {
                if (this._cnts[i] <= this._max) continue;
                this._max = this._cnts[i];
                maxIdx = i;
            }
            this._max = maxIdx;
        }

        static {
            U = UtilUnsafe.getUnsafe();
            _b = U.arrayBaseOffset(long[].class);
            _s = U.arrayIndexScale(long[].class);
            try {
                _maxOffset = U.objectFieldOffset(ModeTask.class.getDeclaredField("_max"));
            }
            catch (Exception e) {
                throw new RuntimeException("golly mistah, I crashed :(!");
            }
        }
    }

    private static enum ImputeMethod {
        MEAN,
        MEDIAN,
        MODE;

    }
}

