/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.rapids.AST;
import water.rapids.ASTOp;
import water.rapids.ASTUniPrefixOp;
import water.rapids.Env;
import water.rapids.Exec;
import water.rapids.ValNum;
import water.util.ArrayUtils;

class ASTKappa
extends ASTUniPrefixOp {
    int _nclass;

    @Override
    String opStr() {
        return "kappa";
    }

    @Override
    ASTOp make() {
        return new ASTKappa();
    }

    public ASTKappa() {
        super(new String[]{"actual", "pred", "nclass"});
    }

    @Override
    ASTKappa parse_impl(Exec E) {
        AST act = E.parse();
        AST pre = E.parse();
        this._nclass = (int)E.nextDbl();
        E.eatEnd();
        ASTKappa res = (ASTKappa)this.clone();
        res._asts = new AST[]{act, pre};
        return res;
    }

    @Override
    public void apply(Env e) {
        Frame act = e.popAry();
        Frame pre = e.popAry();
        OMatrixTask t = (OMatrixTask)new OMatrixTask(this._nclass).doAll(act.add(pre));
        int[][] O2 = t._O;
        double numerator = 0.0;
        double denominator = 0.0;
        for (int i = 0; i < this._nclass; ++i) {
            for (int j = 0; j < this._nclass; ++j) {
                double w_ij = (double)((i - j) * (i - j)) / (double)((this._nclass - 1) * (this._nclass - 1));
                double e_ij = (double)(t._aHist[i] * t._pHist[j]) / (double)act.numRows();
                numerator += w_ij * (double)O2[i][j];
                denominator += w_ij * e_ij;
            }
        }
        e.push(new ValNum(1.0 - numerator / denominator));
    }

    private static class OMatrixTask
    extends MRTask<OMatrixTask> {
        final int _n;
        int[][] _O;
        int[] _aHist;
        int[] _pHist;

        OMatrixTask(int n) {
            this._n = n;
        }

        @Override
        public void map(Chunk[] cs) {
            this._O = new int[this._n][this._n];
            this._aHist = new int[this._n];
            this._pHist = new int[this._n];
            for (int i = 0; i < cs[0]._len; ++i) {
                int x = (int)cs[0].at8(i);
                int y = (int)cs[1].at8(i);
                int n = x;
                this._aHist[n] = this._aHist[n] + 1;
                int n2 = y;
                this._pHist[n2] = this._pHist[n2] + 1;
                int[] nArray = this._O[x];
                int n3 = y;
                nArray[n3] = nArray[n3] + 1;
            }
        }

        @Override
        public void reduce(OMatrixTask t) {
            this._O = ArrayUtils.add(this._O, t._O);
            this._aHist = ArrayUtils.add(this._aHist, t._aHist);
            this._pHist = ArrayUtils.add(this._pHist, t._pHist);
            t._O = null;
        }
    }
}

