/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import water.H2O;
import water.Key;
import water.TypeMap;
import water.Value;
import water.fvec.Chunk;
import water.rapids.AST;
import water.rapids.ASTOp;
import water.rapids.ASTUniPrefixOp;
import water.rapids.Env;
import water.rapids.Exec;
import water.rapids.ValStr;

class ASTKeysLeaked
extends ASTUniPrefixOp {
    ASTKeysLeaked() {
        super(new String[]{"numkeys"});
    }

    @Override
    String opStr() {
        return "keys_leaked";
    }

    @Override
    ASTOp make() {
        return new ASTKeysLeaked();
    }

    @Override
    ASTKeysLeaked parse_impl(Exec E) {
        AST a = E.parse();
        E.eatEnd();
        ASTKeysLeaked res = (ASTKeysLeaked)this.clone();
        res._asts = new AST[]{a};
        return res;
    }

    @Override
    void apply(Env e) {
        int numKeys = (int)e.popDbl();
        int leaked_keys = H2O.store_size() - numKeys;
        if (leaked_keys > 0) {
            int cnt = 0;
            for (Key k : H2O.localKeySet()) {
                Value value = H2O.raw_get(k);
                if (!(value.isFrame() || value.isVec() || value.get() instanceof Chunk)) {
                    --leaked_keys;
                    continue;
                }
                if (cnt++ >= 10) continue;
                System.err.println("Leaked key: " + k + " = " + TypeMap.className(value.type()));
            }
            if (10 < leaked_keys) {
                System.err.println("... and " + (leaked_keys - 10) + " more leaked keys");
            }
        }
        e.push(new ValStr(leaked_keys <= 0 ? "FALSE" : "TRUE"));
    }
}

