/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import water.DKV;
import water.Futures;
import water.Key;
import water.fvec.AppendableVec;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.rapids.ASTOp;
import water.rapids.ASTUniPrefixOp;
import water.rapids.Env;

class ASTLevels
extends ASTUniPrefixOp {
    ASTLevels() {
        super(VARS1);
    }

    @Override
    String opStr() {
        return "levels";
    }

    @Override
    ASTOp make() {
        return new ASTLevels();
    }

    @Override
    void apply(Env e) {
        int i;
        Frame f = e.popAry();
        Futures fs = new Futures();
        Key<Vec>[] keys = Vec.VectorGroup.VG_LEN1.addVecs(f.numCols());
        Vec[] vecs = new Vec[keys.length];
        int max = 0;
        for (i = 0; i < f.numCols(); ++i) {
            if (!f.vec(i).isEnum() || max >= f.vec(i).domain().length) continue;
            max = f.vec(i).domain().length;
        }
        for (i = 0; i < f.numCols(); ++i) {
            int j;
            int numToPad;
            AppendableVec v = new AppendableVec((Key)keys[i]);
            NewChunk nc = new NewChunk(v, 0);
            String[] dom = f.vec(i).domain();
            int n = numToPad = dom == null ? max : max - dom.length;
            if (dom != null) {
                for (j = 0; j < dom.length; ++j) {
                    nc.addNum(j);
                }
            }
            for (j = 0; j < numToPad; ++j) {
                nc.addNA();
            }
            nc.close(0, fs);
            vecs[i] = v.close(fs);
            vecs[i].setDomain(dom);
        }
        fs.blockForPending();
        Frame fr2 = new Frame(Key.make(), null, vecs);
        DKV.put(fr2);
        e.pushAry(fr2);
    }
}

