/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.rapids.AST;
import water.rapids.ASTDoubleList;
import water.rapids.ASTLongList;
import water.rapids.ASTNum;
import water.rapids.ASTUniPrefixOp;
import water.rapids.Env;
import water.rapids.Exec;

class ASTMajorityVote
extends ASTUniPrefixOp {
    int _n;
    double[] _weights;

    ASTMajorityVote() {
        super(null);
    }

    @Override
    String opStr() {
        return "h2o.vote";
    }

    @Override
    ASTMajorityVote make() {
        return new ASTMajorityVote();
    }

    @Override
    ASTMajorityVote parse_impl(Exec E) {
        AST condition = E.parse();
        this._n = (int)E.nextDbl();
        AST a = E.parse();
        if (a instanceof ASTNum) {
            this._weights = new double[]{((ASTNum)a)._d};
        } else if (a instanceof ASTLongList) {
            long[] l = ((ASTLongList)a)._l;
            this._weights = new double[l.length];
            for (int i = 0; i < l.length; ++i) {
                this._weights[i] = l[i];
            }
        } else {
            this._weights = ((ASTDoubleList)a)._d;
        }
        ASTMajorityVote res = (ASTMajorityVote)this.clone();
        res._asts = new AST[]{condition};
        return res;
    }

    @Override
    public void apply(Env e) {
        Frame f = e.popAry();
        final int n = this._n;
        final double[] weights = this._weights;
        Frame f2 = ((MRTask)new MRTask(){

            @Override
            public void map(Chunk[] c, NewChunk nc) {
                double[] votes = new double[n + 1];
                for (int row = 0; row < c[0]._len; ++row) {
                    int i;
                    for (i = 0; i < votes.length; ++i) {
                        votes[i] = 0.0;
                    }
                    for (int col = 0; col < c.length; ++col) {
                        int n2 = (int)c[col].at8(row);
                        votes[n2] = votes[n2] + weights[col];
                    }
                    i = 0;
                    double max = votes[i];
                    for (int iter2 = 0; iter2 < votes.length; ++iter2) {
                        if (!(votes[iter2] > max)) continue;
                        max = votes[i];
                        i = iter2;
                    }
                    nc.addNum(i);
                }
            }
        }.doAll(1, f)).outputFrame();
        e.pushAry(f2);
    }
}

