/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import java.util.Arrays;
import water.Key;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.rapids.AST;
import water.rapids.ASTDoubleList;
import water.rapids.ASTNum;
import water.rapids.ASTOp;
import water.rapids.ASTString;
import water.rapids.ASTStringList;
import water.rapids.ASTUniPrefixOp;
import water.rapids.Env;
import water.rapids.Exec;
import water.util.MathUtils;

class ASTMatch
extends ASTUniPrefixOp {
    double _nomatch;
    String[] _strsTable;
    double[] _dblsTable;

    @Override
    String opStr() {
        return "match";
    }

    ASTMatch() {
        super(new String[]{"", "ary", "table", "nomatch", "incomparables"});
    }

    @Override
    ASTOp make() {
        return new ASTMatch();
    }

    @Override
    ASTMatch parse_impl(Exec E) {
        AST ary = E.parse();
        AST a = E.parse();
        if (a instanceof ASTString) {
            this._strsTable = new String[]{((ASTString)a)._s};
        } else if (a instanceof ASTStringList) {
            this._strsTable = ((ASTStringList)a)._s;
        } else if (a instanceof ASTNum) {
            this._dblsTable = new double[]{((ASTNum)a)._d};
        } else if (a instanceof ASTDoubleList) {
            this._dblsTable = ((ASTDoubleList)a)._d;
        } else {
            throw new IllegalArgumentException("`table` expected to be either a String or an slist. Got: " + a.getClass());
        }
        if (this._strsTable != null) {
            Arrays.sort(this._strsTable);
        } else {
            Arrays.sort(this._dblsTable);
        }
        AST nm = E.parse();
        if (!(nm instanceof ASTNum)) {
            throw new IllegalArgumentException("Argument `nomatch` expected a number. Got: " + nm.getClass());
        }
        this._nomatch = ((ASTNum)nm)._d;
        AST incomp = E.parse();
        E.eatEnd();
        ASTMatch res = (ASTMatch)this.clone();
        res._asts = new AST[]{ary};
        return res;
    }

    @Override
    void apply(Env e) {
        Frame fr = e.popAry();
        if (fr.numCols() != 1 && !fr.anyVec().isEnum()) {
            throw new IllegalArgumentException("can only match on a single categorical column.");
        }
        Key tmp = Key.make();
        final String[] strsTable = this._strsTable;
        final double[] dblsTable = this._dblsTable;
        Frame rez = ((MRTask)new MRTask(){

            @Override
            public void map(Chunk c, NewChunk n) {
                int rows = c._len;
                if (strsTable == null) {
                    for (int r = 0; r < rows; ++r) {
                        n.addNum(c.isNA(r) ? 0L : (long)ASTMatch.in(dblsTable, c.atd(r)), 0);
                    }
                } else {
                    for (int r = 0; r < rows; ++r) {
                        n.addNum(c.isNA(r) ? 0L : (long)ASTMatch.in(strsTable, c.vec().domain()[(int)c.at8(r)]), 0);
                    }
                }
            }
        }.doAll(1, fr.anyVec())).outputFrame(tmp, null, null);
        e.pushAry(rez);
    }

    private static int in(String[] matches, String s) {
        return Arrays.binarySearch(matches, s) >= 0 ? 1 : 0;
    }

    private static int in(double[] matches, double d) {
        return ASTMatch.binarySearchDoublesUlp(matches, 0, matches.length, d) >= 0 ? 1 : 0;
    }

    private static int binarySearchDoublesUlp(double[] a, int from, int to, double key) {
        int lo = from;
        int hi = to - 1;
        while (lo <= hi) {
            long keyBits;
            int mid = lo + hi >>> 1;
            double midVal = a[mid];
            if (MathUtils.equalsWithinOneSmallUlp(midVal, key)) {
                return mid;
            }
            if (midVal < key) {
                lo = mid + 1;
                continue;
            }
            if (midVal > key) {
                hi = mid - 1;
                continue;
            }
            long midBits = Double.doubleToLongBits(midVal);
            if (midBits == (keyBits = Double.doubleToLongBits(key))) {
                return mid;
            }
            if (midBits < keyBits) {
                lo = mid + 1;
                continue;
            }
            hi = mid - 1;
        }
        return -(lo + 1);
    }
}

