/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import water.fvec.Frame;
import water.fvec.Vec;
import water.rapids.ASTOp;
import water.rapids.ASTReducerOp;
import water.rapids.Env;
import water.rapids.ValNum;

class ASTMax
extends ASTReducerOp {
    ASTMax() {
        super(Double.NEGATIVE_INFINITY);
    }

    @Override
    String opStr() {
        return "max";
    }

    @Override
    ASTOp make() {
        return new ASTMax();
    }

    @Override
    double op(double d0, double d1) {
        return Math.max(d0, d1);
    }

    @Override
    void apply(Env env) {
        double max = Double.NEGATIVE_INFINITY;
        int argcnt = env.sp();
        block0: for (int i = 0; i < argcnt; ++i) {
            if (env.isNum()) {
                max = Math.max(max, env.popDbl());
                continue;
            }
            Frame fr = env.popAry();
            for (Vec v : fr.vecs()) {
                if (!v.isEnum() && !v.isUUID() && !v.isString()) continue;
                throw new IllegalArgumentException("`" + this.opStr() + "`" + " only defined on a data frame with all numeric variables");
            }
            for (Vec v : fr.vecs()) {
                if (v.naCnt() > 0L && !this._narm) {
                    max = Double.NaN;
                    continue block0;
                }
                max = Math.max(max, v.max());
            }
        }
        env.push(new ValNum(max));
    }
}

