/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import hex.quantile.Quantile;
import hex.quantile.QuantileModel;
import water.DKV;
import water.H2O;
import water.Key;
import water.fvec.Frame;
import water.fvec.Vec;
import water.rapids.ASTOp;
import water.rapids.ASTReducerOp;
import water.rapids.Env;
import water.rapids.ValNum;

class ASTMedian
extends ASTReducerOp {
    ASTMedian() {
        super(0.0);
    }

    @Override
    String opStr() {
        return "median";
    }

    @Override
    ASTOp make() {
        return new ASTMedian();
    }

    @Override
    double op(double d0, double d1) {
        throw H2O.unimpl();
    }

    @Override
    void apply(Env env) {
        Frame fr = env.popAry();
        Key tk = null;
        if (fr._key == null) {
            tk = Key.make();
            fr = new Frame(tk, fr.names(), fr.vecs());
            DKV.put(tk, fr);
        }
        double median = ASTMedian.median(fr, QuantileModel.CombineMethod.INTERPOLATE);
        if (tk != null) {
            DKV.remove(tk);
        }
        env.push(new ValNum(median));
    }

    static double median(Frame fr, QuantileModel.CombineMethod combine_method) {
        if (fr.numCols() != 1) {
            throw new IllegalArgumentException("`median` expects a single numeric column from a Frame.");
        }
        if (!fr.anyVec().isNumeric()) {
            throw new IllegalArgumentException("`median` expects a single numeric column from a Frame.");
        }
        QuantileModel.QuantileParameters parms = new QuantileModel.QuantileParameters();
        parms._probs = new double[]{0.5};
        parms._train = fr._key;
        parms._combine_method = combine_method;
        QuantileModel q = (QuantileModel)new Quantile(parms).trainModel().get();
        double median = ((QuantileModel.QuantileOutput)q._output)._quantiles[0][0];
        q.delete();
        return median;
    }

    static double median(Vec v, QuantileModel.CombineMethod combine_method) {
        Frame f = new Frame(Key.make(), null, new Vec[]{v});
        DKV.put(f);
        double res = ASTMedian.median(f, combine_method);
        DKV.remove(f._key);
        return res;
    }
}

