/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import java.util.Arrays;
import water.DKV;
import water.H2O;
import water.Key;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.EnumWrappedVec;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.nbhm.NonBlockingHashMap;
import water.nbhm.NonBlockingHashSet;
import water.rapids.AST;
import water.rapids.ASTId;
import water.rapids.ASTNum;
import water.rapids.ASTOp;
import water.rapids.Env;
import water.rapids.Exec;
import water.rapids.ValFrame;

public class ASTMerge
extends ASTOp {
    static final String[] VARS = new String[]{"ary", "leftary", "rightary", "allleft", "allright"};
    boolean _allLeft;
    boolean _allRite;

    public ASTMerge() {
        super(VARS);
    }

    @Override
    String opStr() {
        return "merge";
    }

    @Override
    ASTOp make() {
        return new ASTMerge();
    }

    @Override
    ASTMerge parse_impl(Exec E) {
        AST left = E.parse();
        AST rite = E.parse();
        AST a = E.parse();
        if (a instanceof ASTId) {
            a = E._env.lookup((ASTId)a);
        }
        if (!(a instanceof ASTNum)) {
            throw new IllegalArgumentException("Argument `allLeft` expected to be a boolean.");
        }
        this._allLeft = ((ASTNum)a)._d == 1.0;
        a = E.parse();
        if (a instanceof ASTId) {
            a = E._env.lookup((ASTId)a);
        }
        if (!(a instanceof ASTNum)) {
            throw new IllegalArgumentException("Argument `allRite` expected to be a boolean.");
        }
        this._allRite = ((ASTNum)a)._d == 1.0;
        E.eatEnd();
        ASTMerge res = (ASTMerge)this.clone();
        res._asts = new AST[]{left, rite};
        return res;
    }

    @Override
    void exec(Env e, AST[] args) {
        throw H2O.fail();
    }

    @Override
    void apply(Env env) {
        int i;
        Frame _l = env.popAry();
        Frame _r = env.popAry();
        Frame l = new Frame((String[])_l.names().clone(), (Vec[])_l.vecs().clone());
        Frame r = new Frame((String[])_r.names().clone(), (Vec[])_r.vecs().clone());
        int ncols = 0;
        for (int i2 = 0; i2 < l._names.length; ++i2) {
            int idx = r.find(l._names[i2]);
            if (idx == -1) continue;
            l.swap(i2, ncols);
            r.swap(idx, ncols);
            Vec lv = l.vecs()[ncols];
            Vec rv = r.vecs()[ncols];
            if (lv.get_type() != rv.get_type()) {
                throw new IllegalArgumentException("Merging columns must be the same type, column " + l._names[ncols] + " found types " + lv.get_type_str() + " and " + rv.get_type_str());
            }
            if (lv.isString()) {
                throw new IllegalArgumentException("Cannot merge Strings; flip toEnum first");
            }
            if (lv.isNumeric() && !lv.isInt()) {
                throw new IllegalArgumentException("Equality tests on doubles rarely work, please round to integers only before merging");
            }
            ++ncols;
        }
        if (ncols == 0) {
            throw new IllegalArgumentException("Frames must have at least one column in common to merge them");
        }
        long lsize = 0L;
        long rsize = 0L;
        for (i = ncols; i < l.numCols(); ++i) {
            lsize += l.vecs()[i].byteSize();
        }
        for (i = ncols; i < r.numCols(); ++i) {
            rsize += r.vecs()[i].byteSize();
        }
        Frame small = lsize < rsize ? l : r;
        Frame large = lsize < rsize ? r : l;
        int[][] enum_maps = new int[ncols][];
        int[][] id_maps = new int[ncols][];
        for (int i3 = 0; i3 < ncols; ++i3) {
            Vec lv = large.vecs()[i3];
            if (!lv.isEnum()) continue;
            EnumWrappedVec ewv = new EnumWrappedVec(lv.domain(), small.vecs()[i3].domain());
            enum_maps[i3] = ewv.enum_map();
            int[] ids = enum_maps[i3];
            DKV.remove(ewv._key);
            id_maps[i3] = new int[ids.length];
            for (int j = 0; j < ids.length; ++j) {
                id_maps[i3][j] = j;
            }
        }
        Key uniq = ((MergeSet)new MergeSet((int)ncols, (int[][])id_maps, (Frame)small).doAllNodes())._uniq;
        String[] names = Arrays.copyOfRange(small._names, ncols, small._names.length);
        String[][] domains = (String[][])Arrays.copyOfRange(small.domains(), ncols, small.domains().length);
        Frame res = ((DoJoin)new DoJoin(ncols, uniq, enum_maps, this._allLeft).doAll(small.numCols() - ncols, large)).outputFrame(names, domains);
        Frame res2 = large.add(res);
        env.addRef(res);
        env.push(new ValFrame(res2));
    }

    private static class DoJoin
    extends MRTask<DoJoin> {
        private final int _ncols;
        private final Key _uniq;
        private final int[][] _enum_maps;
        private final boolean _allLeft;

        DoJoin(int ncols, Key uniq, int[][] enum_maps, boolean allLeft) {
            this._ncols = ncols;
            this._uniq = uniq;
            this._enum_maps = enum_maps;
            this._allLeft = allLeft;
        }

        @Override
        public void map(Chunk[] chks, NewChunk[] nchks) {
            NonBlockingHashSet<Row> rows = MergeSet.MERGE_SETS.get((Object)this._uniq)._rows;
            int len = chks[0]._len;
            Row row = new Row(chks);
            for (int i = 0; i < len; ++i) {
                Row smaller = rows.get(row.fill(i, this._ncols, this._enum_maps));
                if (smaller == null) {
                    for (NewChunk nc : nchks) {
                        nc.addNA();
                    }
                    continue;
                }
                assert (smaller._chks.length == this._ncols + nchks.length);
                for (int c = 0; c < nchks.length; ++c) {
                    nchks[c].addNum(smaller._chks[this._ncols + c].atd(smaller._row));
                }
            }
        }

        @Override
        public void closeLocal() {
            MergeSet.MERGE_SETS.remove(this._uniq);
        }
    }

    private static class MergeSet
    extends MRTask<MergeSet> {
        static NonBlockingHashMap<Key, MergeSet> MERGE_SETS = new NonBlockingHashMap();
        final Key _uniq = Key.make();
        final int _ncols;
        final int[][] _id_maps;
        final Frame _fr;
        transient NonBlockingHashSet<Row> _rows;

        MergeSet(int ncols, int[][] id_maps, Frame fr) {
            this._ncols = ncols;
            this._id_maps = id_maps;
            this._fr = fr;
        }

        @Override
        public void setupLocal() {
            MERGE_SETS.put(this._uniq, this);
            this._rows = new NonBlockingHashSet();
            new MakeHash(this).doAll(this._fr, true);
        }

        private static class MakeHash
        extends MRTask<MakeHash> {
            final transient MergeSet _ms;

            MakeHash(MergeSet ms) {
                this._ms = ms;
            }

            @Override
            public void map(Chunk[] chks) {
                int len = chks[0]._len;
                for (int i = 0; i < len; ++i) {
                    Row row = new Row(chks).fill(i, this._ms._ncols, this._ms._id_maps);
                    boolean added = this._ms._rows.add(row);
                    if (added) continue;
                    Row other = this._ms._rows.get(row);
                    throw H2O.unimpl();
                }
            }
        }
    }

    private static class Row {
        public final Chunk[] _chks;
        public int[][] _enum_maps;
        public int _row;
        public int _hash;

        Row(Chunk[] chks) {
            this._chks = chks;
        }

        Row fill(int row, int ncols, int[][] enum_maps) {
            this._row = row;
            this._enum_maps = enum_maps;
            long hash = 0L;
            for (int i = 0; i < ncols; ++i) {
                if (this._chks[i].isNA(this._row)) continue;
                long l = this._chks[i].at8(this._row);
                hash += enum_maps[i] == null ? l : (long)enum_maps[i][(int)l];
            }
            this._hash = (int)(hash ^ hash >> 32);
            return this;
        }

        public int hashCode() {
            return this._hash;
        }

        public boolean equals(Object o) {
            assert (o instanceof Row);
            Row r = (Row)o;
            if (this._hash != r._hash) {
                return false;
            }
            if (this._chks == r._chks && this._row == r._row) {
                return true;
            }
            int len = this._enum_maps.length;
            for (int c = 0; c < len; ++c) {
                boolean lb = this._chks[c].isNA(this._row);
                boolean rb = r._chks[c].isNA(r._row);
                if (lb && rb) continue;
                if (lb || rb) {
                    return false;
                }
                long ll = this._chks[c].at8(this._row);
                long rl = r._chks[c].at8(r._row);
                if (!(this._enum_maps[c] == null ? ll != rl : this._enum_maps[c][(int)ll] != r._enum_maps[c][(int)rl])) continue;
                return false;
            }
            return true;
        }
    }
}

