/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import water.fvec.Frame;
import water.fvec.Vec;
import water.rapids.ASTOp;
import water.rapids.ASTReducerOp;
import water.rapids.Env;
import water.rapids.ValNum;

class ASTMin
extends ASTReducerOp {
    ASTMin() {
        super(Double.POSITIVE_INFINITY);
    }

    @Override
    String opStr() {
        return "min";
    }

    @Override
    ASTOp make() {
        return new ASTMin();
    }

    @Override
    double op(double d0, double d1) {
        return Math.min(d0, d1);
    }

    @Override
    void apply(Env env) {
        double min = Double.POSITIVE_INFINITY;
        int argcnt = env.sp();
        block0: for (int i = 0; i < argcnt; ++i) {
            if (env.isNum()) {
                min = Math.min(min, env.popDbl());
                continue;
            }
            Frame fr = env.popAry();
            for (Vec v : fr.vecs()) {
                if (!v.isEnum() && !v.isUUID() && !v.isString()) continue;
                throw new IllegalArgumentException("`" + this.opStr() + "`" + " only defined on a data frame with all numeric variables");
            }
            for (Vec v : fr.vecs()) {
                if (v.naCnt() > 0L && !this._narm) {
                    min = Double.NaN;
                    continue block0;
                }
                min = Math.min(min, v.min());
            }
        }
        env.push(new ValNum(min));
    }
}

