/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import org.joda.time.MutableDateTime;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.rapids.AST;
import water.rapids.ASTUniPrefixOp;
import water.rapids.Env;
import water.rapids.Exec;
import water.rapids.ValFrame;
import water.rapids.ValNum;

class ASTMktime
extends ASTUniPrefixOp {
    ASTMktime() {
        super(new String[]{"", "year", "month", "day", "hour", "minute", "second", "msec"});
    }

    @Override
    String opStr() {
        return "mktime";
    }

    @Override
    ASTMktime make() {
        return new ASTMktime();
    }

    @Override
    ASTMktime parse_impl(Exec E) {
        AST yr = E.parse();
        AST mo = E.parse();
        AST dy = E.parse();
        AST hr = E.parse();
        AST mi = E.parse();
        AST se = E.parse();
        AST ms = E.parse();
        E.eatEnd();
        ASTMktime res = (ASTMktime)this.clone();
        res._asts = new AST[]{yr, mo, dy, hr, mi, se, ms};
        return res;
    }

    @Override
    void apply(Env env) {
        Frame[] fs = new Frame[7];
        int[] is = new int[7];
        Frame x = null;
        for (int i = 0; i < 7; ++i) {
            if (env.peekType() == 1) {
                fs[i] = x = env.popAry();
                continue;
            }
            is[i] = (int)env.popDbl();
        }
        if (x == null) {
            long msec = new MutableDateTime(is[6], is[5] + 1, is[4] + 1, is[3], is[2], is[1], is[0]).getMillis();
            env.poppush(1, new ValNum(msec));
            return;
        }
        Vec[] vecs = new Vec[7];
        for (int i = 0; i < 7; ++i) {
            if (fs[i] == null) {
                vecs[i] = x.anyVec().makeCon(is[i]);
                continue;
            }
            if (fs[i].numCols() != 1) {
                throw new IllegalArgumentException("Expect single column");
            }
            vecs[i] = fs[i].anyVec();
        }
        Frame fr2 = ((MRTask)new MRTask(){

            @Override
            public void map(Chunk[] chks, NewChunk[] nchks) {
                MutableDateTime dt = new MutableDateTime(0L);
                NewChunk n = nchks[0];
                int rlen = chks[0]._len;
                for (int r = 0; r < rlen; ++r) {
                    dt.setDateTime((int)chks[6].at8(r), (int)chks[5].at8(r) + 1, (int)chks[4].at8(r) + 1, (int)chks[3].at8(r), (int)chks[2].at8(r), (int)chks[1].at8(r), (int)chks[0].at8(r));
                    n.addNum(dt.getMillis());
                }
            }
        }.doAll(1, vecs)).outputFrame(new String[]{"msec"}, null);
        for (int i = 0; i < 7; ++i) {
            if (fs[i] != null) continue;
            vecs[i].remove();
        }
        env.poppush(1, new ValFrame(fr2));
    }
}

