/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;
import water.rapids.ASTOp;
import water.rapids.ASTReducerOp;
import water.rapids.Env;
import water.rapids.ValNum;

class ASTProd
extends ASTReducerOp {
    ASTProd() {
        super(1.0);
    }

    @Override
    String opStr() {
        return "prod";
    }

    @Override
    ASTOp make() {
        return new ASTProd();
    }

    @Override
    double op(double d0, double d1) {
        return d0 * d1;
    }

    @Override
    void apply(Env env) {
        double prod = this._init;
        int argcnt = this._argcnt;
        for (int i = 0; i < argcnt; ++i) {
            if (env.isNum()) {
                prod = this.op(prod, env.popDbl());
                continue;
            }
            Frame fr = env.popAry();
            for (Vec v : fr.vecs()) {
                if (!v.isEnum() && !v.isUUID() && !v.isString()) continue;
                throw new IllegalArgumentException("`" + this.opStr() + "`" + " only defined on a data frame with all numeric variables");
            }
            prod *= ((RedProd)new RedProd((boolean)this._narm).doAll((Frame)fr))._d;
        }
        env.push(new ValNum(prod));
    }

    private static class RedProd
    extends MRTask<RedProd> {
        final boolean _narm;
        double _d;

        RedProd(boolean narm) {
            this._narm = narm;
        }

        @Override
        public void map(Chunk[] chks) {
            int rows = chks[0]._len;
            for (Chunk C : chks) {
                double d;
                int r;
                double prod = 1.0;
                if (this._narm) {
                    for (r = 0; r < rows; ++r) {
                        d = C.atd(r);
                        if (Double.isNaN(d)) continue;
                        prod *= d;
                    }
                } else {
                    for (r = 0; r < rows; ++r) {
                        d = C.atd(r);
                        prod *= d;
                    }
                }
                this._d = prod;
                if (Double.isNaN(prod)) break;
            }
        }

        @Override
        public void reduce(RedProd s) {
            this._d += s._d;
        }
    }
}

