/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import hex.quantile.Quantile;
import hex.quantile.QuantileModel;
import jsr166y.CountedCompleter;
import water.DKV;
import water.H2O;
import water.Key;
import water.Keyed;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.rapids.AST;
import water.rapids.ASTDoubleList;
import water.rapids.ASTNum;
import water.rapids.ASTOp;
import water.rapids.ASTUniPrefixOp;
import water.rapids.Env;
import water.rapids.Exec;
import water.util.ArrayUtils;

public class ASTQPFPC
extends ASTUniPrefixOp {
    int _cidx;
    double[] _probs;

    @Override
    String opStr() {
        return "qpfpc";
    }

    @Override
    ASTOp make() {
        return new ASTQPFPC();
    }

    @Override
    ASTQPFPC parse_impl(Exec E) {
        AST ary = E.parse();
        this._cidx = (int)E.nextDbl();
        AST a = E.parse();
        this._probs = a instanceof ASTDoubleList ? ((ASTDoubleList)a)._d : (double[])(a instanceof ASTNum ? new double[]{((ASTNum)a)._d} : null);
        E.eatEnd();
        ASTQPFPC res = (ASTQPFPC)this.clone();
        res._probs = this._probs;
        res._asts = new AST[]{ary};
        return res;
    }

    @Override
    void apply(Env e) {
        Frame f = e.popAry();
        Vec classVec = f.vecs()[this._cidx];
        for (Vec v : f.vecs()) {
            if (v == classVec || v.isNumeric()) continue;
            throw new IllegalArgumentException("Columns must be numeric!");
        }
        final int nclasses = classVec.domain().length;
        long[] selectValues = new long[nclasses];
        for (int i = 0; i < selectValues.length; ++i) {
            selectValues[i] = i;
        }
        String[] colnames = new String[f.numCols() - 1];
        String exName = f._names[this._cidx];
        int p = 0;
        for (int i = 0; i < colnames.length; ++i) {
            if (exName.equals(f._names[i])) continue;
            colnames[p++] = f._names[i];
        }
        Vec[] vecs = new Vec[f.numCols() - 1];
        int i = 0;
        for (Vec v : f.vecs()) {
            if (v == classVec) continue;
            vecs[i++] = v;
        }
        ParallelSubsetTask t = new ParallelSubsetTask(vecs, classVec, selectValues, this._probs, colnames, classVec.domain());
        H2O.submitTask(t).join();
        final double[][][] dist = t._dist;
        String[] rownames = ArrayUtils.flat(t._rownames);
        Vec layout = Vec.makeZero(vecs.length * nclasses);
        Vec[] resultVecs = new Vec[1 + this._probs.length];
        resultVecs[0] = layout.makeCopy(rownames, (byte)4);
        for (int j = 1; j < resultVecs.length; ++j) {
            resultVecs[j] = layout.makeCopy(null);
        }
        String[] names = new String[1 + this._probs.length];
        names[0] = "rownames";
        for (int j = 1; j < names.length; ++j) {
            names[j] = "X" + this._probs[j - 1];
        }
        Frame fr2 = new Frame(names, resultVecs);
        new MRTask(){

            @Override
            public void map(Chunk[] c) {
                long start = c[0].start();
                for (int r = 0; r < c[0]._len; ++r) {
                    int i = (int)((long)r + start) / nclasses;
                    int j = (int)((long)r + start) % nclasses;
                    c[0].set(r, (long)r + start);
                    for (int v = 1; v < c.length; ++v) {
                        c[v].set(r, dist[i][j][v - 1]);
                    }
                }
            }
        }.doAll(fr2);
        layout.remove();
        e.pushAry(fr2);
    }

    private static class ParallelSubsetTask
    extends H2O.H2OCountedCompleter<ParallelSubsetTask> {
        final Vec[] _features;
        final Vec _classes;
        final long[] _selectValues;
        final double[] _probs;
        final String[] _colLabels;
        final String[] _classLabels;
        double[][][] _dist;
        String[][] _rownames;
        Key[] _fkeys;
        ParallelSubsets[] _ps;

        ParallelSubsetTask(Vec[] features, Vec classes, long[] selectValues, double[] probs, String[] colLabels, String[] classLabels) {
            this._features = features;
            this._classes = classes;
            this._selectValues = selectValues;
            this._probs = probs;
            this._dist = new double[features.length][][];
            this._colLabels = colLabels;
            this._classLabels = classLabels;
            this._rownames = new String[features.length][];
        }

        @Override
        protected void compute2() {
            int i;
            this.addToPendingCount(this._features.length - 1);
            this._ps = new ParallelSubsets[this._features.length];
            Key[][] fkeys = new Key[this._features.length][this._selectValues.length];
            for (i = 0; i < fkeys.length; ++i) {
                for (int j = 0; j < this._selectValues.length; ++j) {
                    fkeys[i][j] = Key.make();
                }
            }
            this._fkeys = ArrayUtils.flat(fkeys);
            for (i = 0; i < this._features.length; ++i) {
                this._ps[i] = new ParallelSubsets(new Callback(i), this._features[i], this._classes, this._selectValues, fkeys[i], this._probs, this._classLabels, this._colLabels[i]);
                this._ps[i].fork();
            }
        }

        @Override
        public void onCompletion(CountedCompleter cc) {
            for (Key k : this._fkeys) {
                Keyed.remove(k);
            }
            this._fkeys = null;
        }

        private class Callback
        extends H2O.H2OCallback {
            int _i;

            public Callback(int i) {
                super(ParallelSubsetTask.this);
                this._i = i;
            }

            public void callback(H2O.H2OCountedCompleter h2OCountedCompleter) {
                ParallelSubsetTask.this._dist[this._i] = ParallelSubsetTask.this._ps[this._i]._dist;
                ParallelSubsetTask.this._rownames[this._i] = ParallelSubsetTask.this._ps[this._i]._rownames;
            }
        }
    }

    private static class ParallelSubsets
    extends H2O.H2OCountedCompleter<ParallelSubsets> {
        final Vec _feature;
        final Vec _class;
        final long[] _selectValues;
        final Key[] _frameKeys;
        final double[] _probs;
        final String[] _classLabels;
        final String _colLabel;
        double[][] _dist;
        String[] _rownames;

        ParallelSubsets(H2O.H2OCountedCompleter cc, Vec f, Vec c, long[] selectValues, Key[] frameKeys, double[] probs, String[] classLabels, String colLabel) {
            super(cc);
            this._feature = f;
            this._class = c;
            this._selectValues = selectValues;
            this._frameKeys = frameKeys;
            this._probs = probs;
            this._dist = new double[this._selectValues.length][this._probs.length];
            this._classLabels = classLabels;
            this._colLabel = colLabel;
            this._rownames = new String[this._selectValues.length];
        }

        @Override
        protected void compute2() {
            this.addToPendingCount(2 * this._selectValues.length - 1);
            int i = 0;
            for (long l : this._selectValues) {
                Frame f = new Frame(this._feature, this._class);
                this._rownames[i] = this._classLabels[i] + "_" + this._colLabel;
                new SubsetTask(new QuantileCallback(i), l, f, this._frameKeys[i++]).fork();
            }
        }

        private class QuantileCallback2
        extends H2O.H2OCallback {
            int _i;
            QuantileCallback _q;

            public QuantileCallback2(int i, QuantileCallback q) {
                super(ParallelSubsets.this);
                this._i = i;
                this._q = q;
            }

            public void callback(H2O.H2OCountedCompleter cc) {
                ParallelSubsets.this._dist[this._i] = this._q._q._quantiles[0];
                Keyed.remove(ParallelSubsets.this._frameKeys[this._i]);
            }
        }

        private class QuantileCallback
        extends H2O.H2OCallback {
            int _i;
            Quantile.QTask _q;

            public QuantileCallback(int i) {
                super(ParallelSubsets.this);
                this._i = i;
            }

            public void callback(H2O.H2OCountedCompleter cc) {
                QuantileModel.QuantileParameters parms = new QuantileModel.QuantileParameters();
                parms._probs = ParallelSubsets.this._probs;
                parms._train = ParallelSubsets.this._frameKeys[this._i];
                this._q = new Quantile.QTask(new QuantileCallback2(this._i, this), ParallelSubsets.this._probs, (Frame)DKV.getGet(ParallelSubsets.this._frameKeys[this._i]), QuantileModel.CombineMethod.INTERPOLATE);
                this._q.fork();
            }
        }
    }

    private static class SubsetTask
    extends H2O.H2OCountedCompleter<SubsetTask> {
        final long _selectValue;
        final Frame _fr;
        final Key _key;

        SubsetTask(H2O.H2OCountedCompleter cc, long s, Frame fr, Key key) {
            super(cc);
            this._selectValue = s;
            this._fr = fr;
            this._key = key;
        }

        @Override
        protected void compute2() {
            Frame f = ((MRTask)new MRTask(){

                @Override
                public void map(Chunk[] c, NewChunk nc) {
                    for (int i = 0; i < c[0]._len; ++i) {
                        if (c[1].at8(i) != SubsetTask.this._selectValue) continue;
                        nc.addNum(c[0].atd(i));
                    }
                }
            }.doAll(1, this._fr, false)).outputFrame(this._key, new String[]{this._fr.names()[0]}, null);
            DKV.put(this._key, f);
            this.tryComplete();
        }
    }
}

