/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import hex.quantile.Quantile;
import hex.quantile.QuantileModel;
import water.DKV;
import water.Key;
import water.fvec.Frame;
import water.fvec.Vec;
import water.rapids.AST;
import water.rapids.ASTDoubleList;
import water.rapids.ASTUniPrefixOp;
import water.rapids.Env;
import water.rapids.Exec;

class ASTQtile
extends ASTUniPrefixOp {
    double[] _probs = null;
    QuantileModel.CombineMethod _combine_method = null;

    @Override
    String opStr() {
        return "quantile";
    }

    public ASTQtile() {
        super(new String[]{"quantile", "x", "probs", "combine_method"});
    }

    @Override
    ASTQtile make() {
        return new ASTQtile();
    }

    @Override
    ASTQtile parse_impl(Exec E) {
        AST[] aSTArray;
        AST ary = E.parse();
        AST seq = E.parse();
        if (seq instanceof ASTDoubleList) {
            this._probs = ((ASTDoubleList)seq)._d;
            seq = null;
        } else {
            this._probs = null;
        }
        this._combine_method = QuantileModel.CombineMethod.valueOf(E.nextStr().toUpperCase());
        E.eatEnd();
        ASTQtile res = (ASTQtile)this.clone();
        if (seq == null) {
            AST[] aSTArray2 = new AST[1];
            aSTArray = aSTArray2;
            aSTArray2[0] = ary;
        } else {
            AST[] aSTArray3 = new AST[2];
            aSTArray3[0] = ary;
            aSTArray = aSTArray3;
            aSTArray3[1] = seq;
        }
        res._asts = aSTArray;
        return res;
    }

    @Override
    void apply(Env env) {
        QuantileModel.QuantileParameters parms = new QuantileModel.QuantileParameters();
        parms._probs = this._probs;
        if (this._probs == null) {
            if (env.isAry()) {
                Frame probs = env.popAry();
                if (probs.numCols() != 1) {
                    throw new IllegalArgumentException("Probs must be a single vector.");
                }
                Vec pv = probs.anyVec();
                parms._probs = new double[(int)pv.length()];
                double[] p = parms._probs;
                int i = 0;
                while ((long)i < pv.length()) {
                    p[i] = pv.at(i);
                    if (p[i] < 0.0 || p[i] > 1.0) {
                        throw new IllegalArgumentException("Quantile: probs must be in the range of [0, 1].");
                    }
                    ++i;
                }
            } else if (env.isNum()) {
                parms._probs = new double[1];
                double[] p = parms._probs;
                p[0] = env.popDbl();
                if (p[0] < 0.0 || p[0] > 1.0) {
                    throw new IllegalArgumentException("Quantile: probs must be in the range of [0, 1].");
                }
            }
        }
        parms._combine_method = this._combine_method;
        Frame x = env.popAry();
        Key tk = null;
        if (x._key == null) {
            tk = Key.make();
            x = new Frame(tk, x.names(), x.vecs());
            DKV.put(tk, x);
        }
        parms._train = x._key;
        QuantileModel q = (QuantileModel)new Quantile(parms).trainModel().get();
        if (tk != null) {
            DKV.remove(tk);
        }
        Vec shape = Vec.makeZero(parms._probs.length);
        Key<Vec>[] keys = shape.group().addVecs(1 + x.numCols());
        Vec[] vecs = new Vec[keys.length];
        String[] names = new String[keys.length];
        vecs[0] = Vec.makeCon(keys[0], parms._probs);
        DKV.put(keys[0], vecs[0]);
        names[0] = "Probs";
        for (int i = 1; i <= x.numCols(); ++i) {
            vecs[i] = Vec.makeCon(keys[i], ((QuantileModel.QuantileOutput)q._output)._quantiles[i - 1]);
            DKV.put(keys[i], vecs[i]);
            names[i] = x._names[i - 1] + "Quantiles";
        }
        Frame fr = new Frame(names, vecs);
        q.delete();
        shape.remove();
        this._probs = null;
        parms._probs = null;
        env.pushAry(fr);
    }
}

