/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import java.util.ArrayList;
import water.Key;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;
import water.rapids.AST;
import water.rapids.ASTAssign;
import water.rapids.ASTDoubleList;
import water.rapids.ASTFrame;
import water.rapids.ASTId;
import water.rapids.ASTList;
import water.rapids.ASTLongList;
import water.rapids.ASTNum;
import water.rapids.ASTOp;
import water.rapids.ASTSlice;
import water.rapids.Env;
import water.rapids.Exec;
import water.rapids.ValNum;

abstract class ASTReducerOp
extends ASTOp {
    double _init;
    boolean _narm;
    int _argcnt;

    ASTReducerOp(double init) {
        super(new String[]{"", "dblary", "...", "na.rm"});
        this._init = init;
    }

    @Override
    ASTReducerOp parse_impl(Exec E) {
        AST a;
        ArrayList<AST> dblarys = new ArrayList<AST>();
        do {
            if ((a = E.parse()) instanceof ASTId) {
                if (Env.staticLookup((ASTId)a) instanceof ASTFrame) {
                    dblarys.add(a);
                }
                if (E._env.tryLookup((ASTId)a)) break;
                dblarys.add(a);
                continue;
            }
            if (a instanceof ASTAssign || a instanceof ASTNum || a instanceof ASTFrame || a instanceof ASTSlice || a instanceof ASTOp) {
                dblarys.add(a);
                continue;
            }
            if (!(a instanceof ASTList)) break;
            if (a instanceof ASTLongList) {
                for (long l : ((ASTLongList)a)._l) {
                    dblarys.add(new ASTNum(l));
                }
            } else {
                for (double d : ((ASTDoubleList)a)._d) {
                    dblarys.add(new ASTNum(d));
                }
            }
        } while (!E.isEnd());
        if (!E.isEnd()) {
            a = E.parse();
            if (!(a instanceof ASTId)) {
                throw new IllegalArgumentException("Expected the na.rm value to be one of %TRUE, %FALSE, %T, %F");
            }
            a = E._env.lookup((ASTId)a);
            this._narm = ((ASTNum)a).dbl() == 1.0;
        } else {
            this._narm = true;
        }
        E.eatEnd();
        this._argcnt = dblarys.size();
        AST[] aSTArray = new AST[this._argcnt];
        for (int i = 0; i < dblarys.size(); ++i) {
            aSTArray[i] = (AST)dblarys.get(i);
        }
        ASTReducerOp res = (ASTReducerOp)this.clone();
        res._asts = aSTArray;
        return res;
    }

    @Override
    double[] map(Env env, double[] in, double[] out, AST[] args) {
        double s = this._init;
        for (double v : in) {
            if (this._narm && Double.isNaN(v)) continue;
            s = this.op(s, v);
        }
        if (out == null || out.length < 1) {
            out = new double[]{s};
        }
        return out;
    }

    abstract double op(double var1, double var3);

    @Override
    void apply(Env env) {
        double sum = this._init;
        int argcnt = this._argcnt;
        for (int i = 0; i < argcnt; ++i) {
            if (env.isNum()) {
                sum = this.op(sum, env.popDbl());
                continue;
            }
            Frame fr = env.popAry();
            for (Vec v : fr.vecs()) {
                if (!v.isEnum() && !v.isUUID() && !v.isString()) continue;
                throw new IllegalArgumentException("`" + this.opStr() + "`" + " only defined on a data frame with all numeric variables");
            }
            sum = this.op(sum, this._narm ? ((NaRmRedOp)new NaRmRedOp((ASTReducerOp)this).doAll((Frame)fr))._d : ((RedOp)new RedOp((ASTReducerOp)this).doAll((Frame)fr))._d);
        }
        env.push(new ValNum(sum));
    }

    @Override
    void exec(Env e, AST[] args) {
        this._argcnt = args.length;
        this._init = 0.0;
        this._narm = true;
        args[0].exec(e);
        e.put(Key.make().toString(), e.peekAry());
        this.apply(e);
    }

    private static class NaRmRedOp
    extends MRTask<NaRmRedOp> {
        final ASTReducerOp _bin;
        double _d;

        NaRmRedOp(ASTReducerOp bin) {
            this._bin = bin;
            this._d = bin._init;
        }

        @Override
        public void map(Chunk[] chks) {
            int rows = chks[0]._len;
            for (Chunk C : chks) {
                assert (C.vec().isNumeric());
                double sum = this._d;
                for (int r = 0; r < rows; ++r) {
                    double d = C.atd(r);
                    if (Double.isNaN(d)) continue;
                    sum = this._bin.op(sum, d);
                }
                this._d = sum;
                if (Double.isNaN(sum)) break;
            }
        }

        @Override
        public void reduce(NaRmRedOp s) {
            this._d = this._bin.op(this._d, s._d);
        }
    }

    private static class RedOp
    extends MRTask<RedOp> {
        final ASTReducerOp _bin;
        double _d;

        RedOp(ASTReducerOp bin) {
            this._bin = bin;
            this._d = bin._init;
        }

        @Override
        public void map(Chunk[] chks) {
            int rows = chks[0]._len;
            for (Chunk C : chks) {
                assert (C.vec().isNumeric());
                double sum = this._d;
                for (int r = 0; r < rows; ++r) {
                    sum = this._bin.op(sum, C.atd(r));
                }
                this._d = sum;
                if (Double.isNaN(sum)) break;
            }
        }

        @Override
        public void reduce(RedOp s) {
            this._d = this._bin.op(this._d, s._d);
        }
    }
}

